# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .company_data import CompanyData


class ContactCompanies(UncheckedBaseModel):
    """
    An object with metadata about companies attached to a contact . Up to 10 will be displayed here. Use the url to get more.
    """

    data: typing.Optional[typing.List[CompanyData]] = pydantic.Field(default=None)
    """
    An array of company data objects attached to the contact.
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Url to get more company resources for this contact
    """

    total_count: typing.Optional[int] = pydantic.Field(default=None)
    """
    Integer representing the total number of companies attached to this contact
    """

    has_more: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether there's more Addressable Objects to be viewed. If true, use the url to view all
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
