# This file was auto-generated by Fern from our API Definition.

import typing

from ..contacts.types.contact import Contact
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.update_visitor_request import UpdateVisitorRequest
from ..types.visitor import Visitor
from .raw_client import AsyncRawVisitorsClient, RawVisitorsClient
from .types.convert_visitor_request_user import ConvertVisitorRequestUser
from .types.convert_visitor_request_visitor import ConvertVisitorRequestVisitor

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class VisitorsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawVisitorsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawVisitorsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawVisitorsClient
        """
        return self._raw_client

    def find(self, *, user_id: str, request_options: typing.Optional[RequestOptions] = None) -> Visitor:
        """
        You can fetch the details of a single visitor.

        Parameters
        ----------
        user_id : str
            The user_id of the Visitor you want to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Visitor
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.visitors.find(
            user_id="user_id",
        )
        """
        _response = self._raw_client.find(user_id=user_id, request_options=request_options)
        return _response.data

    def update(
        self, *, request: UpdateVisitorRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> Visitor:
        """
        Sending a PUT request to `/visitors` will result in an update of an existing Visitor.

        **Option 1.** You can update a visitor by passing in the `user_id` of the visitor in the Request body.

        **Option 2.** You can update a visitor by passing in the `id` of the visitor in the Request body.

        Parameters
        ----------
        request : UpdateVisitorRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Visitor
            successful

        Examples
        --------
        from intercom import Intercom, UpdateVisitorRequestWithId

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.visitors.update(
            request=UpdateVisitorRequestWithId(
                id="667d61cc8a68186f43bafe95",
                name="Gareth Bale",
            ),
        )
        """
        _response = self._raw_client.update(request=request, request_options=request_options)
        return _response.data

    def merge_to_contact(
        self,
        *,
        type: str,
        user: ConvertVisitorRequestUser,
        visitor: ConvertVisitorRequestVisitor,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Contact:
        """
        You can merge a Visitor to a Contact of role type `lead` or `user`.

        > 📘 What happens upon a visitor being converted?
        >
        > If the User exists, then the Visitor will be merged into it, the Visitor deleted and the User returned. If the User does not exist, the Visitor will be converted to a User, with the User identifiers replacing it's Visitor identifiers.

        Parameters
        ----------
        type : str
            Represents the role of the Contact model. Accepts `lead` or `user`.

        user : ConvertVisitorRequestUser
            The unique identifiers retained after converting or merging.

        visitor : ConvertVisitorRequestVisitor
            The unique identifiers to convert a single Visitor.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Contact
            successful

        Examples
        --------
        from intercom import Intercom
        from intercom.visitors import UserWithId, VisitorWithUserId

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.visitors.merge_to_contact(
            type="user",
            user=UserWithId(
                id="8a88a590-e1c3-41e2-a502-e0649dbf721c",
                email="foo@bar.com",
            ),
            visitor=VisitorWithUserId(
                user_id="3ecf64d0-9ed1-4e9f-88e1-da7d6e6782f3",
            ),
        )
        """
        _response = self._raw_client.merge_to_contact(
            type=type, user=user, visitor=visitor, request_options=request_options
        )
        return _response.data


class AsyncVisitorsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawVisitorsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawVisitorsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawVisitorsClient
        """
        return self._raw_client

    async def find(self, *, user_id: str, request_options: typing.Optional[RequestOptions] = None) -> Visitor:
        """
        You can fetch the details of a single visitor.

        Parameters
        ----------
        user_id : str
            The user_id of the Visitor you want to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Visitor
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.visitors.find(
                user_id="user_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.find(user_id=user_id, request_options=request_options)
        return _response.data

    async def update(
        self, *, request: UpdateVisitorRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> Visitor:
        """
        Sending a PUT request to `/visitors` will result in an update of an existing Visitor.

        **Option 1.** You can update a visitor by passing in the `user_id` of the visitor in the Request body.

        **Option 2.** You can update a visitor by passing in the `id` of the visitor in the Request body.

        Parameters
        ----------
        request : UpdateVisitorRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Visitor
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom, UpdateVisitorRequestWithId

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.visitors.update(
                request=UpdateVisitorRequestWithId(
                    id="667d61cc8a68186f43bafe95",
                    name="Gareth Bale",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(request=request, request_options=request_options)
        return _response.data

    async def merge_to_contact(
        self,
        *,
        type: str,
        user: ConvertVisitorRequestUser,
        visitor: ConvertVisitorRequestVisitor,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Contact:
        """
        You can merge a Visitor to a Contact of role type `lead` or `user`.

        > 📘 What happens upon a visitor being converted?
        >
        > If the User exists, then the Visitor will be merged into it, the Visitor deleted and the User returned. If the User does not exist, the Visitor will be converted to a User, with the User identifiers replacing it's Visitor identifiers.

        Parameters
        ----------
        type : str
            Represents the role of the Contact model. Accepts `lead` or `user`.

        user : ConvertVisitorRequestUser
            The unique identifiers retained after converting or merging.

        visitor : ConvertVisitorRequestVisitor
            The unique identifiers to convert a single Visitor.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Contact
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom
        from intercom.visitors import UserWithId, VisitorWithUserId

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.visitors.merge_to_contact(
                type="user",
                user=UserWithId(
                    id="8a88a590-e1c3-41e2-a502-e0649dbf721c",
                    email="foo@bar.com",
                ),
                visitor=VisitorWithUserId(
                    user_id="3ecf64d0-9ed1-4e9f-88e1-da7d6e6782f3",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.merge_to_contact(
            type=type, user=user, visitor=visitor, request_options=request_options
        )
        return _response.data
