# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..contacts.types.contact import Contact
from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..core.unchecked_base_model import construct_type
from ..errors.not_found_error import NotFoundError
from ..errors.unauthorized_error import UnauthorizedError
from ..types.error import Error
from ..types.update_visitor_request import UpdateVisitorRequest
from ..types.visitor import Visitor
from .types.convert_visitor_request_user import ConvertVisitorRequestUser
from .types.convert_visitor_request_visitor import ConvertVisitorRequestVisitor

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawVisitorsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def find(self, *, user_id: str, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[Visitor]:
        """
        You can fetch the details of a single visitor.

        Parameters
        ----------
        user_id : str
            The user_id of the Visitor you want to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Visitor]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            "visitors",
            method="GET",
            params={
                "user_id": user_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Visitor,
                    construct_type(
                        type_=Visitor,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self, *, request: UpdateVisitorRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[Visitor]:
        """
        Sending a PUT request to `/visitors` will result in an update of an existing Visitor.

        **Option 1.** You can update a visitor by passing in the `user_id` of the visitor in the Request body.

        **Option 2.** You can update a visitor by passing in the `id` of the visitor in the Request body.

        Parameters
        ----------
        request : UpdateVisitorRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Visitor]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            "visitors",
            method="PUT",
            json=convert_and_respect_annotation_metadata(
                object_=request, annotation=UpdateVisitorRequest, direction="write"
            ),
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Visitor,
                    construct_type(
                        type_=Visitor,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def merge_to_contact(
        self,
        *,
        type: str,
        user: ConvertVisitorRequestUser,
        visitor: ConvertVisitorRequestVisitor,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Contact]:
        """
        You can merge a Visitor to a Contact of role type `lead` or `user`.

        > 📘 What happens upon a visitor being converted?
        >
        > If the User exists, then the Visitor will be merged into it, the Visitor deleted and the User returned. If the User does not exist, the Visitor will be converted to a User, with the User identifiers replacing it's Visitor identifiers.

        Parameters
        ----------
        type : str
            Represents the role of the Contact model. Accepts `lead` or `user`.

        user : ConvertVisitorRequestUser
            The unique identifiers retained after converting or merging.

        visitor : ConvertVisitorRequestVisitor
            The unique identifiers to convert a single Visitor.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Contact]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            "visitors/convert",
            method="POST",
            json={
                "type": type,
                "user": convert_and_respect_annotation_metadata(
                    object_=user, annotation=ConvertVisitorRequestUser, direction="write"
                ),
                "visitor": convert_and_respect_annotation_metadata(
                    object_=visitor, annotation=ConvertVisitorRequestVisitor, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Contact,
                    construct_type(
                        type_=Contact,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawVisitorsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def find(
        self, *, user_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[Visitor]:
        """
        You can fetch the details of a single visitor.

        Parameters
        ----------
        user_id : str
            The user_id of the Visitor you want to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Visitor]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            "visitors",
            method="GET",
            params={
                "user_id": user_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Visitor,
                    construct_type(
                        type_=Visitor,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self, *, request: UpdateVisitorRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[Visitor]:
        """
        Sending a PUT request to `/visitors` will result in an update of an existing Visitor.

        **Option 1.** You can update a visitor by passing in the `user_id` of the visitor in the Request body.

        **Option 2.** You can update a visitor by passing in the `id` of the visitor in the Request body.

        Parameters
        ----------
        request : UpdateVisitorRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Visitor]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            "visitors",
            method="PUT",
            json=convert_and_respect_annotation_metadata(
                object_=request, annotation=UpdateVisitorRequest, direction="write"
            ),
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Visitor,
                    construct_type(
                        type_=Visitor,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def merge_to_contact(
        self,
        *,
        type: str,
        user: ConvertVisitorRequestUser,
        visitor: ConvertVisitorRequestVisitor,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Contact]:
        """
        You can merge a Visitor to a Contact of role type `lead` or `user`.

        > 📘 What happens upon a visitor being converted?
        >
        > If the User exists, then the Visitor will be merged into it, the Visitor deleted and the User returned. If the User does not exist, the Visitor will be converted to a User, with the User identifiers replacing it's Visitor identifiers.

        Parameters
        ----------
        type : str
            Represents the role of the Contact model. Accepts `lead` or `user`.

        user : ConvertVisitorRequestUser
            The unique identifiers retained after converting or merging.

        visitor : ConvertVisitorRequestVisitor
            The unique identifiers to convert a single Visitor.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Contact]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            "visitors/convert",
            method="POST",
            json={
                "type": type,
                "user": convert_and_respect_annotation_metadata(
                    object_=user, annotation=ConvertVisitorRequestUser, direction="write"
                ),
                "visitor": convert_and_respect_annotation_metadata(
                    object_=visitor, annotation=ConvertVisitorRequestVisitor, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Contact,
                    construct_type(
                        type_=Contact,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
