# coding: utf-8

"""
    Phoenix API

    Base API for Glumanda and other services.

    The version of the OpenAPI document: Alpha
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from phoenix_sdk.models.order_status import OrderStatus
from typing import Optional, Set
from typing_extensions import Self

class ShopOrderSchemaOUT(BaseModel):
    """
    ShopOrderSchemaOUT
    """ # noqa: E501
    created_by_id: StrictStr
    id: StrictStr
    created_at: datetime
    updated_at: datetime
    order: Optional[List[Dict[str, Any]]] = None
    stripe_invoice_id: StrictStr
    pandadoc_offer_id: Optional[StrictStr] = None
    company_id: Optional[StrictStr] = None
    order_status: OrderStatus
    invoice_url: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["created_by_id", "id", "created_at", "updated_at", "order", "stripe_invoice_id", "pandadoc_offer_id", "company_id", "order_status", "invoice_url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ShopOrderSchemaOUT from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ShopOrderSchemaOUT from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "created_by_id": obj.get("created_by_id"),
            "id": obj.get("id"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "order": obj.get("order"),
            "stripe_invoice_id": obj.get("stripe_invoice_id"),
            "pandadoc_offer_id": obj.get("pandadoc_offer_id"),
            "company_id": obj.get("company_id"),
            "order_status": obj.get("order_status"),
            "invoice_url": obj.get("invoice_url")
        })
        return _obj


