/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms;

import com.amazonaws.ml.mms.http.ApiDescriptionRequestHandler;
import com.amazonaws.ml.mms.http.HttpRequestHandler;
import com.amazonaws.ml.mms.http.HttpRequestHandlerChain;
import com.amazonaws.ml.mms.http.InferenceRequestHandler;
import com.amazonaws.ml.mms.http.InvalidRequestHandler;
import com.amazonaws.ml.mms.http.ManagementRequestHandler;
import com.amazonaws.ml.mms.servingsdk.impl.PluginsManager;
import com.amazonaws.ml.mms.util.ConfigManager;
import com.amazonaws.ml.mms.util.ConnectorType;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.ssl.SslContext;

public class ServerInitializer
extends ChannelInitializer<Channel> {
    private ConnectorType connectorType;
    private SslContext sslCtx;

    public ServerInitializer(SslContext sslCtx, ConnectorType type) {
        this.sslCtx = sslCtx;
        this.connectorType = type;
    }

    @Override
    public void initChannel(Channel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        ApiDescriptionRequestHandler apiDescriptionRequestHandler = new ApiDescriptionRequestHandler(this.connectorType);
        InvalidRequestHandler invalidRequestHandler = new InvalidRequestHandler();
        int maxRequestSize = ConfigManager.getInstance().getMaxRequestSize();
        if (this.sslCtx != null) {
            pipeline.addLast("ssl", (ChannelHandler)this.sslCtx.newHandler(ch.alloc()));
        }
        pipeline.addLast("http", (ChannelHandler)new HttpServerCodec());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(maxRequestSize));
        HttpRequestHandlerChain httpRequestHandlerChain = apiDescriptionRequestHandler;
        if (ConnectorType.BOTH.equals((Object)this.connectorType) || ConnectorType.INFERENCE_CONNECTOR.equals((Object)this.connectorType)) {
            httpRequestHandlerChain = httpRequestHandlerChain.setNextHandler(new InferenceRequestHandler(PluginsManager.getInstance().getInferenceEndpoints()));
        }
        if (ConnectorType.BOTH.equals((Object)this.connectorType) || ConnectorType.MANAGEMENT_CONNECTOR.equals((Object)this.connectorType)) {
            httpRequestHandlerChain = httpRequestHandlerChain.setNextHandler(new ManagementRequestHandler(PluginsManager.getInstance().getManagementEndpoints()));
        }
        httpRequestHandlerChain.setNextHandler(invalidRequestHandler);
        pipeline.addLast("handler", (ChannelHandler)new HttpRequestHandler(apiDescriptionRequestHandler));
    }
}

