/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.archive;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public final class ZipUtils {
    private ZipUtils() {
    }

    public static void zip(File src, File dest, boolean includeRootDir) throws IOException {
        int prefix = src.getCanonicalPath().length();
        if (includeRootDir) {
            prefix -= src.getName().length();
        }
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(dest));){
            ZipUtils.addToZip(prefix, src, null, zos);
        }
    }

    public static void unzip(File src, File dest) throws IOException {
        ZipUtils.unzip(new FileInputStream(src), dest);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unzip(InputStream is, File dest) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(is);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                FileOutputStream os;
                block23: {
                    String name = entry.getName();
                    File file = new File(dest, name);
                    if (entry.isDirectory()) {
                        FileUtils.forceMkdir(file);
                        continue;
                    }
                    File parentFile = file.getParentFile();
                    FileUtils.forceMkdir(parentFile);
                    os = new FileOutputStream(file);
                    Throwable throwable = null;
                    try {
                        IOUtils.copy((InputStream)zis, (OutputStream)os);
                        if (os == null) continue;
                        if (throwable == null) break block23;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (os == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    ((OutputStream)os).close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            ((OutputStream)os).close();
                            throw throwable3;
                        }
                    }
                    try {
                        ((OutputStream)os).close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                ((OutputStream)os).close();
            }
            return;
        }
    }

    public static void addToZip(int prefix, File file, FileFilter filter, ZipOutputStream zos) throws IOException {
        block17: {
            String name;
            block16: {
                File[] files;
                name = file.getCanonicalPath().substring(prefix);
                if (name.startsWith("/")) {
                    name = name.substring(1);
                }
                if (!file.isDirectory()) break block16;
                if (!name.isEmpty()) {
                    ZipEntry entry = new ZipEntry(name + '/');
                    zos.putNextEntry(entry);
                }
                if ((files = file.listFiles(filter)) == null) break block17;
                for (File f : files) {
                    ZipUtils.addToZip(prefix, f, filter, zos);
                }
                break block17;
            }
            if (file.isFile()) {
                ZipEntry entry = new ZipEntry(name);
                zos.putNextEntry(entry);
                try (FileInputStream fis = new FileInputStream(file);){
                    IOUtils.copy((InputStream)fis, (OutputStream)zos);
                }
            }
        }
    }
}

