/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.http.messages;

import com.amazonaws.ml.mms.util.ConfigManager;
import com.amazonaws.ml.mms.util.NettyUtils;
import com.google.gson.annotations.SerializedName;
import io.netty.handler.codec.http.QueryStringDecoder;

public class RegisterModelRequest {
    @SerializedName(value="model_name")
    private String modelName;
    @SerializedName(value="runtime")
    private String runtime;
    @SerializedName(value="handler")
    private String handler;
    @SerializedName(value="batch_size")
    private int batchSize;
    @SerializedName(value="max_batch_delay")
    private int maxBatchDelay;
    @SerializedName(value="initial_workers")
    private int initialWorkers;
    @SerializedName(value="synchronous")
    private boolean synchronous;
    @SerializedName(value="response_timeout")
    private int responseTimeout;
    @SerializedName(value="url")
    private String modelUrl;

    public RegisterModelRequest(QueryStringDecoder decoder) {
        this.modelName = NettyUtils.getParameter(decoder, "model_name", null);
        this.runtime = NettyUtils.getParameter(decoder, "runtime", null);
        this.handler = NettyUtils.getParameter(decoder, "handler", null);
        this.batchSize = NettyUtils.getIntParameter(decoder, "batch_size", 1);
        this.maxBatchDelay = NettyUtils.getIntParameter(decoder, "max_batch_delay", 100);
        this.initialWorkers = NettyUtils.getIntParameter(decoder, "initial_workers", ConfigManager.getInstance().getConfiguredDefaultWorkersPerModel());
        this.synchronous = Boolean.parseBoolean(NettyUtils.getParameter(decoder, "synchronous", "true"));
        this.responseTimeout = NettyUtils.getIntParameter(decoder, "response_timeout", -1);
        this.modelUrl = NettyUtils.getParameter(decoder, "url", null);
    }

    public RegisterModelRequest() {
        this.batchSize = 1;
        this.maxBatchDelay = 100;
        this.initialWorkers = 0;
        this.responseTimeout = -1;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getRuntime() {
        return this.runtime;
    }

    public String getHandler() {
        return this.handler;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public Integer getMaxBatchDelay() {
        return this.maxBatchDelay;
    }

    public Integer getInitialWorkers() {
        return this.initialWorkers;
    }

    public Boolean getSynchronous() {
        return this.synchronous;
    }

    public Integer getResponseTimeout() {
        return this.responseTimeout;
    }

    public String getModelUrl() {
        return this.modelUrl;
    }
}

