/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.metrics;

import com.amazonaws.ml.mms.metrics.Dimension;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Metric {
    private static final Pattern PATTERN = Pattern.compile("\\s*(\\w+)\\.(\\w+):([0-9\\-,.e]+)\\|#([^|]*)\\|#hostname:([^,]+),([^,]+)(,(.*))?");
    @SerializedName(value="MetricName")
    private String metricName;
    @SerializedName(value="Value")
    private String value;
    @SerializedName(value="Unit")
    private String unit;
    @SerializedName(value="Dimensions")
    private List<Dimension> dimensions;
    @SerializedName(value="Timestamp")
    private String timestamp;
    @SerializedName(value="RequestId")
    private String requestId;
    @SerializedName(value="HostName")
    private String hostName;

    public Metric() {
    }

    public Metric(String metricName, String value, String unit, String hostName, Dimension ... dimensions) {
        this.metricName = metricName;
        this.value = value;
        this.unit = unit;
        this.hostName = hostName;
        this.dimensions = Arrays.asList(dimensions);
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(List<Dimension> dimensions) {
        this.dimensions = dimensions;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public static Metric parse(String line) {
        Matcher matcher = PATTERN.matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        Metric metric = new Metric();
        metric.setMetricName(matcher.group(1));
        metric.setUnit(matcher.group(2));
        metric.setValue(matcher.group(3));
        String dimensions = matcher.group(4);
        metric.setHostName(matcher.group(5));
        metric.setTimestamp(matcher.group(6));
        metric.setRequestId(matcher.group(8));
        if (dimensions != null) {
            String[] dimension = dimensions.split(",");
            ArrayList<Dimension> list = new ArrayList<Dimension>(dimension.length);
            for (String dime : dimension) {
                String[] pair = dime.split(":");
                if (pair.length != 2) continue;
                list.add(new Dimension(pair[0], pair[1]));
            }
            metric.setDimensions(list);
        }
        return metric;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this.metricName).append('.').append(this.unit).append(':').append(this.getValue()).append("|#");
        boolean first = true;
        for (Dimension dimension : this.getDimensions()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(dimension.getName()).append(':').append(dimension.getValue());
        }
        sb.append("|#hostname:").append(this.hostName);
        if (this.requestId != null) {
            sb.append(",requestID:").append(this.requestId);
        }
        sb.append(",timestamp:").append(this.timestamp);
        return sb.toString();
    }
}

