/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.servingsdk.impl;

import com.amazonaws.ml.mms.http.InvalidPluginException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.ai.mms.servingsdk.ModelServerEndpoint;
import software.amazon.ai.mms.servingsdk.annotations.Endpoint;
import software.amazon.ai.mms.servingsdk.annotations.helpers.EndpointTypes;

public final class PluginsManager {
    private static final PluginsManager INSTANCE = new PluginsManager();
    private Logger logger = LoggerFactory.getLogger(PluginsManager.class);
    private Map<String, ModelServerEndpoint> inferenceEndpoints;
    private Map<String, ModelServerEndpoint> managementEndpoints;

    private PluginsManager() {
    }

    public static PluginsManager getInstance() {
        return INSTANCE;
    }

    public void initialize() {
        this.inferenceEndpoints = this.initInferenceEndpoints();
        this.managementEndpoints = this.initManagementEndpoints();
    }

    private boolean validateEndpointPlugin(Annotation a, EndpointTypes type) {
        return a instanceof Endpoint && !((Endpoint)a).urlPattern().isEmpty() && ((Endpoint)a).endpointType().equals((Object)type);
    }

    private HashMap<String, ModelServerEndpoint> getEndpoints(EndpointTypes type) throws InvalidPluginException {
        ServiceLoader<ModelServerEndpoint> loader = ServiceLoader.load(ModelServerEndpoint.class);
        HashMap<String, ModelServerEndpoint> ep = new HashMap<String, ModelServerEndpoint>();
        for (ModelServerEndpoint mep : loader) {
            Annotation[] annotations;
            Class<?> modelServerEndpointClassObj = mep.getClass();
            for (Annotation a : annotations = modelServerEndpointClassObj.getAnnotations()) {
                if (!this.validateEndpointPlugin(a, type)) continue;
                if (ep.get(((Endpoint)a).urlPattern()) != null) {
                    throw new InvalidPluginException("Multiple plugins found for endpoint \"" + ((Endpoint)a).urlPattern() + "\"");
                }
                this.logger.info("Loading plugin for endpoint {}", (Object)((Endpoint)a).urlPattern());
                ep.put(((Endpoint)a).urlPattern(), mep);
            }
        }
        return ep;
    }

    private HashMap<String, ModelServerEndpoint> initInferenceEndpoints() {
        return this.getEndpoints(EndpointTypes.INFERENCE);
    }

    private HashMap<String, ModelServerEndpoint> initManagementEndpoints() {
        return this.getEndpoints(EndpointTypes.MANAGEMENT);
    }

    public Map<String, ModelServerEndpoint> getInferenceEndpoints() {
        return this.inferenceEndpoints;
    }

    public Map<String, ModelServerEndpoint> getManagementEndpoints() {
        return this.managementEndpoints;
    }
}

