/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.util;

import com.amazonaws.ml.mms.util.Connector;
import com.amazonaws.ml.mms.util.OpenSslKey;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.AsyncAppender;
import org.apache.log4j.Logger;

public final class ConfigManager {
    private static final String MMS_DEBUG = "debug";
    private static final String MMS_INFERENCE_ADDRESS = "inference_address";
    private static final String MMS_MANAGEMENT_ADDRESS = "management_address";
    private static final String MMS_LOAD_MODELS = "load_models";
    private static final String MMS_BLACKLIST_ENV_VARS = "blacklist_env_vars";
    private static final String MMS_DEFAULT_WORKERS_PER_MODEL = "default_workers_per_model";
    private static final String MMS_DEFAULT_RESPONSE_TIMEOUT = "default_response_timeout";
    private static final String MMS_NUMBER_OF_NETTY_THREADS = "number_of_netty_threads";
    private static final String MMS_NETTY_CLIENT_THREADS = "netty_client_threads";
    private static final String MMS_JOB_QUEUE_SIZE = "job_queue_size";
    private static final String MMS_NUMBER_OF_GPU = "number_of_gpu";
    private static final String MMS_ASYNC_LOGGING = "async_logging";
    private static final String MMS_CORS_ALLOWED_ORIGIN = "cors_allowed_origin";
    private static final String MMS_CORS_ALLOWED_METHODS = "cors_allowed_methods";
    private static final String MMS_CORS_ALLOWED_HEADERS = "cors_allowed_headers";
    private static final String MMS_DECODE_INPUT_REQUEST = "decode_input_request";
    private static final String MMS_KEYSTORE = "keystore";
    private static final String MMS_KEYSTORE_PASS = "keystore_pass";
    private static final String MMS_KEYSTORE_TYPE = "keystore_type";
    private static final String MMS_CERTIFICATE_FILE = "certificate_file";
    private static final String MMS_PRIVATE_KEY_FILE = "private_key_file";
    private static final String MMS_MAX_REQUEST_SIZE = "max_request_size";
    private static final String MMS_MAX_RESPONSE_SIZE = "max_response_size";
    private static final String MMS_DEFAULT_SERVICE_HANDLER = "default_service_handler";
    private static final String MODEL_SERVER_HOME = "model_server_home";
    private static final String MMS_MODEL_STORE = "model_store";
    private static final String USE_NATIVE_IO = "use_native_io";
    private static final String IO_RATIO = "io_ratio";
    private static final String METRIC_TIME_INTERVAL = "metric_time_interval";
    private static final String ENABLE_ENVVARS_CONFIG = "enable_envvars_config";
    public static final String MODEL_METRICS_LOGGER = "MODEL_METRICS";
    public static final String MODEL_LOGGER = "MODEL_LOG";
    public static final String MODEL_SERVER_METRICS_LOGGER = "MMS_METRICS";
    private Pattern blacklistPattern;
    private Properties prop = new Properties();
    private static ConfigManager instance;
    private String hostName;

    private ConfigManager(Arguments args) {
        CharSequence[] models;
        String logLocation;
        File file;
        String filePath = System.getenv("MMS_CONFIG_FILE");
        if (filePath == null && (filePath = args.getMmsConfigFile()) == null) {
            filePath = System.getProperty("mmsConfigFile", "config.properties");
        }
        if ((file = new File(filePath)).exists()) {
            try (FileInputStream stream = new FileInputStream(file);){
                this.prop.load(stream);
                this.prop.put("mmsConfigFile", filePath);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to read configuration file", e);
            }
        }
        if ((logLocation = System.getenv("LOG_LOCATION")) != null) {
            System.setProperty("LOG_LOCATION", logLocation);
        } else if (System.getProperty("LOG_LOCATION") == null) {
            System.setProperty("LOG_LOCATION", "logs");
        }
        String metricsLocation = System.getenv("METRICS_LOCATION");
        if (metricsLocation != null) {
            System.setProperty("METRICS_LOCATION", metricsLocation);
        } else if (System.getProperty("METRICS_LOCATION") == null) {
            System.setProperty("METRICS_LOCATION", "logs");
        }
        String modelStore = args.getModelStore();
        if (modelStore != null) {
            this.prop.setProperty(MMS_MODEL_STORE, modelStore);
        }
        if ((models = args.getModels()) != null) {
            this.prop.setProperty(MMS_LOAD_MODELS, String.join((CharSequence)",", models));
        }
        this.prop.setProperty(MMS_NUMBER_OF_GPU, String.valueOf(Integer.min(ConfigManager.getAvailableGpu(), this.getIntProperty(MMS_NUMBER_OF_GPU, Integer.MAX_VALUE))));
        String pythonExecutable = args.getPythonExecutable();
        if (pythonExecutable != null) {
            this.prop.setProperty("PYTHON_EXECUTABLE", pythonExecutable);
        }
        try {
            InetAddress ip = InetAddress.getLocalHost();
            this.hostName = ip.getHostName();
        }
        catch (UnknownHostException e) {
            this.hostName = "Unknown";
        }
        if (Boolean.parseBoolean(this.prop.getProperty(MMS_ASYNC_LOGGING))) {
            this.enableAsyncLogging();
        }
        if (Boolean.parseBoolean(this.getEnableEnvVarsConfig())) {
            this.setSystemVars();
        }
    }

    private void setSystemVars() {
        Field[] fields;
        Class<ConfigManager> configClass = ConfigManager.class;
        for (Field f : fields = configClass.getDeclaredFields()) {
            String val;
            if (!f.getName().startsWith("MMS_") || (val = System.getenv(f.getName())) == null) continue;
            try {
                this.prop.setProperty((String)f.get(ConfigManager.class), val);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    String getEnableEnvVarsConfig() {
        return this.prop.getProperty(ENABLE_ENVVARS_CONFIG, "false");
    }

    public String getHostName() {
        return this.hostName;
    }

    public static void init(Arguments args) {
        instance = new ConfigManager(args);
    }

    public static ConfigManager getInstance() {
        return instance;
    }

    public boolean isDebug() {
        return Boolean.getBoolean("MMS_DEBUG") || Boolean.parseBoolean(this.prop.getProperty(MMS_DEBUG, "false"));
    }

    public Connector getListener(boolean management) {
        String binding = management ? this.prop.getProperty(MMS_MANAGEMENT_ADDRESS, "http://127.0.0.1:8081") : this.prop.getProperty(MMS_INFERENCE_ADDRESS, "http://127.0.0.1:8080");
        return Connector.parse(binding, management);
    }

    public int getNettyThreads() {
        return this.getIntProperty(MMS_NUMBER_OF_NETTY_THREADS, 0);
    }

    public int getNettyClientThreads() {
        return this.getIntProperty(MMS_NETTY_CLIENT_THREADS, 0);
    }

    public int getJobQueueSize() {
        return this.getIntProperty(MMS_JOB_QUEUE_SIZE, 100);
    }

    public int getNumberOfGpu() {
        return this.getIntProperty(MMS_NUMBER_OF_GPU, 0);
    }

    public String getMmsDefaultServiceHandler() {
        return this.getProperty(MMS_DEFAULT_SERVICE_HANDLER, null);
    }

    public Properties getConfiguration() {
        return new Properties(this.prop);
    }

    public int getConfiguredDefaultWorkersPerModel() {
        return this.getIntProperty(MMS_DEFAULT_WORKERS_PER_MODEL, 0);
    }

    public int getDefaultWorkers() {
        if (this.isDebug()) {
            return 1;
        }
        int workers = this.getConfiguredDefaultWorkersPerModel();
        if (workers == 0 && this.prop.getProperty("NUM_WORKERS", null) != null) {
            workers = this.getIntProperty("NUM_WORKERS", 0);
        }
        if (workers == 0) {
            workers = this.getNumberOfGpu();
        }
        if (workers == 0) {
            workers = Runtime.getRuntime().availableProcessors();
        }
        this.setProperty("NUM_WORKERS", Integer.toString(workers));
        return workers;
    }

    public int getMetricTimeInterval() {
        return this.getIntProperty(METRIC_TIME_INTERVAL, 60);
    }

    public String getModelServerHome() {
        String mmsHome = System.getenv("MODEL_SERVER_HOME");
        if (mmsHome == null && (mmsHome = System.getProperty(MODEL_SERVER_HOME)) == null && (mmsHome = this.getProperty(MODEL_SERVER_HOME, null)) == null) {
            mmsHome = ConfigManager.getCanonicalPath(this.findMmsHome());
            return mmsHome;
        }
        File dir = new File(mmsHome);
        if (!dir.exists()) {
            throw new IllegalArgumentException("Model server home not exist: " + mmsHome);
        }
        mmsHome = ConfigManager.getCanonicalPath(dir);
        return mmsHome;
    }

    public String getPythonExecutable() {
        return this.prop.getProperty("PYTHON_EXECUTABLE", "python");
    }

    public String getModelStore() {
        return ConfigManager.getCanonicalPath(this.prop.getProperty(MMS_MODEL_STORE));
    }

    public String getLoadModels() {
        return this.prop.getProperty(MMS_LOAD_MODELS);
    }

    public Pattern getBlacklistPattern() {
        return this.blacklistPattern;
    }

    public String getCorsAllowedOrigin() {
        return this.prop.getProperty(MMS_CORS_ALLOWED_ORIGIN);
    }

    public String getCorsAllowedMethods() {
        return this.prop.getProperty(MMS_CORS_ALLOWED_METHODS);
    }

    public String getCorsAllowedHeaders() {
        return this.prop.getProperty(MMS_CORS_ALLOWED_HEADERS);
    }

    public SslContext getSslContext() throws IOException, GeneralSecurityException {
        X509Certificate[] chain;
        PrivateKey privateKey;
        List<String> supportedCiphers = Arrays.asList("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
        String keyStoreFile = this.prop.getProperty(MMS_KEYSTORE);
        String privateKeyFile = this.prop.getProperty(MMS_PRIVATE_KEY_FILE);
        String certificateFile = this.prop.getProperty(MMS_CERTIFICATE_FILE);
        if (keyStoreFile != null) {
            char[] keystorePass = this.getProperty(MMS_KEYSTORE_PASS, "changeit").toCharArray();
            String keystoreType = this.getProperty(MMS_KEYSTORE_TYPE, "PKCS12");
            KeyStore keyStore = KeyStore.getInstance(keystoreType);
            try (FileInputStream is = new FileInputStream(keyStoreFile);){
                keyStore.load(is, keystorePass);
            }
            Enumeration<String> en = keyStore.aliases();
            String keyAlias = null;
            while (en.hasMoreElements()) {
                String alias = en.nextElement();
                if (!keyStore.isKeyEntry(alias)) continue;
                keyAlias = alias;
                break;
            }
            if (keyAlias == null) {
                throw new KeyException("No key entry found in keystore.");
            }
            privateKey = (PrivateKey)keyStore.getKey(keyAlias, keystorePass);
            Certificate[] certs = keyStore.getCertificateChain(keyAlias);
            chain = new X509Certificate[certs.length];
            for (int i = 0; i < certs.length; ++i) {
                chain[i] = (X509Certificate)certs[i];
            }
        } else if (privateKeyFile != null && certificateFile != null) {
            privateKey = this.loadPrivateKey(privateKeyFile);
            chain = this.loadCertificateChain(certificateFile);
        } else {
            SelfSignedCertificate ssc = new SelfSignedCertificate();
            privateKey = ssc.key();
            chain = new X509Certificate[]{ssc.cert()};
        }
        return SslContextBuilder.forServer(privateKey, chain).protocols("TLSv1.2").ciphers(supportedCiphers).build();
    }

    /*
     * Loose catch block
     */
    private PrivateKey loadPrivateKey(String keyFile) throws IOException, GeneralSecurityException {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        Throwable throwable = null;
        try (FileInputStream is = new FileInputStream(keyFile);){
            String content = IOUtils.toString((InputStream)is, StandardCharsets.UTF_8);
            content = content.replaceAll("-----(BEGIN|END)( RSA)? PRIVATE KEY-----\\s*", "");
            byte[] buf = Base64.getMimeDecoder().decode(content);
            try {
                PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(buf);
                PrivateKey privateKey = keyFactory.generatePrivate(privKeySpec);
                return privateKey;
            }
            catch (InvalidKeySpecException e) {
                PrivateKey privateKey;
                block17: {
                    block18: {
                        buf = OpenSslKey.convertPrivateKey(buf);
                        PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(buf);
                        privateKey = keyFactory.generatePrivate(privKeySpec);
                        if (is == null) break block17;
                        if (throwable == null) break block18;
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block17;
                    }
                    ((InputStream)is).close();
                }
                return privateKey;
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
    }

    private X509Certificate[] loadCertificateChain(String keyFile) throws IOException, GeneralSecurityException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        try (FileInputStream is = new FileInputStream(keyFile);){
            Collection<? extends Certificate> certs = cf.generateCertificates(is);
            int i = 0;
            X509Certificate[] chain = new X509Certificate[certs.size()];
            for (Certificate certificate : certs) {
                chain[i++] = (X509Certificate)certificate;
            }
            X509Certificate[] x509CertificateArray = chain;
            return x509CertificateArray;
        }
    }

    public String getProperty(String key, String def) {
        return this.prop.getProperty(key, def);
    }

    public void validateConfigurations() throws InvalidPropertiesFormatException {
        String blacklistVars = this.prop.getProperty(MMS_BLACKLIST_ENV_VARS, "");
        try {
            this.blacklistPattern = Pattern.compile(blacklistVars);
        }
        catch (PatternSyntaxException e) {
            throw new InvalidPropertiesFormatException(e);
        }
    }

    public String dumpConfigurations() {
        Runtime runtime = Runtime.getRuntime();
        return "\nMMS Home: " + this.getModelServerHome() + "\nCurrent directory: " + ConfigManager.getCanonicalPath(".") + "\nTemp directory: " + System.getProperty("java.io.tmpdir") + "\nNumber of GPUs: " + this.getNumberOfGpu() + "\nNumber of CPUs: " + runtime.availableProcessors() + "\nMax heap size: " + runtime.maxMemory() / 1024L / 1024L + " M\nPython executable: " + (this.getPythonExecutable() == null ? "N/A" : this.getPythonExecutable()) + "\nConfig file: " + this.prop.getProperty("mmsConfigFile", "N/A") + "\nInference address: " + this.getListener(false) + "\nManagement address: " + this.getListener(true) + "\nModel Store: " + (this.getModelStore() == null ? "N/A" : this.getModelStore()) + "\nInitial Models: " + (this.getLoadModels() == null ? "N/A" : this.getLoadModels()) + "\nLog dir: " + ConfigManager.getCanonicalPath(System.getProperty("LOG_LOCATION")) + "\nMetrics dir: " + ConfigManager.getCanonicalPath(System.getProperty("METRICS_LOCATION")) + "\nNetty threads: " + this.getNettyThreads() + "\nNetty client threads: " + this.getNettyClientThreads() + "\nDefault workers per model: " + this.getDefaultWorkers() + "\nBlacklist Regex: " + this.prop.getProperty(MMS_BLACKLIST_ENV_VARS, "N/A") + "\nMaximum Response Size: " + this.prop.getProperty(MMS_MAX_RESPONSE_SIZE, "6553500") + "\nMaximum Request Size: " + this.prop.getProperty(MMS_MAX_REQUEST_SIZE, "6553500");
    }

    public boolean useNativeIo() {
        return Boolean.parseBoolean(this.prop.getProperty(USE_NATIVE_IO, "true"));
    }

    public int getIoRatio() {
        return this.getIntProperty(IO_RATIO, 50);
    }

    public int getMaxResponseSize() {
        return this.getIntProperty(MMS_MAX_RESPONSE_SIZE, 6553500);
    }

    public int getMaxRequestSize() {
        return this.getIntProperty(MMS_MAX_REQUEST_SIZE, 6553500);
    }

    void setProperty(String key, String value) {
        this.prop.setProperty(key, value);
    }

    private int getIntProperty(String key, int def) {
        String value = this.prop.getProperty(key);
        if (value == null) {
            return def;
        }
        return Integer.parseInt(value);
    }

    public int getDefaultResponseTimeout() {
        return Integer.parseInt(this.prop.getProperty(MMS_DEFAULT_RESPONSE_TIMEOUT, "120"));
    }

    private File findMmsHome() {
        File cwd;
        for (File file = cwd = new File(ConfigManager.getCanonicalPath(".")); file != null; file = file.getParentFile()) {
            File mms = new File(file, "mms");
            if (!mms.exists()) continue;
            return file;
        }
        return cwd;
    }

    private void enableAsyncLogging() {
        this.enableAsyncLogging(Logger.getRootLogger());
        this.enableAsyncLogging(Logger.getLogger(MODEL_METRICS_LOGGER));
        this.enableAsyncLogging(Logger.getLogger(MODEL_LOGGER));
        this.enableAsyncLogging(Logger.getLogger(MODEL_SERVER_METRICS_LOGGER));
        this.enableAsyncLogging(Logger.getLogger("ACCESS_LOG"));
        this.enableAsyncLogging(Logger.getLogger("com.amazonaws.ml.mms"));
    }

    private void enableAsyncLogging(Logger logger) {
        AsyncAppender asyncAppender = new AsyncAppender();
        Enumeration en = logger.getAllAppenders();
        while (en.hasMoreElements()) {
            Appender appender = (Appender)en.nextElement();
            if (appender instanceof AsyncAppender) {
                return;
            }
            logger.removeAppender(appender);
            asyncAppender.addAppender(appender);
        }
        logger.addAppender(asyncAppender);
    }

    public HashMap<String, String> getBackendConfiguration() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("MMS_DECODE_INPUT_REQUEST", this.prop.getProperty(MMS_DECODE_INPUT_REQUEST, "true"));
        return config;
    }

    private static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    private static String getCanonicalPath(String path) {
        if (path == null) {
            return null;
        }
        return ConfigManager.getCanonicalPath(new File(path));
    }

    private static int getAvailableGpu() {
        try {
            Process process = Runtime.getRuntime().exec("nvidia-smi --query-gpu=index --format=csv");
            int ret = process.waitFor();
            if (ret != 0) {
                return 0;
            }
            List<String> list = IOUtils.readLines(process.getInputStream(), StandardCharsets.UTF_8);
            if (list.isEmpty() || !"index".equals(list.get(0))) {
                throw new AssertionError((Object)"Unexpected nvidia-smi response.");
            }
            return list.size() - 1;
        }
        catch (IOException | InterruptedException e) {
            return 0;
        }
    }

    public static final class Arguments {
        private String mmsConfigFile;
        private String pythonExecutable;
        private String modelStore;
        private String[] models;

        public Arguments() {
        }

        public Arguments(CommandLine cmd) {
            this.mmsConfigFile = cmd.getOptionValue("mms-config-file");
            this.pythonExecutable = cmd.getOptionValue("python");
            this.modelStore = cmd.getOptionValue("model-store");
            this.models = cmd.getOptionValues("models");
        }

        public static Options getOptions() {
            Options options = new Options();
            options.addOption(Option.builder("f").longOpt("mms-config-file").hasArg().argName("MMS-CONFIG-FILE").desc("Path to the configuration properties file.").build());
            options.addOption(Option.builder("e").longOpt("python").hasArg().argName("PYTHON").desc("Python runtime executable path.").build());
            options.addOption(Option.builder("m").longOpt("models").hasArgs().argName("MODELS").desc("Models to be loaded at startup.").build());
            options.addOption(Option.builder("s").longOpt("model-store").hasArg().argName("MODELS-STORE").desc("Model store location where models can be loaded.").build());
            return options;
        }

        public String getMmsConfigFile() {
            return this.mmsConfigFile;
        }

        public String getPythonExecutable() {
            return this.pythonExecutable;
        }

        public void setMmsConfigFile(String mmsConfigFile) {
            this.mmsConfigFile = mmsConfigFile;
        }

        public String getModelStore() {
            return this.modelStore;
        }

        public void setModelStore(String modelStore) {
            this.modelStore = modelStore;
        }

        public String[] getModels() {
            return this.models;
        }

        public void setModels(String[] models) {
            this.models = models;
        }
    }
}

