/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.util;

import com.amazonaws.ml.mms.http.ErrorResponse;
import com.amazonaws.ml.mms.http.Session;
import com.amazonaws.ml.mms.metrics.Dimension;
import com.amazonaws.ml.mms.metrics.Metric;
import com.amazonaws.ml.mms.util.ConfigManager;
import com.amazonaws.ml.mms.util.JsonUtils;
import com.amazonaws.ml.mms.util.messages.InputParameter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyUtils {
    private static final Logger logger = LoggerFactory.getLogger("ACCESS_LOG");
    private static final String REQUEST_ID = "x-request-id";
    private static final AttributeKey<Session> SESSION_KEY = AttributeKey.valueOf("session");
    private static final Dimension DIMENSION = new Dimension("Level", "Host");
    private static final Metric REQUESTS_2_XX = new Metric("Requests2XX", "1", "Count", ConfigManager.getInstance().getHostName(), DIMENSION);
    private static final Metric REQUESTS_4_XX = new Metric("Requests4XX", "1", "Count", ConfigManager.getInstance().getHostName(), DIMENSION);
    private static final Metric REQUESTS_5_XX = new Metric("Requests5XX", "1", "Count", ConfigManager.getInstance().getHostName(), DIMENSION);
    private static final org.apache.log4j.Logger loggerMmsMetrics = org.apache.log4j.Logger.getLogger("MMS_METRICS");

    private NettyUtils() {
    }

    public static void requestReceived(Channel channel, HttpRequest request) {
        Session session = channel.attr(SESSION_KEY).get();
        assert (session == null);
        SocketAddress address = channel.remoteAddress();
        String remoteIp = address == null ? "0.0.0.0" : address.toString();
        channel.attr(SESSION_KEY).set(new Session(remoteIp, request));
    }

    public static String getRequestId(Channel channel) {
        Session accessLog = channel.attr(SESSION_KEY).get();
        if (accessLog != null) {
            return accessLog.getRequestId();
        }
        return null;
    }

    public static void sendJsonResponse(ChannelHandlerContext ctx, Object json) {
        NettyUtils.sendJsonResponse(ctx, JsonUtils.GSON_PRETTY.toJson(json), HttpResponseStatus.OK);
    }

    public static void sendJsonResponse(ChannelHandlerContext ctx, Object json, HttpResponseStatus status) {
        NettyUtils.sendJsonResponse(ctx, JsonUtils.GSON_PRETTY.toJson(json), status);
    }

    public static void sendJsonResponse(ChannelHandlerContext ctx, String json) {
        NettyUtils.sendJsonResponse(ctx, json, HttpResponseStatus.OK);
    }

    public static void sendJsonResponse(ChannelHandlerContext ctx, String json, HttpResponseStatus status) {
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, false);
        resp.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
        ByteBuf content = resp.content();
        content.writeCharSequence(json, CharsetUtil.UTF_8);
        content.writeByte(10);
        NettyUtils.sendHttpResponse(ctx, resp, true);
    }

    public static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status, Throwable t) {
        ErrorResponse error = new ErrorResponse(status.code(), t.getClass().getSimpleName(), t.getMessage());
        NettyUtils.sendJsonResponse(ctx, error, status);
    }

    public static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status, Throwable t, String msg) {
        ErrorResponse error = new ErrorResponse(status.code(), t.getClass().getSimpleName(), msg);
        NettyUtils.sendJsonResponse(ctx, error, status);
    }

    public static void sendHttpResponse(ChannelHandlerContext ctx, FullHttpResponse resp, boolean keepAlive) {
        int code;
        Channel channel = ctx.channel();
        Session session = channel.attr(SESSION_KEY).getAndSet(null);
        HttpHeaders headers = resp.headers();
        ConfigManager configManager = ConfigManager.getInstance();
        if (session != null) {
            session.setCode(resp.status().code());
            headers.set(REQUEST_ID, (Object)session.getRequestId());
            logger.info(session.toString());
        }
        if ((code = resp.status().code()) >= 200 && code < 300) {
            loggerMmsMetrics.info(REQUESTS_2_XX);
        } else if (code >= 400 && code < 500) {
            loggerMmsMetrics.info(REQUESTS_4_XX);
        } else {
            loggerMmsMetrics.info(REQUESTS_5_XX);
        }
        String allowedOrigin = configManager.getCorsAllowedOrigin();
        String allowedMethods = configManager.getCorsAllowedMethods();
        String allowedHeaders = configManager.getCorsAllowedHeaders();
        if (allowedOrigin != null && !allowedOrigin.isEmpty() && !headers.contains(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN)) {
            headers.set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)allowedOrigin);
        }
        if (allowedMethods != null && !allowedMethods.isEmpty() && !headers.contains(HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS)) {
            headers.set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS, (Object)allowedMethods);
        }
        if (allowedHeaders != null && !allowedHeaders.isEmpty() && !headers.contains(HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS)) {
            headers.set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, (Object)allowedHeaders);
        }
        headers.set("Pragma", (Object)"no-cache");
        headers.set("Cache-Control", (Object)"no-cache; no-store, must-revalidate, private");
        headers.set("Expires", (Object)"Thu, 01 Jan 1970 00:00:00 UTC");
        HttpUtil.setContentLength(resp, resp.content().readableBytes());
        if (!keepAlive || code >= 400) {
            headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            ChannelFuture f = channel.writeAndFlush(resp);
            f.addListener(ChannelFutureListener.CLOSE);
        } else {
            headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            channel.writeAndFlush(resp);
        }
    }

    public static void closeOnFlush(Channel ch) {
        if (ch.isActive()) {
            ch.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
        }
    }

    public static byte[] getBytes(ByteBuf buf) {
        if (buf.hasArray()) {
            return buf.array();
        }
        byte[] ret = new byte[buf.readableBytes()];
        int readerIndex = buf.readerIndex();
        buf.getBytes(readerIndex, ret);
        return ret;
    }

    public static String getParameter(QueryStringDecoder decoder, String key, String def) {
        List<String> param = decoder.parameters().get(key);
        if (param != null && !param.isEmpty()) {
            return param.get(0);
        }
        return def;
    }

    public static int getIntParameter(QueryStringDecoder decoder, String key, int def) {
        String value = NettyUtils.getParameter(decoder, key, null);
        if (value == null) {
            return def;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static InputParameter getFormData(InterfaceHttpData data) {
        if (data == null) {
            return null;
        }
        String name = data.getName();
        switch (data.getHttpDataType()) {
            case Attribute: {
                Attribute attribute = (Attribute)data;
                try {
                    return new InputParameter(name, attribute.getValue());
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }
            case FileUpload: {
                FileUpload fileUpload = (FileUpload)data;
                String contentType = fileUpload.getContentType();
                try {
                    return new InputParameter(name, NettyUtils.getBytes(fileUpload.getByteBuf()), contentType);
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
        throw new IllegalArgumentException("Except form field, but got " + (Object)((Object)data.getHttpDataType()));
    }
}

