/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.util;

import com.amazonaws.ml.mms.util.ConfigManager;
import com.amazonaws.ml.mms.util.Connector;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerGroups {
    static final Logger logger = LoggerFactory.getLogger(ServerGroups.class);
    private ChannelGroup allChannels;
    private EventLoopGroup serverGroup;
    private EventLoopGroup childGroup;
    private EventLoopGroup backendGroup;
    private ConfigManager configManager;

    public ServerGroups(ConfigManager configManager) {
        this.configManager = configManager;
        this.init();
    }

    public final void init() {
        this.allChannels = new DefaultChannelGroup(GlobalEventExecutor.INSTANCE);
        this.serverGroup = Connector.newEventLoopGroup(2);
        this.childGroup = Connector.newEventLoopGroup(this.configManager.getNettyThreads());
        this.backendGroup = Connector.newEventLoopGroup(this.configManager.getNettyClientThreads());
    }

    public void shutdown(boolean graceful) {
        this.closeAllChannels(graceful);
        ArrayList<EventLoopGroup> allEventLoopGroups = new ArrayList<EventLoopGroup>();
        allEventLoopGroups.add(this.serverGroup);
        allEventLoopGroups.add(this.childGroup);
        for (EventLoopGroup group : allEventLoopGroups) {
            if (graceful) {
                group.shutdownGracefully();
                continue;
            }
            group.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        }
        if (graceful) {
            for (EventLoopGroup group : allEventLoopGroups) {
                try {
                    group.awaitTermination(60L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public EventLoopGroup getServerGroup() {
        return this.serverGroup;
    }

    public EventLoopGroup getChildGroup() {
        return this.childGroup;
    }

    public EventLoopGroup getBackendGroup() {
        return this.backendGroup;
    }

    public void registerChannel(Channel channel) {
        this.allChannels.add(channel);
    }

    private void closeAllChannels(boolean graceful) {
        ChannelGroupFuture future = this.allChannels.close();
        if (graceful) {
            try {
                future.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (!future.isSuccess()) {
                for (ChannelFuture cf : future) {
                    if (cf.isSuccess()) continue;
                    logger.info("Unable to close channel: " + cf.channel(), cf.cause());
                }
            }
        }
    }
}

