/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.util.codec;

import com.amazonaws.ml.mms.util.messages.BaseModelRequest;
import com.amazonaws.ml.mms.util.messages.InputParameter;
import com.amazonaws.ml.mms.util.messages.ModelInferenceRequest;
import com.amazonaws.ml.mms.util.messages.ModelLoadModelRequest;
import com.amazonaws.ml.mms.util.messages.RequestInput;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;

@ChannelHandler.Sharable
public class ModelRequestEncoder
extends MessageToByteEncoder<BaseModelRequest> {
    @Override
    protected void encode(ChannelHandlerContext ctx, BaseModelRequest msg, ByteBuf out) {
        if (msg instanceof ModelLoadModelRequest) {
            out.writeByte(76);
            ModelLoadModelRequest request = (ModelLoadModelRequest)msg;
            byte[] buf = msg.getModelName().getBytes(StandardCharsets.UTF_8);
            out.writeInt(buf.length);
            out.writeBytes(buf);
            buf = request.getModelPath().getBytes(StandardCharsets.UTF_8);
            out.writeInt(buf.length);
            out.writeBytes(buf);
            int batchSize = request.getBatchSize();
            if (batchSize <= 0) {
                batchSize = 1;
            }
            out.writeInt(batchSize);
            buf = request.getHandler().getBytes(StandardCharsets.UTF_8);
            out.writeInt(buf.length);
            out.writeBytes(buf);
            out.writeInt(request.getGpuId());
        } else if (msg instanceof ModelInferenceRequest) {
            out.writeByte(73);
            ModelInferenceRequest request = (ModelInferenceRequest)msg;
            for (RequestInput input : request.getRequestBatch()) {
                this.encodeRequest(input, out);
            }
            out.writeInt(-1);
        }
    }

    private void encodeRequest(RequestInput req, ByteBuf out) {
        byte[] buf = req.getRequestId().getBytes(StandardCharsets.UTF_8);
        out.writeInt(buf.length);
        out.writeBytes(buf);
        for (Map.Entry<String, String> entry : req.getHeaders().entrySet()) {
            ModelRequestEncoder.encodeField(entry.getKey(), out);
            ModelRequestEncoder.encodeField(entry.getValue(), out);
        }
        out.writeInt(-1);
        for (InputParameter input : req.getParameters()) {
            this.encodeParameter(input, out);
        }
        out.writeInt(-1);
    }

    private void encodeParameter(InputParameter parameter, ByteBuf out) {
        byte[] modelInputName = parameter.getName().getBytes(StandardCharsets.UTF_8);
        out.writeInt(modelInputName.length);
        out.writeBytes(modelInputName);
        ModelRequestEncoder.encodeField(parameter.getContentType(), out);
        byte[] buf = parameter.getValue();
        out.writeInt(buf.length);
        out.writeBytes(buf);
    }

    private static void encodeField(CharSequence field, ByteBuf out) {
        if (field == null) {
            out.writeInt(0);
            return;
        }
        byte[] buf = field.toString().getBytes(StandardCharsets.UTF_8);
        out.writeInt(buf.length);
        out.writeBytes(buf);
    }
}

