/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.util.logging;

import com.amazonaws.ml.mms.metrics.Dimension;
import com.amazonaws.ml.mms.metrics.Metric;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;

public class QLogLayout
extends PatternLayout {
    @Override
    public String format(LoggingEvent event) {
        Object eventMessage = event.getMessage();
        String programName = QLogLayout.getStringOrDefault(System.getenv("MXNETMODELSERVER_PROGRAM"), "MXNetModelServer");
        String domain = QLogLayout.getStringOrDefault(System.getenv("DOMAIN"), "Unknown");
        long currentTimeInSec = System.currentTimeMillis() / 1000L;
        if (eventMessage == null) {
            return null;
        }
        if (eventMessage instanceof Metric) {
            String marketPlace = System.getenv("REALM");
            StringBuilder stringBuilder = new StringBuilder();
            Metric metric = (Metric)eventMessage;
            stringBuilder.append("HostName=").append(metric.getHostName());
            if (metric.getRequestId() != null && !metric.getRequestId().isEmpty()) {
                stringBuilder.append("\nRequestId=").append(metric.getRequestId());
            }
            if (marketPlace != null && !marketPlace.isEmpty()) {
                stringBuilder.append("\nMarketplace=").append(programName).append(':').append(domain).append(':').append(marketPlace);
            }
            stringBuilder.append("\nStartTime=").append(QLogLayout.getStringOrDefault(metric.getTimestamp(), Long.toString(currentTimeInSec)));
            stringBuilder.append("\nProgram=").append(programName).append("\nMetrics=").append(metric.getMetricName()).append('=').append(metric.getValue()).append(' ').append(metric.getUnit());
            for (Dimension dimension : metric.getDimensions()) {
                stringBuilder.append(' ').append(dimension.getName()).append('|').append(dimension.getValue()).append(' ');
            }
            stringBuilder.append("\nEOE\n");
            return stringBuilder.toString();
        }
        return eventMessage.toString();
    }

    private static String getStringOrDefault(String val, String defVal) {
        if (val == null || val.isEmpty()) {
            return defVal;
        }
        return val;
    }
}

