/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.wlm;

import com.amazonaws.ml.mms.util.messages.BaseModelRequest;
import com.amazonaws.ml.mms.util.messages.ModelInferenceRequest;
import com.amazonaws.ml.mms.util.messages.ModelLoadModelRequest;
import com.amazonaws.ml.mms.util.messages.ModelWorkerResponse;
import com.amazonaws.ml.mms.util.messages.Predictions;
import com.amazonaws.ml.mms.util.messages.RequestInput;
import com.amazonaws.ml.mms.wlm.Job;
import com.amazonaws.ml.mms.wlm.Model;
import com.amazonaws.ml.mms.wlm.WorkerState;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchAggregator {
    private static final Logger logger = LoggerFactory.getLogger(BatchAggregator.class);
    private Model model;
    private Map<String, Job> jobs;

    public BatchAggregator(Model model) {
        this.model = model;
        this.jobs = new LinkedHashMap<String, Job>();
    }

    public BaseModelRequest getRequest(String threadName, WorkerState state) throws InterruptedException {
        this.jobs.clear();
        ModelInferenceRequest req = new ModelInferenceRequest(this.model.getModelName());
        this.model.pollBatch(threadName, state == WorkerState.WORKER_MODEL_LOADED ? 0L : Long.MAX_VALUE, this.jobs);
        for (Job j : this.jobs.values()) {
            if (j.isControlCmd()) {
                if (this.jobs.size() > 1) {
                    throw new IllegalStateException("Received more than 1 control command. Control messages should be processed/retrieved one at a time.");
                }
                RequestInput input = j.getPayload();
                int gpuId = -1;
                String gpu = input.getStringParameter("gpu");
                if (gpu != null) {
                    gpuId = Integer.parseInt(gpu);
                }
                return new ModelLoadModelRequest(this.model, gpuId);
            }
            j.setScheduled();
            req.addRequest(j.getPayload());
        }
        return req;
    }

    public void sendResponse(ModelWorkerResponse message) {
        if (message.getCode() == 200) {
            if (this.jobs.isEmpty()) {
                return;
            }
            for (Predictions prediction : message.getPredictions()) {
                String jobId = prediction.getRequestId();
                Job job = this.jobs.remove(jobId);
                if (job == null) {
                    throw new IllegalStateException("Unexpected job: " + jobId);
                }
                job.response(prediction.getResp(), prediction.getContentType(), prediction.getStatusCode(), prediction.getReasonPhrase(), prediction.getHeaders());
            }
        } else {
            for (String reqId : this.jobs.keySet()) {
                Job j = this.jobs.remove(reqId);
                if (j == null) {
                    throw new IllegalStateException("Unexpected job: " + reqId);
                }
                j.sendError(HttpResponseStatus.valueOf(message.getCode()), message.getMessage());
            }
            if (!this.jobs.isEmpty()) {
                throw new IllegalStateException("Not all jobs get response.");
            }
        }
    }

    public void sendError(BaseModelRequest message, String error, HttpResponseStatus status) {
        if (message instanceof ModelLoadModelRequest) {
            logger.warn("Load model failed: {}, error: {}", (Object)message.getModelName(), (Object)error);
            return;
        }
        if (message != null) {
            ModelInferenceRequest msg = (ModelInferenceRequest)message;
            for (RequestInput req : msg.getRequestBatch()) {
                String requestId = req.getRequestId();
                Job job = this.jobs.remove(requestId);
                if (job == null) {
                    logger.error("Unexpected job: " + requestId);
                    continue;
                }
                job.sendError(status, error);
            }
            if (!this.jobs.isEmpty()) {
                this.jobs.clear();
                logger.error("Not all jobs get response.");
            }
        } else {
            for (Map.Entry<String, Job> j : this.jobs.entrySet()) {
                String jobsId = j.getValue().getJobId();
                Job job = this.jobs.remove(jobsId);
                if (job.isControlCmd()) {
                    job.sendError(status, error);
                    continue;
                }
                this.model.addFirst(job);
            }
        }
    }
}

