/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.wlm;

import com.amazonaws.ml.mms.http.InternalServerException;
import com.amazonaws.ml.mms.util.NettyUtils;
import com.amazonaws.ml.mms.util.messages.RequestInput;
import com.amazonaws.ml.mms.util.messages.WorkerCommands;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Job {
    private static final Logger logger = LoggerFactory.getLogger(Job.class);
    private ChannelHandlerContext ctx;
    private String modelName;
    private WorkerCommands cmd;
    private RequestInput input;
    private long begin;
    private long scheduled;

    public Job(ChannelHandlerContext ctx, String modelName, WorkerCommands cmd, RequestInput input) {
        this.ctx = ctx;
        this.modelName = modelName;
        this.cmd = cmd;
        this.input = input;
        this.scheduled = this.begin = System.currentTimeMillis();
    }

    public String getJobId() {
        return this.input.getRequestId();
    }

    public String getModelName() {
        return this.modelName;
    }

    public WorkerCommands getCmd() {
        return this.cmd;
    }

    public boolean isControlCmd() {
        return !WorkerCommands.PREDICT.equals((Object)this.cmd);
    }

    public RequestInput getPayload() {
        return this.input;
    }

    public void setScheduled() {
        this.scheduled = System.currentTimeMillis();
    }

    public void response(byte[] body, CharSequence contentType, int statusCode, String statusPhrase, Map<String, String> responseHeaders) {
        HttpResponseStatus status = statusPhrase == null ? HttpResponseStatus.valueOf(statusCode) : HttpResponseStatus.valueOf(statusCode, statusPhrase);
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, false);
        if (contentType != null && contentType.length() > 0) {
            resp.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        }
        if (responseHeaders != null) {
            for (Map.Entry<String, String> e : responseHeaders.entrySet()) {
                resp.headers().set(e.getKey(), (Object)e.getValue());
            }
        }
        resp.content().writeBytes(body);
        if (this.ctx != null) {
            NettyUtils.sendHttpResponse(this.ctx, resp, true);
        }
        logger.debug("Waiting time: {}, Backend time: {}", (Object)(this.scheduled - this.begin), (Object)(System.currentTimeMillis() - this.scheduled));
    }

    public void sendError(HttpResponseStatus status, String error) {
        if (this.ctx != null) {
            NettyUtils.sendError(this.ctx, status, new InternalServerException(error));
        }
        logger.debug("Waiting time: {}, Inference time: {}", (Object)(this.scheduled - this.begin), (Object)(System.currentTimeMillis() - this.begin));
    }
}

