/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.wlm;

import com.amazonaws.ml.mms.archive.ModelArchive;
import com.amazonaws.ml.mms.util.ConfigManager;
import com.amazonaws.ml.mms.wlm.Job;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Model {
    public static final String DEFAULT_DATA_QUEUE = "DATA_QUEUE";
    private static final Logger logger = LoggerFactory.getLogger(Model.class);
    private ModelArchive modelArchive;
    private int minWorkers;
    private int maxWorkers;
    private int batchSize;
    private int maxBatchDelay;
    private ReentrantLock lock;
    private int responseTimeout;
    private AtomicInteger failedInfReqs;
    private ConcurrentMap<String, LinkedBlockingDeque<Job>> jobsDb;

    public Model(ModelArchive modelArchive, int queueSize) {
        this.modelArchive = modelArchive;
        this.batchSize = 1;
        this.maxBatchDelay = 100;
        this.jobsDb = new ConcurrentHashMap<String, LinkedBlockingDeque<Job>>();
        this.jobsDb.putIfAbsent(DEFAULT_DATA_QUEUE, new LinkedBlockingDeque(queueSize));
        this.failedInfReqs = new AtomicInteger(0);
        this.lock = new ReentrantLock();
    }

    public String getModelName() {
        return this.modelArchive.getModelName();
    }

    public File getModelDir() {
        return this.modelArchive.getModelDir();
    }

    public String getModelUrl() {
        return this.modelArchive.getUrl();
    }

    public ModelArchive getModelArchive() {
        return this.modelArchive;
    }

    public int getMinWorkers() {
        return this.minWorkers;
    }

    public void setMinWorkers(int minWorkers) {
        this.minWorkers = minWorkers;
    }

    public int getMaxWorkers() {
        return this.maxWorkers;
    }

    public void setMaxWorkers(int maxWorkers) {
        this.maxWorkers = maxWorkers;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getMaxBatchDelay() {
        return this.maxBatchDelay;
    }

    public void setMaxBatchDelay(int maxBatchDelay) {
        this.maxBatchDelay = maxBatchDelay;
    }

    public void addJob(String threadId, Job job) {
        LinkedBlockingDeque<Job> blockingDeque = (LinkedBlockingDeque<Job>)this.jobsDb.get(threadId);
        if (blockingDeque == null) {
            blockingDeque = new LinkedBlockingDeque<Job>();
            this.jobsDb.put(threadId, blockingDeque);
        }
        blockingDeque.offer(job);
    }

    public void removeJobQueue(String threadId) {
        if (!threadId.equals(DEFAULT_DATA_QUEUE)) {
            this.jobsDb.remove(threadId);
        }
    }

    public boolean addJob(Job job) {
        return ((LinkedBlockingDeque)this.jobsDb.get(DEFAULT_DATA_QUEUE)).offer(job);
    }

    public void addFirst(Job job) {
        ((LinkedBlockingDeque)this.jobsDb.get(DEFAULT_DATA_QUEUE)).addFirst(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollBatch(String threadId, long waitTime, Map<String, Job> jobsRepo) throws InterruptedException {
        Job j;
        if (jobsRepo == null || threadId == null || threadId.isEmpty()) {
            throw new IllegalArgumentException("Invalid input given provided");
        }
        if (!jobsRepo.isEmpty()) {
            throw new IllegalArgumentException("The jobs repo provided contains stale jobs. Clear them!!");
        }
        LinkedBlockingDeque jobsQueue = (LinkedBlockingDeque)this.jobsDb.get(threadId);
        if (jobsQueue != null && !jobsQueue.isEmpty() && (j = (Job)jobsQueue.poll(waitTime, TimeUnit.MILLISECONDS)) != null) {
            jobsRepo.put(j.getJobId(), j);
            return;
        }
        try {
            this.lock.lockInterruptibly();
            long maxDelay = this.maxBatchDelay;
            jobsQueue = (LinkedBlockingDeque)this.jobsDb.get(DEFAULT_DATA_QUEUE);
            Job j2 = (Job)jobsQueue.poll(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            logger.trace("get first job: {}", (Object)Objects.requireNonNull(j2).getJobId());
            jobsRepo.put(j2.getJobId(), j2);
            long begin = System.currentTimeMillis();
            for (int i = 0; i < this.batchSize - 1 && (j2 = (Job)jobsQueue.poll(maxDelay, TimeUnit.MILLISECONDS)) != null; ++i) {
                long end = System.currentTimeMillis();
                begin = end;
                jobsRepo.put(j2.getJobId(), j2);
                if ((maxDelay -= end - begin) <= 0L) break;
            }
            logger.trace("sending jobs, size: {}", (Object)jobsRepo.size());
        }
        finally {
            this.lock.unlock();
        }
    }

    public int incrFailedInfReqs() {
        return this.failedInfReqs.incrementAndGet();
    }

    public void resetFailedInfReqs() {
        this.failedInfReqs.set(0);
    }

    public int getResponseTimeout() {
        return ConfigManager.getInstance().isDebug() ? Integer.MAX_VALUE : this.responseTimeout;
    }

    public void setResponseTimeout(int responseTimeout) {
        this.responseTimeout = responseTimeout;
    }
}

