/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.wlm;

import com.amazonaws.ml.mms.archive.Manifest;
import com.amazonaws.ml.mms.metrics.Metric;
import com.amazonaws.ml.mms.util.ConfigManager;
import com.amazonaws.ml.mms.util.Connector;
import com.amazonaws.ml.mms.wlm.Model;
import com.amazonaws.ml.mms.wlm.WorkerInitializationException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerLifeCycle {
    static final Logger logger = LoggerFactory.getLogger(WorkerLifeCycle.class);
    private ConfigManager configManager;
    private Model model;
    private int pid = -1;
    private Process process;
    private CountDownLatch latch;
    private boolean success;
    private Connector connector;

    public WorkerLifeCycle(ConfigManager configManager, Model model) {
        this.configManager = configManager;
        this.model = model;
    }

    private String[] getEnvString(String cwd, String modelPath, String handler) {
        ArrayList<String> envList = new ArrayList<String>();
        Pattern blackList = this.configManager.getBlacklistPattern();
        String handlerFile = handler;
        if (handler.contains(":") && (handlerFile = handler.split(":")[0]).contains("/")) {
            handlerFile = handlerFile.substring(0, handlerFile.lastIndexOf(47));
        }
        StringBuilder pythonPath = new StringBuilder();
        HashMap<String, String> environment = new HashMap<String, String>(System.getenv());
        environment.putAll(this.configManager.getBackendConfiguration());
        pythonPath.append(handlerFile).append(File.pathSeparatorChar);
        if (System.getenv("PYTHONPATH") != null) {
            pythonPath.append(System.getenv("PYTHONPATH")).append(File.pathSeparatorChar);
        }
        pythonPath.append(modelPath);
        if (!cwd.contains("site-packages") && !cwd.contains("dist-packages")) {
            pythonPath.append(File.pathSeparatorChar).append(cwd);
        }
        environment.put("PYTHONPATH", pythonPath.toString());
        for (Map.Entry<String, String> entry : environment.entrySet()) {
            if (blackList.matcher(entry.getKey()).matches()) continue;
            envList.add(entry.getKey() + '=' + entry.getValue());
        }
        return envList.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWorker(int port) throws WorkerInitializationException, InterruptedException {
        File modelPath;
        File workingDir = new File(this.configManager.getModelServerHome());
        this.setPort(port);
        try {
            modelPath = this.model.getModelDir().getCanonicalFile();
        }
        catch (IOException e) {
            throw new WorkerInitializationException("Failed get MMS home directory", e);
        }
        String[] args = new String[6];
        Manifest.RuntimeType runtime = this.model.getModelArchive().getManifest().getRuntime();
        args[0] = runtime == Manifest.RuntimeType.PYTHON ? this.configManager.getPythonExecutable() : runtime.getValue();
        args[1] = new File(workingDir, "mms/model_service_worker.py").getAbsolutePath();
        args[2] = "--sock-type";
        args[3] = this.connector.getSocketType();
        args[4] = this.connector.isUds() ? "--sock-name" : "--port";
        args[5] = this.connector.getSocketPath();
        String[] envp = this.getEnvString(workingDir.getAbsolutePath(), modelPath.getAbsolutePath(), this.model.getModelArchive().getManifest().getModel().getHandler());
        try {
            this.latch = new CountDownLatch(1);
            WorkerLifeCycle workerLifeCycle = this;
            synchronized (workerLifeCycle) {
                this.process = Runtime.getRuntime().exec(args, envp, modelPath);
                String threadName = "W-" + port + '-' + this.model.getModelName().substring(0, Math.min(this.model.getModelName().length(), 25));
                new ReaderThread(threadName, this.process.getErrorStream(), true, this).start();
                new ReaderThread(threadName, this.process.getInputStream(), false, this).start();
            }
            if (this.latch.await(2L, TimeUnit.MINUTES)) {
                if (!this.success) {
                    throw new WorkerInitializationException("Backend stream closed.");
                }
                return;
            }
            try {
                throw new WorkerInitializationException("Backend worker startup time out.");
            }
            catch (IOException e) {
                throw new WorkerInitializationException("Failed start worker process", e);
            }
        }
        finally {
            if (!this.success) {
                this.exit();
            }
        }
    }

    public synchronized void exit() {
        if (this.process != null) {
            this.process.destroyForcibly();
            this.process = null;
            this.connector.clean();
        }
    }

    void setSuccess(boolean success) {
        this.success = success;
        this.latch.countDown();
    }

    public synchronized int getPid() {
        return this.pid;
    }

    public synchronized void setPid(int pid) {
        this.pid = pid;
    }

    private synchronized void setPort(int port) {
        this.connector = new Connector(port);
    }

    private static final class ReaderThread
    extends Thread {
        private InputStream is;
        private boolean error;
        private WorkerLifeCycle lifeCycle;
        static final org.apache.log4j.Logger loggerModelMetrics = org.apache.log4j.Logger.getLogger("MODEL_METRICS");

        public ReaderThread(String name, InputStream is, boolean error, WorkerLifeCycle lifeCycle) {
            super(name + (error ? "-stderr" : "-stdout"));
            this.is = is;
            this.error = error;
            this.lifeCycle = lifeCycle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try (Scanner scanner = new Scanner(this.is, StandardCharsets.UTF_8.name());){
                while (scanner.hasNext()) {
                    String result = scanner.nextLine();
                    if (result == null) {
                        break;
                    }
                    if (result.startsWith("[METRICS]")) {
                        loggerModelMetrics.info(Metric.parse(result.substring(9)));
                        continue;
                    }
                    if ("MXNet worker started.".equals(result)) {
                        this.lifeCycle.setSuccess(true);
                    } else if (result.startsWith("[PID]")) {
                        this.lifeCycle.setPid(Integer.parseInt(result.substring("[PID]".length())));
                    }
                    if (this.error) {
                        logger.warn(result);
                        continue;
                    }
                    logger.info(result);
                }
            }
            finally {
                this.lifeCycle.setSuccess(false);
            }
        }
    }
}

