/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.wlm;

import com.amazonaws.ml.mms.wlm.WorkerState;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;

public class WorkerStateListener {
    private CompletableFuture<HttpResponseStatus> future;
    private AtomicInteger count;

    public WorkerStateListener(CompletableFuture<HttpResponseStatus> future, int count) {
        this.future = future;
        this.count = new AtomicInteger(count);
    }

    public void notifyChangeState(String modelName, WorkerState state, HttpResponseStatus status) {
        if (state == WorkerState.WORKER_MODEL_LOADED && this.count.decrementAndGet() == 0) {
            this.future.complete(status);
        }
        if (state == WorkerState.WORKER_ERROR || state == WorkerState.WORKER_STOPPED) {
            this.future.complete(status);
        }
    }
}

