// Copyright 2019 Google LLC & Bastiaan Konings
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// written by bastiaan konings schuiling 2008 - 2015
// this work is public domain. the code is undocumented, scruffy, untested, and should generally not be used for anything important.
// i do not offer support, so don't ask. to be used for inspiration :)

#ifndef _HPP_PLAYEROFFICIAL
#define _HPP_PLAYEROFFICIAL

#include "humanoid/humanoidbase.hpp"
#include "playerbase.hpp"

enum e_OfficialType {
  e_OfficialType_Referee,
  e_OfficialType_Linesman
};

class Match;
class RefereeController;

class PlayerOfficial : public PlayerBase {

  public:
    PlayerOfficial(e_OfficialType officialType, Match *match, PlayerData *playerData);
    virtual ~PlayerOfficial();

    HumanoidBase *CastHumanoid();
    RefereeController *CastController();

    e_OfficialType GetOfficialType() { DO_VALIDATION; return officialType; }

    virtual void Activate(boost::intrusive_ptr<Node> humanoidSourceNode, boost::intrusive_ptr<Node> fullbodySourceNode, std::map<Vector3, Vector3> &colorCoords, boost::intrusive_ptr < Resource<Surface> > kit, boost::shared_ptr<AnimCollection> animCollection, bool lazyPlayer);
    virtual void Deactivate();

    virtual void Process();
    virtual void FetchPutBuffers();

  protected:
    e_OfficialType officialType;

};

#endif
