"""
Basic usage example of the pythonFLEX package.
Demonstrates initialization, data loading, analysis, and plotting.
"""
#%%
import pythonflex as flex
import pandas as pd

depmap = pd.read_csv('../../../../_datasets/depmap/25Q2/gene_effect.csv', index_col=0)
white = pd.read_csv('../../../../_datasets/depmap/25Q2/25Q2_chronos_whitened_PCA.csv', index_col=0).T

inputs = {
    "25Q2": {
        "path": depmap, 
        "sort": "high",
        "color": "#fff000"  # Black
    },

    "25Q2 white": {
        "path": white,
        "sort": "high",
        "color": "#ff0000"  # Orange
    },
}

default_config = {
    "min_genes_in_complex": 0,
    "min_genes_per_complex_analysis": 3,
    "output_folder": "CORUM_25Q2_comparison2",
    "gold_standard": "CORUM",
    "color_map": "BuGn",
    "jaccard": False,
    "use_common_genes": False,  # Set to False for individual dataset-gold standard intersections
    "plotting": {
        "save_plot": True,
        "output_type": "png",
    },
    "preprocessing": {
        "fill_na": True,
        "normalize": False,
    },
    "corr_function": "numpy",
    "logging": {  
        "visible_levels": ["DONE"]  # "PROGRESS", "STARTED", ,"INFO","WARNING"
    }
}

# Initialize logger, config, and output folder
flex.initialize(default_config)

# Load datasets and gold standard terms
data, _ = flex.load_datasets(inputs)
terms, genes_in_terms = flex.load_gold_standard()

# Run analysis
for name, dataset in data.items():
    pra = flex.pra(name, dataset, is_corr=False)
    fpc = flex.pra_percomplex(name, dataset, is_corr=False) 
    flex.mpr_prepare(name)  # Add this line
    cc = flex.complex_contributions(name)




#%%
# Generate plots
flex.plot_precision_recall_curve()
flex.plot_auc_scores()
flex.plot_significant_complexes()
flex.plot_percomplex_scatter(n_top=20)
flex.plot_percomplex_scatter_bysize()
flex.plot_complex_contributions()
flex.plot_mpr_tp_multi()
flex.plot_mpr_complexes_multi()
# Save results to CSV
# flex.save_results_to_csv()

# %%
