/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.encode.ConnectionCharsetInfo;
import com.teradata.jdbc.jdbc.ConnectionFactory;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.ifsupport.EscapeUtil;
import com.teradata.jdbc.jdbc_4.ifsupport.LocalEscapeFunctions;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.ConfigRspParcel;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;

public abstract class ManagerConnectionBase
implements LocalEscapeFunctions {
    protected TDSession m_appSession = null;
    protected String machineName = null;
    protected String userName = null;
    protected String password = null;
    protected URLParameters appUrlParams = null;
    protected boolean connected = false;
    private SQLWarning m_sqlWarningChain = null;
    private final Object m_oWarningChainMutex = new Object();

    protected ManagerConnectionBase(String string, String string2, String string3, URLParameters uRLParameters) throws SQLException {
        this.machineName = string;
        this.userName = string2;
        this.password = string3;
        this.appUrlParams = uRLParameters;
        this.m_appSession = (TDSession)((Object)ConnectionFactory.createConnection(true, this.machineName, this.userName, this.password, this.appUrlParams));
        this.connected = true;
    }

    protected void abortIfClosed() throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
    }

    protected static SQLException chainSQLExceptions(SQLException sQLException, SQLException sQLException2) {
        return Utility.chainSQLExceptions(sQLException, sQLException2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWarning(SQLWarning sQLWarning) {
        Object object = this.m_oWarningChainMutex;
        synchronized (object) {
            if (this.m_sqlWarningChain != null) {
                this.m_sqlWarningChain.setNextWarning(sQLWarning);
            } else {
                this.m_sqlWarningChain = sQLWarning;
            }
        }
    }

    public URLParameters getURLParameters() {
        return this.appUrlParams;
    }

    public ConnectionCharsetInfo getCharsetInfo() {
        return this.m_appSession.getCharsetInfo();
    }

    public boolean isStrictEncode() {
        return this.appUrlParams.getStrictEncode() == Boolean.TRUE;
    }

    public boolean isFailFastSupported() {
        return this.m_appSession.getConfigResponse().isFailFastSupported();
    }

    public Log getLog() {
        return this.m_appSession.getLog();
    }

    protected LocalEscapeFunctions getLocalEscapeFunctions() {
        return this;
    }

    public String getAMPCount() {
        return this.m_appSession.getAMPCount();
    }

    public String getLogLevel() {
        return this.m_appSession.getLogLevel();
    }

    public String setLogLevel(String string) {
        return this.m_appSession.setLogLevel(string);
    }

    public String teradataProvide(String string, Map map) throws SQLException {
        return this.m_appSession.teradataProvide(string, map);
    }

    public String useAnsiDate() {
        return this.m_appSession.useAnsiDate();
    }

    public String useIntegerDate() {
        return this.m_appSession.useIntegerDate();
    }

    public String getSessionNumber() {
        return this.m_appSession.getSessionNumber();
    }

    public String getSocketInfo() {
        return this.m_appSession.getSocketInfo();
    }

    public int getTeradataDatabaseVersionNumber() {
        return this.m_appSession.getTeradataDatabaseVersionNumber();
    }

    public ConfigRspParcel getConfigResponse() {
        return this.m_appSession.getConfigResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWarnings() throws SQLException {
        this.abortIfClosed();
        Object object = this.m_oWarningChainMutex;
        synchronized (object) {
            this.m_sqlWarningChain = null;
            this.m_appSession.clearWarnings();
        }
    }

    public void commit() throws SQLException {
        this.abortIfClosed();
        this.m_appSession.commit();
    }

    public Statement createStatement() throws SQLException {
        this.abortIfClosed();
        return this.m_appSession.createStatement();
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        this.abortIfClosed();
        return this.m_appSession.createStatement(n, n2);
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        return this.m_appSession.createStatement(n, n2, n3);
    }

    public boolean getAutoCommit() throws SQLException {
        this.abortIfClosed();
        return this.m_appSession.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        this.abortIfClosed();
        return this.m_appSession.getCatalog();
    }

    public int getHoldability() throws SQLException {
        this.abortIfClosed();
        return this.m_appSession.getHoldability();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.abortIfClosed();
        return this.m_appSession.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        this.abortIfClosed();
        return this.m_appSession.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        this.abortIfClosed();
        return this.m_appSession.getTypeMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLWarning getWarnings() throws SQLException {
        this.abortIfClosed();
        Object object = this.m_oWarningChainMutex;
        synchronized (object) {
            this.addWarning(this.m_appSession.getWarnings());
            this.m_appSession.clearWarnings();
            return this.m_sqlWarningChain;
        }
    }

    public boolean isClosed() throws SQLException {
        return !this.connected;
    }

    public boolean isReadOnly() throws SQLException {
        this.abortIfClosed();
        return this.m_appSession.isReadOnly();
    }

    public String nativeSQL(String string) throws SQLException {
        this.abortIfClosed();
        return EscapeUtil.nativeSQL(string, this.getLocalEscapeFunctions());
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.abortIfClosed();
        return this.m_appSession.prepareCall(string);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.abortIfClosed();
        return this.m_appSession.prepareCall(string, n, n2);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        return this.m_appSession.prepareCall(string, n, n2, n3);
    }

    protected abstract PreparedStatement createManagerPreparedStatement(PreparedStatement var1) throws SQLException;

    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.abortIfClosed();
        return this.createManagerPreparedStatement(this.m_appSession.prepareStatement(string));
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.abortIfClosed();
        return this.createManagerPreparedStatement(this.m_appSession.prepareStatement(string, n));
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        return this.createManagerPreparedStatement(this.m_appSession.prepareStatement(string, nArray));
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.abortIfClosed();
        return this.createManagerPreparedStatement(this.m_appSession.prepareStatement(string, n, n2));
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        return this.createManagerPreparedStatement(this.m_appSession.prepareStatement(string, n, n2, n3));
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        return this.createManagerPreparedStatement(this.m_appSession.prepareStatement(string, stringArray));
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.abortIfClosed();
        this.m_appSession.releaseSavepoint(savepoint);
    }

    public void rollback() throws SQLException {
        this.abortIfClosed();
        this.m_appSession.rollback();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.abortIfClosed();
        this.m_appSession.rollback(savepoint);
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.abortIfClosed();
        this.m_appSession.setAutoCommit(bl);
    }

    public void setCatalog(String string) throws SQLException {
        this.abortIfClosed();
        this.m_appSession.setCatalog(string);
    }

    public void setHoldability(int n) throws SQLException {
        this.abortIfClosed();
        this.m_appSession.setHoldability(n);
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.abortIfClosed();
        this.m_appSession.setReadOnly(bl);
    }

    public Savepoint setSavepoint() throws SQLException {
        this.abortIfClosed();
        return this.m_appSession.setSavepoint();
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        this.abortIfClosed();
        return this.m_appSession.setSavepoint(string);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.abortIfClosed();
        this.m_appSession.setTransactionIsolation(n);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.abortIfClosed();
        this.m_appSession.setTypeMap(map);
    }

    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        this.abortIfClosed();
        return this.m_appSession.createArrayOf(string, objectArray);
    }

    public Blob createBlob() throws SQLException {
        this.abortIfClosed();
        return this.m_appSession.createBlob();
    }

    public Clob createClob() throws SQLException {
        this.abortIfClosed();
        return this.m_appSession.createClob();
    }

    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        this.abortIfClosed();
        return this.m_appSession.createStruct(string, objectArray);
    }

    public Properties getClientInfo() throws SQLException {
        this.abortIfClosed();
        return this.m_appSession.getClientInfo();
    }

    public String getClientInfo(String string) throws SQLException {
        this.abortIfClosed();
        return this.m_appSession.getClientInfo(string);
    }

    public boolean isValid(int n) throws SQLException {
        return this.m_appSession.isValid(n);
    }
}

