#The UK_ONS_2016_to_2018 tables are based on the data presented in www.ons.gov.uk
#The US_Life_Tables_1959_to_1961 tables are based in the data presented in https://mort.soa.org/

import pandas

UK_ONS_2016_to_2018_male = {\
    'x': [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19,\
          20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37,\
          38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55,\
          56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73,\
          74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91,\
          92, 93, 94, 95, 96, 97, 98, 99, 100], \
    
    'qx': [0.0042, 0.000257, 0.000139, 0.000114, 9.9e-05, 9.3e-05, 8e-05, 7.7e-05, \
           7.1e-05, 6.5e-05, 7.6e-05, 8.6e-05, 9.9e-05, 0.00011, 0.000133, 0.000179, \
           0.000233, 0.000317, 0.000406, 0.00045, 0.000481, 0.000508, 0.000494, \
           0.000524, 0.000544, 0.000599, 0.000597, 0.000604, 0.000696, 0.00073, \
           0.00075, 0.000829, 0.000858, 0.000914, 0.000982, 0.001043, 0.001163, \
           0.001247, 0.001231, 0.001394, 0.001528, 0.001732, 0.001843, 0.002068, \
           0.002131, 0.002294, 0.002452, 0.002728, 0.00287, 0.003154, 0.003376, \
           0.003545, 0.003918, 0.004077, 0.00443, 0.004886, 0.005381, 0.00587, \
           0.00643, 0.007034, 0.007748, 0.008539, 0.009278, 0.010398, 0.011118, \
           0.012208, 0.013568, 0.014493, 0.015896, 0.017209, 0.018695, 0.020663, \
           0.023135, 0.025803, 0.028605, 0.032345, 0.035822, 0.039806, 0.043767, \
           0.048676, 0.054457, 0.060978, 0.067751, 0.07689, 0.086362, 0.09608, \
           0.108379, 0.120527, 0.135267, 0.151119, 0.164525, 0.18145, 0.200309, \
           0.219307, 0.238772, 0.262696, 0.285071, 0.306672, 0.322035, 0.365036, 0.388198], \

    'px': [0.9958, 0.999743, 0.999861, 0.999886, 0.999901, 0.999907, 0.99992, 0.999923, \
           0.999929, 0.999935, 0.999924, 0.999914, 0.999901, 0.99989, 0.999867, 0.999821, \
           0.999767, 0.999683, 0.999594, 0.99955, 0.999519, 0.999492, 0.999506, 0.999476, \
           0.999456, 0.999401, 0.999403, 0.999396, 0.999304, 0.99927, 0.99925, 0.999171, \
           0.999142, 0.999086, 0.999018, 0.998957, 0.998837, 0.998753, 0.998769, 0.998606, \
           0.998472, 0.998268, 0.998157, 0.997932, 0.997869, 0.997706, 0.997548, 0.997272, \
           0.99713, 0.996846, 0.996624, 0.996455, 0.996082, 0.995923, 0.99557, 0.995114, \
           0.994619, 0.99413, 0.99357, 0.992966, 0.992252, 0.991461, 0.990722, 0.989602, \
           0.988882, 0.987792, 0.986432, 0.985507, 0.984104, 0.982791, 0.981305, 0.979337, \
           0.976865, 0.974197, 0.971395, 0.967655, 0.964178, 0.960194, 0.956233, 0.9513240000000001, \
           0.945543, 0.939022, 0.932249, 0.92311, 0.913638, 0.9039200000000001, 0.891621, 0.879473, \
           0.864733, 0.848881, 0.835475, 0.81855, 0.799691, 0.780693, 0.761228, 0.737304, 0.7149289999999999, \
           0.6933279999999999, 0.6779649999999999, 0.634964, 0.611802], \
    
    'lx': [100000, 99580, 99554.5, 99540.6, 99529.2, 99519.4, 99510.1, 99502.2, 99494.5, \
           99487.5, 99481, 99473.5, 99464.9, 99455, 99444.1, 99430.8, 99413, 99389.8, \
           99358.2, 99317.9, 99273.2, 99225.4, 99175, 99126, 99074.1, 99020.2, 98960.9, \
           98901.8, 98842, 98773.2, 98701.1, 98627, 98545.2, 98460.6, 98370.6, 98274, \
           98171.4, 98057.3, 97935, 97814.4, 97678.1, 97528.8, 97359.9, 97180.4, 96979.5, \
           96772.9, 96550.9, 96314.1, 96051.4, 95775.7, 95473.7, 95151.4, 94814.1, 94442.6, \
           94057.5, 93640.8, 93183.3, 92681.9, 92137.9, 91545.4, 90901.4, 90197.1, 89426.9, \
           88597.2, 87676, 86701.2, 85642.7, 84480.7, 83256.3, 81932.9, 80522.9, 79017.5, \
           77384.8, 75594.5, 73643.9, 71537.3, 69223.5, 66743.7, 64086.9, 61282, 58299.1, \
           55124.3, 51762.9, 48256, 44545.6, 40698.5, 36788.2, 32801.1, 28847.7, 24945.6, \
           21175.8, 17691.9, 14481.7, 11580.9, 9041.1, 6882.3, 5074.4, 3627.8, 2515.3, 1705.3, 1082.8], \
    }

UK_ONS_2016_to_2018_female = {\
    'x': [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19,\
          20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37,\
          38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55,\
          56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73,\
          74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91,\
          92, 93, 94, 95, 96, 97, 98, 99, 100], \
    
    'qx': [0.003548, 0.000224, 0.000127, 9.8e-05, 7.3e-05, 8.1e-05, 7.5e-05, 6e-05, 6e-05, 6.2e-05, 5.9e-05, \
           7.6e-05, 6.9e-05, 7.8e-05, 0.000101, 0.000119, 0.000153, 0.000152, 0.000218, 0.000196, 0.000197, \
           0.000224, 0.000219, 0.00022, 0.000226, 0.00026, 0.000252, 0.000286, 0.00033, 0.000314, 0.000374, \
           0.000394, 0.000482, 0.0005, 0.000545, 0.000586, 0.000654, 0.000738, 0.00072, 0.000846, 0.000882, \
           0.000993, 0.001051, 0.001183, 0.001328, 0.001436, 0.00154, 0.0017, 0.001823, 0.001935, 0.002136, \
           0.002363, 0.002581, 0.002756, 0.002952, 0.003265, 0.003621, 0.003896, 0.004324, 0.00473, 0.005104, \
           0.0056, 0.006303, 0.006832, 0.007346, 0.007995, 0.00886, 0.009523, 0.010379, 0.011361, 0.012601, 0.013781, \
           0.015916, 0.017545, 0.019298, 0.022011, 0.025052, 0.027787, 0.031365, 0.034408, 0.038922, 0.043938, 0.049786, \
           0.0575, 0.065049, 0.073792, 0.08425, 0.095303, 0.108358, 0.121616, 0.136979, 0.153256, 0.169425, 0.187195, \
           0.206281, 0.230368, 0.24911, 0.270828, 0.290344, 0.31644, 0.339686], \

    'px': [0.996452, 0.999776, 0.999873, 0.999902, 0.999927, 0.999919, 0.999925, 0.99994, 0.99994, 0.999938, 0.999941, \
           0.999924, 0.999931, 0.999922, 0.999899, 0.999881, 0.999847, 0.999848, 0.999782, 0.999804, 0.999803, 0.999776, \
           0.999781, 0.99978, 0.999774, 0.99974, 0.999748, 0.999714, 0.99967, 0.999686, 0.999626, 0.999606, 0.999518, 0.9995, \
           0.999455, 0.999414, 0.999346, 0.999262, 0.99928, 0.999154, 0.999118, 0.999007, 0.998949, 0.998817, 0.998672, 0.998564, \
           0.99846, 0.9983, 0.998177, 0.998065, 0.997864, 0.997637, 0.9974190000000001, 0.997244, 0.997048, 0.996735, 0.996379, \
           0.996104, 0.995676, 0.99527, 0.994896, 0.9944, 0.993697, 0.993168, 0.992654, 0.992005, 0.99114, 0.990477, 0.989621, \
           0.988639, 0.987399, 0.986219, 0.984084, 0.982455, 0.980702, 0.977989, 0.974948, 0.972213, 0.968635, 0.965592, 0.961078, \
           0.956062, 0.950214, 0.9425, 0.934951, 0.926208, 0.91575, 0.904697, 0.891642, 0.878384, 0.863021, 0.8467439999999999, \
           0.8305750000000001, 0.812805, 0.7937190000000001, 0.769632, 0.7508900000000001, 0.7291719999999999, 0.7096560000000001, \
           0.68356, 0.6603140000000001], \

    'lx': [100000, 99645.2, 99622.9, 99610.2, 99600.5, 99593.2, 99585.1, 99577.6, 99571.7, 99565.7, 99559.5, 99553.7, \
           99546.1, 99539.3, 99531.5, 99521.5, 99509.6, 99494.4, 99479.3, 99457.7, 99438.2, 99418.6, 99396.4, 99374.7, \
           99352.8, 99330.3, 99304.6, 99279.6, 99251.2, 99218.5, 99187.4, 99150.3, 99111.2, 99063.4, 99013.9, 98959.9, \
           98902, 98837.2, 98764.3, 98693.2, 98609.7, 98522.7, 98424.9, 98321.4, 98205.1, 98074.7, 97933.9, 97783, 97616.8, \
           97438.9, 97250.3, 97042.6, 96813.3, 96563.4, 96297.3, 96013.1, 95699.6, 95353.1, 94981.7, 94570.9, 94123.6, 93643.2, \
           93118.8, 92531.9, 91899.7, 91224.6, 90495.2, 89693.5, 88839.3, 87917.3, 86918.4, 85823.2, 84640.4, 83293.2, 81831.8, \
           80252.6, 78486.2, 76520, 74393.8, 72060.4, 69581, 66872.7, 63934.5, 60751.4, 57258.2, 53533.6, 49583.3, 45405.9, \
           41078.6, 36627.4, 32172.9, 27765.9, 23510.6, 19527.3, 15871.9, 12597.8, 9695.7, 7280.4, 5308.7, 3767.3, 2575.2], \
    }

US_Life_Tables_1959_to_1961_male_NB = {\
    'x': [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, \
          20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, \
          38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, \
          56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, \
          74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, \
          92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109], \
    
    'qx': [0.02913, 0.00181, 0.00115, 0.00088, 0.00074, 0.00066, 0.0006, 0.00055, 0.00051, 0.00047, 0.00044, 0.00044, 0.0005, \
           0.00062, 0.00078, 0.00097, 0.00114, 0.00131, 0.00145, 0.00156, 0.00169, 0.0018, 0.00187, 0.00187, 0.00181, 0.00175, \
           0.00169, 0.00167, 0.00169, 0.00174, 0.00181, 0.00189, 0.00199, 0.0021, 0.00224, 0.0024, 0.00259, 0.00281, 0.00308, \
           0.00338, 0.00373, 0.00412, 0.00455, 0.00501, 0.00551, 0.00605, 0.00665, 0.00735, 0.00818, 0.00911, 0.01014, 0.0112, \
           0.01228, 0.01333, 0.0144, 0.01549, 0.0167, 0.01809, 0.01971, 0.02154, 0.0235, 0.02554, 0.02769, 0.02992, 0.03226, 0.03474, \
           0.03739, 0.04017, 0.04307, 0.04612, 0.04936, 0.05285, 0.05665, 0.06083, 0.06541, 0.07035, 0.07571, 0.08176, 0.0887, 0.09661, \
           0.10598, 0.11654, 0.12732, 0.13728, 0.14623, 0.15768, 0.17002, 0.18343, 0.19868, 0.21564, 0.2332, 0.25056, 0.26792, 0.28481, \
           0.3005, 0.31416, 0.32915, 0.3445, 0.36018, 0.37616, 0.39242, 0.40891, 0.42562, 0.4425, 0.45951, 0.47662, 0.49378, 0.51095, \
           0.5281, 0.54519], \

    'px': [0.97087, 0.99819, 0.99885, 0.99912, 0.99926, 0.99934, 0.9994, 0.99945, 0.99949, 0.99953, 0.99956, 0.99956, 0.9995, \
           0.99938, 0.99922, 0.99903, 0.99886, 0.99869, 0.99855, 0.99844, 0.99831, 0.9982, 0.99813, 0.99813, 0.99819, 0.99825, \
           0.99831, 0.99833, 0.99831, 0.99826, 0.99819, 0.99811, 0.99801, 0.9979, 0.99776, 0.9976, 0.99741, 0.99719, 0.99692, 0.99662, \
           0.99627, 0.99588, 0.99545, 0.99499, 0.99449, 0.99395, 0.99335, 0.99265, 0.99182, 0.99089, 0.98986, 0.9888, 0.98772, 0.98667, \
           0.9856, 0.98451, 0.9833, 0.98191, 0.98029, 0.97846, 0.9765, 0.97446, 0.97231, 0.97008, 0.96774, 0.96526, 0.96261, 0.95983, \
           0.9569300000000001, 0.95388, 0.95064, 0.94715, 0.94335, 0.93917, 0.93459, 0.92965, 0.9242900000000001, 0.91824, 0.9113, \
           0.90339, 0.89402, 0.88346, 0.87268, 0.8627199999999999, 0.85377, 0.84232, 0.8299799999999999, 0.81657, 0.80132, 0.78436, \
           0.7668, 0.74944, 0.7320800000000001, 0.71519, 0.6995, 0.68584, 0.67085, 0.6555, 0.63982, 0.62384, 0.60758, 0.59109, 0.57438, \
           0.5575, 0.54049, 0.52338, 0.50622, 0.48905, 0.4719, 0.45481000000000005]\
    }

US_Life_Tables_1959_to_1961_female_NB = {\
    'x': [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, \
          20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, \
          38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, \
          56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, \
          74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, \
          92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109], \
    
    'qx': [0.02256, 0.00158, 0.00093, 0.00071, 0.0006, 0.00052, 0.00045, 0.00039, 0.00035, 0.00032, 0.0003, 0.00029, 0.0003, 0.00034, \
           0.00038, 0.00044, 0.0005, 0.00055, 0.00059, 0.00061, 0.00064, 0.00067, 0.0007, 0.00073, 0.00076, 0.00079, 0.00082, 0.00087, \
           0.00092, 0.00098, 0.00106, 0.00114, 0.00122, 0.00131, 0.0014, 0.00151, 0.00163, 0.00177, 0.00192, 0.0021, 0.0023, 0.00251, \
           0.00274, 0.00298, 0.00324, 0.00351, 0.00381, 0.00415, 0.00453, 0.00495, 0.00541, 0.0059, 0.00639, 0.00686, 0.00733, 0.00783, \
           0.00841, 0.00911, 0.00997, 0.01097, 0.01209, 0.01327, 0.01451, 0.01578, 0.01711, 0.01854, 0.02014, 0.02199, 0.02415, 0.02661, \
           0.02929, 0.03219, 0.03546, 0.03914, 0.04327, 0.04767, 0.05246, 0.05804, 0.06469, 0.0724, 0.08144, 0.09143, 0.10154, 0.11096, \
           0.11975, 0.13423, 0.15009, 0.16689, 0.18478, 0.20364, 0.22329, 0.24327, 0.26302, 0.28181, 0.29903, 0.31416, 0.32915, 0.3445, \
           0.36018, 0.37616, 0.39242, 0.40891, 0.42562, 0.4425, 0.45951, 0.47662, 0.49378, 0.51095, 0.5281, 0.54519], \

    'px': [0.97744, 0.99842, 0.99907, 0.99929, 0.9994, 0.99948, 0.99955, 0.99961, 0.99965, 0.99968, 0.9997, 0.99971, 0.9997, 0.99966, \
           0.99962, 0.99956, 0.9995, 0.99945, 0.99941, 0.99939, 0.99936, 0.99933, 0.9993, 0.99927, 0.99924, 0.99921, 0.99918, 0.99913, \
           0.99908, 0.99902, 0.99894, 0.99886, 0.99878, 0.99869, 0.9986, 0.99849, 0.99837, 0.99823, 0.99808, 0.9979, 0.9977, 0.99749, \
           0.99726, 0.99702, 0.99676, 0.99649, 0.99619, 0.99585, 0.99547, 0.99505, 0.99459, 0.9941, 0.99361, 0.99314, 0.99267, 0.99217, \
           0.99159, 0.99089, 0.99003, 0.98903, 0.98791, 0.98673, 0.98549, 0.98422, 0.98289, 0.98146, 0.97986, 0.97801, 0.97585, 0.97339, \
           0.97071, 0.96781, 0.96454, 0.96086, 0.95673, 0.95233, 0.94754, 0.94196, 0.93531, 0.9276, 0.91856, 0.90857, 0.89846, 0.88904, \
           0.88025, 0.86577, 0.8499099999999999, 0.83311, 0.8152200000000001, 0.79636, 0.77671, 0.75673, 0.73698, 0.71819, 0.70097, 0.68584, \
           0.67085, 0.6555, 0.63982, 0.62384, 0.60758, 0.59109, 0.57438, 0.5575, 0.54049, 0.52338, 0.50622, 0.48905, 0.4719, 0.45481000000000005]\
    }

table_dictionary = {'UK_ONS_2016_to_2018_male': UK_ONS_2016_to_2018_male, \
                    'UK_ONS_2016_to_2018_female': UK_ONS_2016_to_2018_female, \
                    'US_Life_Tables_1959_to_1961_male_NB': US_Life_Tables_1959_to_1961_male_NB, \
                    'US_Life_Tables_1959_to_1961_female_NB': US_Life_Tables_1959_to_1961_female_NB}


class MortalityTable(object):
    
    def __init__(self, table_name, custom = False):
        if custom == False:
            self.table_name = table_name
            self.table = table_dictionary[self.table_name]
        else:
            self.table_name = table_name
            self.table = custom

    @property
    def as_df(self):
        df = pandas.DataFrame(data=[[i,j,k] for i,j,k in \
                                    zip(self.table['x'], self.table['qx'], self.table['px'])], \
                              columns = ['x', 'qx', 'px'])
        self.df = df
        return df
    
    def multiple_qx(self, percent, age_interval = None, value_interval = None):
        if percent < 0:
            return None
        qx = [j for j in self.table['qx']]
        if (age_interval == None) and (value_interval == None):
            qx = [min(i*(percent), 1) for i in self.table['qx']]
        elif (age_interval != None) and (value_interval == None):
            for i in range(len(self.table['x'])):
                if (age_interval[0] <= self.table['x'][i] <= age_interval[1]):
                    qx[i] = min(qx[i]*(percent), 1)
        elif (age_interval == None) and (value_interval != None):
            for i in range(len(self.table['x'])):
                if value_interval[0] <= self.table['qx'][i] <= value_interval[1]:
                    qx[i] = min(qx[i]*(percent), 1)
        else:
            for i in range(len(self.table['x'])):
                if (value_interval[0] <= self.table['qx'][i] <= value_interval[1]) \
                   and (age_interval[0] <= self.table['x'][i] <= age_interval[1]):
                    qx[i] = min(qx[i]*(percent), 1)
        px = [1-i for i in qx]
        return {'x': self.table['x'], 'qx': qx, 'px': px}

    def multiple_px(self, percent, age_interval = None, value_interval = None):
        px = [j for j in self.table['px']]
        if (age_interval == None) and (value_interval == None):
            px = [min(i*(percent), 1) for i in self.table['px']]
        elif (age_interval != None) and (value_interval == None):
            for i in range(len(self.table['x'])):
                if (age_interval[0] <= self.table['x'][i] <= age_interval[1]):
                    px[i] = min(px[i]*(percent), 1)
        elif (age_interval == None) and (value_interval != None):
            for i in range(len(self.table['x'])):
                if value_interval[0] <= self.table['px'][i] <= value_interval[1]:
                    px[i] = min(px[i]*(percent), 1)
        else:
            for i in range(len(self.table['x'])):
                if (value_interval[0] <= self.table['px'][i] <= value_interval[1]) \
                   and (age_interval[0] <= self.table['x'][i] <= age_interval[1]):
                    px[i] = min(px[i]*(percent), 1)
        qx = [1-i for i in px]
        return {'x': self.table['x'], 'qx': qx, 'px': px}

    def increase_qx(self, delta, age_interval = None, value_interval = None):
        qx = [j for j in self.table['qx']]
        if (age_interval == None) and (value_interval == None):
            qx = [max(min(i + delta, 1),0) for i in self.table['qx']]
        elif (age_interval != None) and (value_interval == None):
            for i in range(len(self.table['x'])):
                if (age_interval[0] <= self.table['x'][i] <= age_interval[1]):
                    qx[i] = max(min(qx[i] + delta, 1),0)
        elif (age_interval == None) and (value_interval != None):
            for i in range(len(self.table['x'])):
                if value_interval[0] <= self.table['qx'][i] <= value_interval[1]:
                    qx[i] = max(min(qx[i] + delta, 1),0)
        else:
            for i in range(len(self.table['x'])):
                if (value_interval[0] <= self.table['qx'][i] <= value_interval[1]) \
                   and (age_interval[0] <= self.table['x'][i] <= age_interval[1]):
                    qx[i] = max(min(qx[i] + delta, 1),0)
        px = [1-i for i in qx]
        return {'x': self.table['x'], 'qx': qx, 'px': px}

    def increase_px(self, delta, age_interval = None, value_interval = None):
        px = [j for j in self.table['px']]
        if (age_interval == None) and (value_interval == None):
            px = [max(min(i + delta, 1),0) for i in self.table['px']]
        elif (age_interval != None) and (value_interval == None):
            for i in range(len(self.table['x'])):
                if (age_interval[0] <= self.table['x'][i] <= age_interval[1]):
                    px[i] = max(min(px[i] + delta, 1),0)
        elif (age_interval == None) and (value_interval != None):
            for i in range(len(self.table['x'])):
                if value_interval[0] <= self.table['px'][i] <= value_interval[1]:
                    px[i] = max(min(px[i] + delta, 1),0)
        else:
            for i in range(len(self.table['x'])):
                if (value_interval[0] <= self.table['px'][i] <= value_interval[1]) \
                   and (age_interval[0] <= self.table['x'][i] <= age_interval[1]):
                    px[i] = max(min(px[i] + delta, 1),0)
        qx = [1-i for i in px]
        return {'x': self.table['x'], 'qx': qx, 'px': px}
