import sys

RUNNING_MICROPYTHON = sys.implementation.name == 'micropython'


ATTACH_PREVIOUS_NODE_BLOCK = True

BROADCAST_SEND_INTERVAL_SECONDS = 30

BROADCAST_TIMEOUT_SECONDS = 120

ENCODING = 'utf-8'

IPND_IDENTIFIER_MTCP = 'mtcp'
IPND_IDENTIFIER_REST = 'rest'  # unofficial, to be used to manually add the rest-cla to a known dtn7rs-node
IPND_SEND_INTERVAL_MILLISECONDS = 10000

if RUNNING_MICROPYTHON:
    IPND_BEACON_MAX_SIZE = 256  # for some reason a bigger datagram receive leads to memory leaks ???
else:
    IPND_BEACON_MAX_SIZE = 4096

if RUNNING_MICROPYTHON:
    MTCP_MAX_CONNECTIONS_STATE_WAITING = 1
    MTCP_MAX_CONNECTIONS_STATE_OPEN_RECEIVE = 4
    MTCP_TIMEOUT_MILLISECONDS_INACTIVE_RECEIVE = 5000
else:
    MTCP_MAX_CONNECTIONS_STATE_WAITING = 5
    MTCP_MAX_CONNECTIONS_STATE_OPEN_RECEIVE = 10000
    MTCP_TIMEOUT_MILLISECONDS_INACTIVE_RECEIVE = 1000000

MTCP_TIMEOUT_MILLISECONDS_STALLED_SEND = 500
MTCP_TIMEOUT_SECONDS_OPEN_SEND_CONNECTION = 1

PORT_BEACON_UDP = 7000
PORT_REST = 3000
PORT_MTCP = 16162
PORT_IPND = 3003

RETRY_INTERVAL_MILLISECONDS = 5000

SEND_STATUS_REPORTS_ENABLED = False

SIMPLE_EPIDEMIC_ROUTER_MIN_NODES_TO_FORWARD_TO = 3

if RUNNING_MICROPYTHON:
    SIMPLE_IN_MEMORY_STORAGE_MAX_STORED_BUNDLES = 7  # experimental setting
    SIMPLE_IN_MEMORY_STORAGE_MAX_KNOWN_BUNDLE_IDS = 18  # experimental setting
else:
    SIMPLE_IN_MEMORY_STORAGE_MAX_STORED_BUNDLES = 10000
    SIMPLE_IN_MEMORY_STORAGE_MAX_KNOWN_BUNDLE_IDS = 100000

SOCKET_RECEIVE_BUFFER_SIZE = 512


DEBUG = False
WARNING = True
