"""This file provides autocompletions for the ZOS-API and was automatically generated.
It should not be edited manually.
"""

from __future__ import annotations

from typing import Iterable, overload

from zospy.api._ZOSAPI.Analysis import GiaShowAsTypes, SampleSizes
from zospy.api._ZOSAPI.Analysis.Settings import (
    IAS_,
    Parity,
    ReferenceGia,
    Rotations,
    ScanTypes,
    SourceGia,
)

__all__ = (
    "IAS_GeometricImageAnalysis",
    "IAS_ImageSimulation",
    "IAS_RelativeIllumination",
    "ISAberrationTypes",
    "ISFlipTypes",
    "ISSamplings",
    "ISShowAsTypes",
)

class IAS_GeometricImageAnalysis(IAS_):
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @property
    def Field(self) -> IAS_Field: ...
    @property
    def Surface(self) -> IAS_Surface: ...
    @property
    def FieldSize(self) -> float: ...
    @FieldSize.setter
    def FieldSize(self, value: float) -> None: ...
    @property
    def ImageSize(self) -> float: ...
    @ImageSize.setter
    def ImageSize(self, value: float) -> None: ...
    @property
    def File(self) -> str: ...
    @File.setter
    def File(self, value: str) -> None: ...
    @property
    def Rotation(self) -> float: ...
    @Rotation.setter
    def Rotation(self, value: float) -> None: ...
    @property
    def RaysX1000(self) -> int: ...
    @RaysX1000.setter
    def RaysX1000(self, value: int) -> None: ...
    @property
    def ShowAs(self) -> GiaShowAsTypes: ...
    @ShowAs.setter
    def ShowAs(self, value: GiaShowAsTypes) -> None: ...
    @property
    def Source(self) -> SourceGia: ...
    @Source.setter
    def Source(self, value: SourceGia) -> None: ...
    @property
    def NumberOfPixels(self) -> int: ...
    @NumberOfPixels.setter
    def NumberOfPixels(self, value: int) -> None: ...
    @property
    def NA(self) -> float: ...
    @NA.setter
    def NA(self, value: float) -> None: ...
    @property
    def TotalWatts(self) -> float: ...
    @TotalWatts.setter
    def TotalWatts(self, value: float) -> None: ...
    @property
    def Parity(self) -> Parity: ...
    @Parity.setter
    def Parity(self, value: Parity) -> None: ...
    @property
    def Reference(self) -> ReferenceGia: ...
    @Reference.setter
    def Reference(self, value: ReferenceGia) -> None: ...
    @property
    def UseSymbols(self) -> bool: ...
    @UseSymbols.setter
    def UseSymbols(self, value: bool) -> None: ...
    @property
    def UsePolarization(self) -> bool: ...
    @UsePolarization.setter
    def UsePolarization(self, value: bool) -> None: ...
    @property
    def RemoveVignettingFactors(self) -> bool: ...
    @RemoveVignettingFactors.setter
    def RemoveVignettingFactors(self, value: bool) -> None: ...
    @property
    def ScatterRays(self) -> bool: ...
    @ScatterRays.setter
    def ScatterRays(self, value: bool) -> None: ...
    @property
    def DeleteVignetted(self) -> bool: ...
    @DeleteVignetted.setter
    def DeleteVignetted(self, value: bool) -> None: ...
    @property
    def UsePixelInterpolation(self) -> bool: ...
    @UsePixelInterpolation.setter
    def UsePixelInterpolation(self, value: bool) -> None: ...
    @property
    def SaveAsBIMFile(self) -> str: ...
    @SaveAsBIMFile.setter
    def SaveAsBIMFile(self, value: str) -> None: ...
    @property
    def RowColumnNumber(self) -> int: ...
    @RowColumnNumber.setter
    def RowColumnNumber(self, value: int) -> None: ...
    def GetFileNames(self) -> list[str]: ...
    def UseColumnRowCenter(self) -> bool: ...

class IAS_ImageSimulation(IAS_):
    @property
    def InputFile(self) -> str: ...
    @InputFile.setter
    def InputFile(self, value: str) -> None: ...
    @property
    def FieldHeight(self) -> float: ...
    @FieldHeight.setter
    def FieldHeight(self, value: float) -> None: ...
    @property
    def FlipSource(self) -> ISFlipTypes: ...
    @FlipSource.setter
    def FlipSource(self, value: ISFlipTypes) -> None: ...
    @property
    def RotationSource(self) -> Rotations: ...
    @RotationSource.setter
    def RotationSource(self, value: Rotations) -> None: ...
    @property
    def Oversampling(self) -> ISSamplings: ...
    @Oversampling.setter
    def Oversampling(self, value: ISSamplings) -> None: ...
    @property
    def GuardBand(self) -> ISSamplings: ...
    @GuardBand.setter
    def GuardBand(self, value: ISSamplings) -> None: ...
    @property
    def Field(self) -> IAS_Field: ...
    @property
    def PupilSampling(self) -> SampleSizes: ...
    @PupilSampling.setter
    def PupilSampling(self, value: SampleSizes) -> None: ...
    @property
    def ImageSampling(self) -> SampleSizes: ...
    @ImageSampling.setter
    def ImageSampling(self, value: SampleSizes) -> None: ...
    @property
    def Aberrations(self) -> ISAberrationTypes: ...
    @Aberrations.setter
    def Aberrations(self, value: ISAberrationTypes) -> None: ...
    @property
    def PSFXPoints(self) -> int: ...
    @PSFXPoints.setter
    def PSFXPoints(self, value: int) -> None: ...
    @property
    def PSFYPoints(self) -> int: ...
    @PSFYPoints.setter
    def PSFYPoints(self, value: int) -> None: ...
    @property
    def UsePolarization(self) -> bool: ...
    @UsePolarization.setter
    def UsePolarization(self, value: bool) -> None: ...
    @property
    def ApplyFixedApertures(self) -> bool: ...
    @ApplyFixedApertures.setter
    def ApplyFixedApertures(self, value: bool) -> None: ...
    @property
    def UseRelativeIllumination(self) -> bool: ...
    @UseRelativeIllumination.setter
    def UseRelativeIllumination(self, value: bool) -> None: ...
    @property
    def ShowAs(self) -> ISShowAsTypes: ...
    @ShowAs.setter
    def ShowAs(self, value: ISShowAsTypes) -> None: ...
    @property
    def Reference(self) -> ReferenceGia: ...
    @Reference.setter
    def Reference(self, value: ReferenceGia) -> None: ...
    @property
    def FlipImage(self) -> ISFlipTypes: ...
    @FlipImage.setter
    def FlipImage(self, value: ISFlipTypes) -> None: ...
    @property
    def PixelSize(self) -> float: ...
    @PixelSize.setter
    def PixelSize(self, value: float) -> None: ...
    @property
    def XPixels(self) -> int: ...
    @XPixels.setter
    def XPixels(self, value: int) -> None: ...
    @property
    def YPixels(self) -> int: ...
    @YPixels.setter
    def YPixels(self, value: int) -> None: ...
    @property
    def SuppressFrame(self) -> bool: ...
    @SuppressFrame.setter
    def SuppressFrame(self, value: bool) -> None: ...
    @property
    def OutputFile(self) -> str: ...
    @OutputFile.setter
    def OutputFile(self, value: str) -> None: ...
    def GetInputFileNames(self) -> list[str]: ...
    def GetWavelength123(self) -> bool: ...
    def GetWavelengthNumber(self) -> int: ...
    def GetWavelengthRGB(self) -> bool: ...
    def SetWavelength123(self) -> None: ...
    def SetWavelengthNumber(self, wlNum: int) -> None: ...
    def SetWavelengthRGB(self) -> None: ...

class IAS_RelativeIllumination(IAS_):
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @property
    def ScanType(self) -> ScanTypes: ...
    @ScanType.setter
    def ScanType(self, value: ScanTypes) -> None: ...
    @property
    def RayDensity(self) -> int: ...
    @RayDensity.setter
    def RayDensity(self, value: int) -> None: ...
    @property
    def FieldDensity(self) -> int: ...
    @FieldDensity.setter
    def FieldDensity(self, value: int) -> None: ...
    @property
    def UsePolarization(self) -> bool: ...
    @UsePolarization.setter
    def UsePolarization(self, value: bool) -> None: ...
    @property
    def LogScale(self) -> bool: ...
    @LogScale.setter
    def LogScale(self, value: bool) -> None: ...
    @property
    def RemoveVignettingFactors(self) -> bool: ...
    @RemoveVignettingFactors.setter
    def RemoveVignettingFactors(self, value: bool) -> None: ...

class ISAberrationTypes:
    # None = 0
    Geometric = 1
    Diffraction = 2

class ISFlipTypes:
    # None = 0
    TopBottom = 1
    LeftRight = 2
    TopBottomLeftRight = 3

class ISSamplings:
    # None = 0
    X2 = 1
    X4 = 2
    X8 = 3
    X16 = 4
    X32 = 5
    X64 = 6

class ISShowAsTypes:
    SimulatedImage = 0
    SourceBitmap = 1
    PSFGrid = 2
