#!/bin/bash

# 6809dasm.pl and asm6809.pl can be downloaded here:
#   http://www.6809.org.uk/dragon/

(
    set -x
    ./6809dasm.pl org=0x8000 \
	comment=0x8000,"standard JMP vectors" \
	comment=0x8000,"hardware routines" \
	comment=0x8000,"reset" \
	comment=0x8003,"set up \$8f - \$9b" \
	comment=0x8006,"scan keyboard (A)" \
	comment=0x8009,"blink cursor" \
	comment=0x800c,"write to VDU (A)" \
	comment=0x800f,"write to printer (A)" \
	comment=0x8012,"update joysticks" \
	comment=0x8015,"tape routines" \
	comment=0x8015,"motoron" \
	comment=0x8018,"motoroff" \
	comment=0x801b,"write leader" \
	comment=0x801e,"byte out (A)" \
	comment=0x8021,"read leader" \
	comment=0x8024,"byte in (A)" \
	comment=0x8027,"bit in (C)" \
	comment=0x802a,"serial routines" \
	comment=0x802a,"read serial (A)" \
	comment=0x802d,"write serial (A)" \
	comment=0x8030,"baud rate select" \
	comment=0x8033,"command table : last byte of each string has MSB set" \
	comment=0x8033,"(token in final column)" \
	comment=0x8033,"FOR     80" \
	comment=0x8036,"GO      81" \
	comment=0x8038,"REM     82" \
	comment=0x803b,"'       83" \
	comment=0x803c,"ELSE    84" \
	comment=0x8040,"IF      85" \
	comment=0x8042,"DATA    86" \
	comment=0x8046,"PRINT   87" \
	comment=0x804b,"ON      88" \
	comment=0x804d,"INPUT   89" \
	comment=0x8052,"END     8A" \
	comment=0x8055,"NEXT    8B" \
	comment=0x8059,"DIM     8C" \
	comment=0x805c,"READ    8D" \
	comment=0x8060,"LET     8E" \
	comment=0x8063,"RUN     8F" \
	comment=0x8066,"RESTORE 90" \
	comment=0x806d,"RETURN  91" \
	comment=0x8073,"STOP    92" \
	comment=0x8077,"POKE    93" \
	comment=0x807b,"CONT    94" \
	comment=0x807f,"LIST    95" \
	comment=0x8083,"CLEAR   96" \
	comment=0x8088,"NEW     97" \
	comment=0x808b,"DEF     98" \
	comment=0x808e,"CLOAD   99" \
	comment=0x8093,"CSAVE   9A" \
	comment=0x8098,"OPEN    9B" \
	comment=0x809c,"CLOSE   9C" \
	comment=0x80a1,"LLIST   9D" \
	comment=0x80a6,"SET     9E" \
	comment=0x80a9,"RESET   9F" \
	comment=0x80ae,"CLS     A0" \
	comment=0x80b1,"MOTOR   A1" \
	comment=0x80b6,"SOUND   A2" \
	comment=0x80bb,"AUDIO   A3" \
	comment=0x80c0,"EXEC    A4" \
	comment=0x80c4,"SKIPF   A5" \
	comment=0x80c9,"DEL     A6" \
	comment=0x80cc,"EDIT    A7" \
	comment=0x80d0,"TRON    A8" \
	comment=0x80d4,"TROFF   A9" \
	comment=0x80d9,"LINE    AA" \
	comment=0x80dd,"PCLS    AB" \
	comment=0x80e1,"PSET    AC" \
	comment=0x80e5,"PRESET  AD" \
	comment=0x80eb,"SCREEN  AE" \
	comment=0x80f1,"PCLEAR  AF" \
	comment=0x80f7,"COLOR   B0" \
	comment=0x80fc,"CIRCLE  B1" \
	comment=0x8102,"PAINT   B2" \
	comment=0x8107,"GET     B3" \
	comment=0x810a,"PUT     B4" \
	comment=0x810d,"DRAW    B5" \
	comment=0x8111,"PCOPY   B6" \
	comment=0x8116,"PMODE   B7" \
	comment=0x811b,"PLAY    B8" \
	comment=0x811f,"DLOAD   B9" \
	comment=0x8124,"RENUM   BA" \
	comment=0x8129,"TAB(    BB" \
	comment=0x812d,"TO      BC" \
	comment=0x812f,"SUB     BD" \
	comment=0x8132,"FN      BE" \
	comment=0x8134,"THEN    BF" \
	comment=0x8138,"NOT     C0" \
	comment=0x813b,"STEP    C1" \
	comment=0x813f,"OFF     C2" \
	comment=0x8142,"+       C3" \
	comment=0x8143,"-       C4" \
	comment=0x8144,"C5" \
	comment=0x8145,"/       C6" \
	comment=0x8146,"^       C7" \
	comment=0x8147,"AND     C8" \
	comment=0x814a,"OR      C9" \
	comment=0x814c,">       CA" \
	comment=0x814d,"=       CB" \
	comment=0x814e,"<       CC" \
	comment=0x814f,"USING   CD" \
	comment=0x8154,"command vectors" \
	comment=0x8154,"for go rem '" \
	comment=0x815c,"else if data print" \
	comment=0x8164,"on input end next" \
	comment=0x816c,"dim read let run" \
	comment=0x8174,"restore return stop poke" \
	comment=0x817c,"cont list clear new" \
	comment=0x8184,"def cload csave open" \
	comment=0x818c,"close llist set reset" \
	comment=0x8194,"cls motor sound audio" \
	comment=0x819c,"exec skipf del edit" \
	comment=0x81a4,"tron troff line pcls" \
	comment=0x81ac,"pset preset screen pclear" \
	comment=0x81b4,"color circle paint get" \
	comment=0x81bc,"put draw pcopy pmode" \
	comment=0x81c4,"play dload renum" \
	comment=0x81ca,"function table : last byte of each string has MSB set" \
	comment=0x81ca,"(token in final column)" \
	comment=0x81ca,"SGN     FF80" \
	comment=0x81cd,"INT     FF81" \
	comment=0x81d0,"ABS     FF82" \
	comment=0x81d3,"POS     FF83" \
	comment=0x81d6,"RND     FF84" \
	comment=0x81d9,"SQR     FF85" \
	comment=0x81dc,"LOG     FF86" \
	comment=0x81df,"EXP     FF87" \
	comment=0x81e2,"SIN     FF88" \
	comment=0x81e5,"COS     FF89" \
	comment=0x81e8,"TAN     FF8A" \
	comment=0x81eb,"ATN     FF8B" \
	comment=0x81ee,"PEEK    FF8C" \
	comment=0x81f2,"LEN     FF8D" \
	comment=0x81f5,"STR\$    FF8E" \
	comment=0x81f9,"VAL     FF8F" \
	comment=0x81fc,"ASC     FF90" \
	comment=0x81ff,"CHR\$    FF91" \
	comment=0x8203,"EOF     FF92" \
	comment=0x8206,"JOYSTK  FF93" \
	comment=0x820c,"FIX     FF94" \
	comment=0x820f,"HEX\$    FF95" \
	comment=0x8213,"LEFT\$   FF96" \
	comment=0x8218,"RIGHT\$  FF97" \
	comment=0x821e,"MID\$    FF98" \
	comment=0x8222,"POINT   FF99" \
	comment=0x8227,"INKEY\$  FF9A" \
	comment=0x822d,"MEM     FF9B" \
	comment=0x8230,"VARPTR  FF9C" \
	comment=0x8236,"INSTR   FF9D" \
	comment=0x823b,"TIMER   FF9E" \
	comment=0x8240,"PPOINT  FF9F" \
	comment=0x8246,"STRING\$ FFA0" \
	comment=0x824d,"USR     FFA1" \
	comment=0x8250,"function vectors" \
	comment=0x8250,"sgn int abs pos" \
	comment=0x8258,"rnd sqr log exp" \
	comment=0x8260,"sin cos tan atn" \
	comment=0x8268,"peek len str\$ val" \
	comment=0x8270,"asc chr\$ eof joystk" \
	comment=0x8278,"fix hex\$ left\$ right\$" \
	comment=0x8280,"mid\$ point inkey\$ mem" \
	comment=0x8288,"varptr instr timer ppoint" \
	comment=0x8290,"string\$ usr" \
	comment=0x8294,"binary operator table used during expression evaluation" \
	comment=0x8294,"(1st byte is precedence level followed by address of handler)" \
	comment=0x8294,"+" \
	comment=0x8297,"-" \
	comment=0x829a,"" \
	comment=0x829d,"/" \
	comment=0x82a0,"^" \
	comment=0x82a3,"AND" \
	comment=0x82a6,"OR" \
	comment=0x82a9,"error code strings" \
	comment=0x82df,"misc strings" \
	comment=0x82df,"/ERROR /" \
	comment=0x82e6,"/ IN /" \
	comment=0x82eb,"CR/OK/CR" \
	comment=0x82f0,"CR/BREAK/" \
	comment=0x82f7,"examine BASIC stack (maintained 'under' machine return addresses)" \
	comment=0x82f7,"\$3b = varptr of FOR control variable to search for (zero if none)" \
	comment=0x82f7,"set \$3b to #\$ff to skip all FOR entries" \
	comment=0x82f7,"returns X = \$0f = pointer to matching entry for FOR / NEXT" \
	comment=0x82f7,"\$3b = varptr of control variable for unspecified NEXT" \
	comment=0x82f7,"Z = 0 if matching FOR entry not found" \
	comment=0x82f7,"point X past 2 return addresses" \
	comment=0x82f9,"size of FOR stack entry" \
	comment=0x82fb,"\$0f = this entry" \
	comment=0x8301,"not a FOR entry" \
	comment=0x8305,"varptr of control variable" \
	comment=0x8309,"we were called by NEXT with no variable" \
	comment=0x830d,"found a matching entry" \
	comment=0x8311,"point X to next stack entry" \
	comment=0x8312,"examine next entry" \
	comment=0x8314,"set \$3b up with varptr of control variable" \
	comment=0x8316,"for unspecified NEXT" \
	comment=0x831c,"move memory contents up" \
	comment=0x831c,"start address   - \$47" \
	comment=0x831c,"end address     - \$43" \
	comment=0x831c,"new end address - \$41 (D = new end address for memory check)" \
	comment=0x831c,"returns \$45 = U = start of relocated block" \
	comment=0x831c,"memory check" \
	comment=0x8331,"check if there are B free words of storage left" \
	comment=0x8333,"end of BASIC storage" \
	comment=0x8338,"?OM ERROR" \
	comment=0x8340,"RTS" \
	comment=0x8342,"?OM ERROR" \
	comment=0x8344,"?xx ERROR - error code in B" \
	comment=0x8344,"user error trap" \
	comment=0x8347,"system error trap" \
	comment=0x834a,"cassette relay off" \
	comment=0x834d,"disable audio" \
	comment=0x8350,"reset stack & bits & pieces" \
	comment=0x8353,"DEVN" \
	comment=0x8355,"initialise virtual DEVN device & new line" \
	comment=0x8358,"print '?' to DEVN" \
	comment=0x835b,"error string table" \
	comment=0x835f,"output to DEVN from ,X+" \
	comment=0x8361,"output to DEVN from ,X+" \
	comment=0x8363,"'ERROR'" \
	comment=0x8366,"print string to DEVN" \
	comment=0x8369,"current line number" \
	comment=0x836c,"command mode" \
	comment=0x836e,"print 'IN xxxx' (current line number)" \
	comment=0x8371,"command mode" \
	comment=0x8371,"initialise virtual DEVN device & new line" \
	comment=0x8377,"print 'OK'" \
	comment=0x837a,"line input from DEVN" \
	comment=0x8380,"current line number" \
	comment=0x8382,"command mode without 'OK'" \
	comment=0x8384,"eof flag" \
	comment=0x8386,"close file & return to command mode" \
	comment=0x838a,"BASIC source pointer" \
	comment=0x838c,"get next character from BASIC source" \
	comment=0x838e,"command mode without 'OK'" \
	comment=0x8390,"enter BASIC line" \
	comment=0x8392,"?DS ERROR" \
	comment=0x8394,"DEVN" \
	comment=0x8396,"cause error" \
	comment=0x8398,"tokenize BASIC line" \
	comment=0x839b,"enter interpreter loop" \
	comment=0x839e,"used by error routine to print error code" \
	comment=0x83a0,"output character to DEVN" \
	comment=0x83a3,"enter a BASIC line" \
	comment=0x83a3,"read line number & store in \$2b" \
	comment=0x83ab,"tokenize BASIC line" \
	comment=0x83ae,"line length" \
	comment=0x83b0,"search program for line number in <\$2b" \
	comment=0x83b2,"line number doesn't exist" \
	comment=0x83b4,"address where line needs to go" \
	comment=0x83b6,"subtract next line pointer (-ve result)" \
	comment=0x83b8,"start of simple variables" \
	comment=0x83ba,"new end of program" \
	comment=0x83be,"move program down, erasing existing line" \
	comment=0x83c2,"start of simple variables" \
	comment=0x83c9,"new line is empty" \
	comment=0x83cb,"start of simple variables" \
	comment=0x83cf,"new line length" \
	comment=0x83d5,"move memory contents up" \
	comment=0x83dd,"copy new line into space just created" \
	comment=0x83e5,"new end of program" \
	comment=0x83e7,"clear variables and reset stack & cmd ptr" \
	comment=0x83e9,"set up next line pointers in BASIC program" \
	comment=0x83eb,"command mode without 'OK'" \
	comment=0x83ed,"set up next line pointers in BASIC program" \
	comment=0x83ed,"start of BASIC program" \
	comment=0x83f1,"RTS" \
	comment=0x83ff,"search program for line number in <\$2b" \
	comment=0x8401,"start of BASIC program" \
	comment=0x8403,"scan ahead for line in D & store address in \$47" \
	comment=0x8403,"(first line after if it doesn't exist - carry clear if found)" \
	comment=0x8405,"end of program" \
	comment=0x8407,"scan program until line no. is greater" \
	comment=0x840a,"than D" \
	comment=0x840c,"next line" \
	comment=0x8415,"NEW" \
	comment=0x8417,"start of BASIC program" \
	comment=0x841d,"start of simple variables" \
	comment=0x841f,"start of BASIC program" \
	comment=0x8421,"subtract 1 from X & store in \$a6" \
	comment=0x8424,"PATCH - reset BASIC memory" \
	comment=0x8427,"top of BASIC RAM" \
	comment=0x8429,"top of free string space" \
	comment=0x842b,"RESTORE" \
	comment=0x842e,"start of simple variables" \
	comment=0x8430,"start of array variables" \
	comment=0x8432,"end of BASIC storage" \
	comment=0x843b,"stack root / string storage start" \
	comment=0x8440,"CONT source address" \
	comment=0x8448,"FOR" \
	comment=0x8448,"creates following 18 byte stack entry:" \
	comment=0x8448,",S   #\$80" \
	comment=0x8448,"1,S   varptr of control variable" \
	comment=0x8448,"3,S   STEP value (unsigned FP)" \
	comment=0x8448,"8,S   sign of STEP value (-1, 0 ,1)" \
	comment=0x8448,"9,S   TO value (signed FP)" \
	comment=0x8448,"14,S   line number of FOR statement" \
	comment=0x8448,"16,S   address of statement after FOR" \
	comment=0x844a,"array illegal flag" \
	comment=0x844c,"LET" \
	comment=0x844f,"examine BASIC stack" \
	comment=0x8452,"lose return address" \
	comment=0x8454,"no FOR with same control variable already" \
	comment=0x8458,"overwrite duplicate FOR entry" \
	comment=0x845c,"memory check" \
	comment=0x845f,"find end of statement" \
	comment=0x8462,"current line number" \
	comment=0x8464,"push next statement ptr & current line no." \
	comment=0x8466,"token TO" \
	comment=0x8468,"skip character in B" \
	comment=0x846b,"validate numeric expression" \
	comment=0x846e,"read numeric expression into FPA1" \
	comment=0x8473,"convert FPA1 back to standard variable" \
	comment=0x847d,"push FPA1 onto stack & JMP ,Y" \
	comment=0x8480,"FP constant 1" \
	comment=0x8483,"load variable into FPA1 (X is varptr)" \
	comment=0x8486,"get current character from BASIC source" \
	comment=0x8488,"token STEP" \
	comment=0x848a,"no STEP value specified" \
	comment=0x848c,"get next character from BASIC source" \
	comment=0x848e,"read numeric expression into FPA1" \
	comment=0x8491,"sets B to -1, 0 or 1 as per sign of FPA1" \
	comment=0x8494,"push B then FPA1 onto stack" \
	comment=0x8497,"varptr of control variable" \
	comment=0x849b,"FOR signature on stack" \
	comment=0x849f,"interpreter loop" \
	comment=0x849f,"PATCH - get command" \
	comment=0x84a2,"unmask interrupts" \
	comment=0x84a4,"scan for BREAK / pause" \
	comment=0x84a6,"BASIC source pointer" \
	comment=0x84a8,"address of current BASIC statement" \
	comment=0x84ac,"end of line" \
	comment=0x84b2,"?SN ERROR" \
	comment=0x84b7,"this will be zero when end reached" \
	comment=0x84b9,"end of program" \
	comment=0x84bf,"current line number" \
	comment=0x84c1,"BASIC source pointer" \
	comment=0x84c3,"trace flag" \
	comment=0x84c5,"trace off" \
	comment=0x84c9,"output character to DEVN" \
	comment=0x84cc,"current line number" \
	comment=0x84ce,"print unsigned number in D" \
	comment=0x84d3,"output character to DEVN" \
	comment=0x84d6,"get next character from BASIC source" \
	comment=0x84d8,"interpret statement" \
	comment=0x84da,"interpreter loop" \
	comment=0x84dc,"interpret statement" \
	comment=0x84dc,"RTS" \
	comment=0x84de,"PATCH - interpreter" \
	comment=0x84e2,"variable on LHS (LET)" \
	comment=0x84e8,"not a BASIC command" \
	comment=0x84ea,"command JMP table" \
	comment=0x84f1,"get next character from BASIC source" \
	comment=0x84f7,"function" \
	comment=0x84fb,"?SN ERROR" \
	comment=0x84fd,"must be disk command" \
	comment=0x8501,"get next character from BASIC source" \
	comment=0x8505,"MID\$ on LHS" \
	comment=0x850b,"TIMER on LHS" \
	comment=0x850f,"PATCH - CLS GET PUT ???" \
	comment=0x8512,"?SN ERROR" \
	comment=0x8514,"RESTORE" \
	comment=0x8514,"start of BASIC program" \
	comment=0x8518,"READ pointer" \
	comment=0x851b,"scan keyboard for break & pause" \
	comment=0x851b,"scan keyboard" \
	comment=0x8522,"BREAK" \
	comment=0x8526,"SHIFT + @" \
	comment=0x852b,"scan keyboard" \
	comment=0x8532,"END" \
	comment=0x8532,"close cassette stream" \
	comment=0x8535,"get current character from BASIC source" \
	comment=0x8539,"STOP" \
	comment=0x853b,"RTS" \
	comment=0x853d,"BASIC source pointer" \
	comment=0x853f,"address of current BASIC statement" \
	comment=0x8541,"make -ve for STOP" \
	comment=0x8543,"lose return address" \
	comment=0x8545,"current line number" \
	comment=0x854a,"already in command mode" \
	comment=0x854c,"CONT line number" \
	comment=0x854e,"address of current BASIC statement" \
	comment=0x8550,"CONT source address" \
	comment=0x8552,"DEVN" \
	comment=0x8554,"/BREAK/" \
	comment=0x8559,"command mode" \
	comment=0x855d,"print BREAK message" \
	comment=0x8560,"CONT" \
	comment=0x8560,"RTS" \
	comment=0x8562,"?CN ERROR" \
	comment=0x8564,"CONT source address" \
	comment=0x8566,"cause error" \
	comment=0x856a,"BASIC source pointer" \
	comment=0x856c,"CONT line number" \
	comment=0x856e,"current line number" \
	comment=0x8571,"CLEAR" \
	comment=0x8571,"clear variables & reset stack" \
	comment=0x8573,"read unsigned number into \$52 & D" \
	comment=0x8578,"top of BASIC RAM" \
	comment=0x857a,"get current character from BASIC source" \
	comment=0x857e,"skip comma" \
	comment=0x8581,"read 16 bit number into X" \
	comment=0x8586,"top of RAM" \
	comment=0x8588,"?OM ERROR" \
	comment=0x858e,"?OM ERROR" \
	comment=0x8595,"?OM ERROR" \
	comment=0x8597,"start of simple variables" \
	comment=0x8599,"?OM ERROR" \
	comment=0x859b,"new stack address" \
	comment=0x859d,"new top of BASIC RAM" \
	comment=0x859f,"clear variables & reset stack" \
	comment=0x85a2,"?OM ERROR" \
	comment=0x85a5,"RUN" \
	comment=0x85a5,"PATCH - run" \
	comment=0x85a8,"set up sound & graphics variables" \
	comment=0x85ab,"close cassette stream" \
	comment=0x85ae,"get current character from BASIC source" \
	comment=0x85b0,"clear variables and reset stack & cmd ptr" \
	comment=0x85b4,"clear variables & reset stack" \
	comment=0x85b7,"perform GOTO" \
	comment=0x85b9,"GO  (TO/SUB)" \
	comment=0x85b9,"GOSUB creates following 5 byte stack entry:" \
	comment=0x85b9,",S     #\$BD" \
	comment=0x85b9,"1,S     line number of GOSUB statement" \
	comment=0x85b9,"3,S     address of GOSUB statement (points to SUB token)" \
	comment=0x85bb,"get next character from BASIC source" \
	comment=0x85bd,"token TO" \
	comment=0x85bf,"perform GOTO" \
	comment=0x85c1,"token SUB" \
	comment=0x85c3,"?SN ERROR" \
	comment=0x85c7,"memory check" \
	comment=0x85ca,"BASIC source pointer" \
	comment=0x85cc,"current line number" \
	comment=0x85ce,"token SUB" \
	comment=0x85d2,"perform GOTO" \
	comment=0x85d4,"interpreter loop" \
	comment=0x85d7,"perform GOTO" \
	comment=0x85d7,"get current character from BASIC source" \
	comment=0x85d9,"read line number & store in \$2b" \
	comment=0x85dc,"find end of line" \
	comment=0x85e2,"current line number" \
	comment=0x85e7,"start of BASIC program" \
	comment=0x85e9,"scan for line D" \
	comment=0x85ec,"?UL ERROR" \
	comment=0x85f0,"BASIC source pointer" \
	comment=0x85f3,"RETURN" \
	comment=0x85f3,"RTS" \
	comment=0x85f7,"set \$3b to skip all FOR entries" \
	comment=0x85f9,"examine BASIC stack" \
	comment=0x85fc,"point stack to this entry" \
	comment=0x8600,"GOSUB signature (#\$BD - #\$80)" \
	comment=0x8602,"?RG ERROR" \
	comment=0x8607,"(8605 C60E       LDB   #\$0E)    ;?UL ERROR" \
	comment=0x8607,"cause error" \
	comment=0x860a,"?SN ERROR" \
	comment=0x860f,"current line number" \
	comment=0x8611,"BASIC source pointer" \
	comment=0x8613,"DATA" \
	comment=0x8613,"(simply skips to next statement)" \
	comment=0x8613,"find end of statement" \
	comment=0x8618,"REM / ELSE" \
	comment=0x8618,"(8616 8D06       BSR   \$861E)   ;find end of line" \
	comment=0x8618,"BASIC source pointer" \
	comment=0x861b,"find end of statement" \
	comment=0x861f,"(861E 5F         CLRB)" \
	comment=0x8622,"BASIC source pointer" \
	comment=0x862c,"RTS" \
	comment=0x8632,"RTS" \
	comment=0x863f,"token IF (+1)" \
	comment=0x8643,"increment for each IF token encountered" \
	comment=0x8647,"IF" \
	comment=0x8647,"IF condition (THEN/GOTO) [IF...THEN [IF...THEN...ELSE] ELSE] ELSE" \
	comment=0x8647,"--                                                           ----" \
	comment=0x8647,"ELSEs are tied to previous IFs" \
	comment=0x8647,"read numeric expression into FPA1" \
	comment=0x864a,"get current character from BASIC source" \
	comment=0x864c,"token GO" \
	comment=0x8650,"token THEN" \
	comment=0x8652,"skip character in B" \
	comment=0x8657,"IF condition true" \
	comment=0x8659,"clear IF counter" \
	comment=0x865b,"skip to start of next statement" \
	comment=0x865e,"RTS" \
	comment=0x8660,"get next character from BASIC source" \
	comment=0x8662,"token ELSE" \
	comment=0x8664,"we're looking for ELSE" \
	comment=0x8666,"any IFs skipped?" \
	comment=0x8668,"this ELSE doesn't go with this IF" \
	comment=0x866a,"get next character from BASIC source" \
	comment=0x866c,"get current character from BASIC source" \
	comment=0x866e,"it's a number - perform GOTO" \
	comment=0x8672,"interpret statement" \
	comment=0x8675,"ON" \
	comment=0x8675,"get number into B" \
	comment=0x8678,"token GO" \
	comment=0x867a,"skip character in B" \
	comment=0x867f,"token SUB" \
	comment=0x8683,"token TO" \
	comment=0x8685,"?SN ERROR" \
	comment=0x8687,"control variable" \
	comment=0x868d,"GO (cmd pointer now at desired choice)" \
	comment=0x8690,"get next character from BASIC source" \
	comment=0x8692,"read line number & store in \$2b" \
	comment=0x869a,"read line number from command & store in \$2b" \
	comment=0x869a,"zero" \
	comment=0x869e,"not a digit - RTS" \
	comment=0x86a6,"D > 6399?" \
	comment=0x86a8,"?SN ERROR" \
	comment=0x86ac,"D = D * 10" \
	comment=0x86b2,"add new digit" \
	comment=0x86b8,"get next character from BASIC source" \
	comment=0x86ba,"process another digit" \
	comment=0x86bc,"LET" \
	comment=0x86bc,"get varptr of variable in X" \
	comment=0x86c1,"token =" \
	comment=0x86c3,"skip character in B" \
	comment=0x86c6,"numeric / string flag" \
	comment=0x86ca,"get expression" \
	comment=0x86cf,"check that variable & expression" \
	comment=0x86d0,"are of same type" \
	comment=0x86d3,"assign FPA1 to varptr in <\$3b" \
	comment=0x86d7,"PATCH - assign string variable" \
	comment=0x86dc,"stack root / string storage start" \
	comment=0x86e3,"start of simple variables" \
	comment=0x86e9,"reserve B bytes of string space" \
	comment=0x86ee,"copy string (len B) from varptr X to (\$25)+" \
	comment=0x86f6,"if X is top of string stack then pull it" \
	comment=0x8705,"string used by INPUT" \
	comment=0x8705,"/?REDO/CR" \
	comment=0x870c,"take action for illegal input" \
	comment=0x870c,"?FD ERROR" \
	comment=0x870e,"DEVN" \
	comment=0x8712,"cause error" \
	comment=0x8719,"line number of current DATA statement" \
	comment=0x871b,"current line number" \
	comment=0x871d,"?SN ERROR" \
	comment=0x8720,"/?REDO/" \
	comment=0x8723,"print string to DEVN" \
	comment=0x8726,"address of current BASIC statement" \
	comment=0x8728,"BASIC source pointer" \
	comment=0x872b,"INPUT" \
	comment=0x872b,"test for command mode" \
	comment=0x8730,"DEVN" \
	comment=0x8737,"read #-n & set up DEVN" \
	comment=0x873a,"test cassette status OK for input" \
	comment=0x873d,"skip comma" \
	comment=0x8742,"no prompt" \
	comment=0x8744,"read literal string" \
	comment=0x8749,"skip character in B" \
	comment=0x874c,"print prompt" \
	comment=0x8754,"DEVN" \
	comment=0x8758,"get something into input buffer" \
	comment=0x875e,"read input into variables" \
	comment=0x8760,"print '?' to DEVN" \
	comment=0x8763,"print a space to DEVN" \
	comment=0x8766,"line input from DEVN" \
	comment=0x876d,"BREAK" \
	comment=0x8770,"?IE ERROR" \
	comment=0x8772,"eof flag" \
	comment=0x8777,"READ" \
	comment=0x8777,"READ pointer" \
	comment=0x877f,"get varptr of variable in X" \
	comment=0x8784,"BASIC source pointer" \
	comment=0x8792,"PATCH - re-request input" \
	comment=0x8795,"print '?' to DEVN" \
	comment=0x879a,"BASIC source pointer" \
	comment=0x879c,"get next character from BASIC source" \
	comment=0x879e,"numeric / string flag" \
	comment=0x87a2,"BASIC source pointer" \
	comment=0x87af,"initialise virtual DEVN device" \
	comment=0x87b2,"cassette IO flag" \
	comment=0x87b4,"IO in progress" \
	comment=0x87be,"compile literal string at X" \
	comment=0x87c4,"assign string variable" \
	comment=0x87c9,"read numeric constant into FPA1" \
	comment=0x87cc,"assign FPA1 to varptr in <\$3b" \
	comment=0x87cf,"get current character from BASIC source" \
	comment=0x87d5,"take action for illegal input" \
	comment=0x87d9,"BASIC source pointer" \
	comment=0x87df,"BASIC source pointer" \
	comment=0x87e1,"get current character from BASIC source" \
	comment=0x87e5,"skip comma" \
	comment=0x87ea,"BASIC source pointer" \
	comment=0x87ec,"find end of statement" \
	comment=0x87fc,"line number of current DATA statement" \
	comment=0x8815,"print string to DEVN" \
	comment=0x8819,"string used by INPUT" \
	comment=0x8819,"/?EXTRA IGNORED/CR" \
	comment=0x8829,"NEXT" \
	comment=0x8829,"control variable specified" \
	comment=0x882b,"zero" \
	comment=0x882f,"get varptr of variable in X" \
	comment=0x8834,"examine BASIC stack" \
	comment=0x8837,"found match" \
	comment=0x8839,"?NF ERROR" \
	comment=0x883d,"point stack to this entry" \
	comment=0x883f,"point X to STEP value" \
	comment=0x8841,"load variable into FPA1 (X is varptr)" \
	comment=0x8844,"sign of STEP value" \
	comment=0x8848,"varptr of control variable" \
	comment=0x884a,"add varptr X to FPA1" \
	comment=0x884d,"assign FPA1 to varptr in <\$3b" \
	comment=0x8850,"point X to terminating value" \
	comment=0x8852,"compare FPA1 - varptr X" \
	comment=0x8855,"test depends on step direction" \
	comment=0x8857,"terminating condition met" \
	comment=0x885b,"current line number" \
	comment=0x8860,"BASIC source pointer" \
	comment=0x8862,"interpreter loop" \
	comment=0x8865,"finished with this entry" \
	comment=0x8868,"get current character from BASIC source" \
	comment=0x886c,"no more variables after NEXT" \
	comment=0x886e,"get next character from BASIC source" \
	comment=0x8870,"BSR used for correct stack structure" \
	comment=0x8872,";(never returns to \$8872)" \
	comment=0x8872,"get numeric expression into FPA1" \
	comment=0x8872,"get expression" \
	comment=0x8874,"cause error if expression last evaluated not numeric" \
	comment=0x8879,"cause error if expression last evaluated not string" \
	comment=0x8879,"(8877 1A01       ORCC  #\$01)" \
	comment=0x8879,"numeric / string flag" \
	comment=0x887d,"RTS" \
	comment=0x8882,"(8880 2B96       BMI   \$8818)   ;RTS" \
	comment=0x8882,"?TM ERROR" \
	comment=0x8884,"cause error" \
	comment=0x8887,"get expression" \
	comment=0x8887,"move source pointer back one" \
	comment=0x888d,"(888B 3404       PSHS  B)" \
	comment=0x8891,"memory check" \
	comment=0x8894,"evaluate sub-expression" \
	comment=0x8897,"flag used for relational operators" \
	comment=0x8899,"get current character from BASIC source" \
	comment=0x889b,"branch to \$88B2 if token is not in the set" \
	comment=0x889d,"[ >, =, < ]" \
	comment=0x88a3,"map [0, 1, 2] to [1, 2, 4]" \
	comment=0x88a6,"determine valid combination of > = <" \
	comment=0x88aa,"?SN ERROR" \
	comment=0x88ae,"get next character from BASIC source" \
	comment=0x88b2,"" \
	comment=0x88b2,"\$3f = [ 1, 2, 3, 4, 5, 6 ]" \
	comment=0x88b4,"for   [ >  =  >= <  <> <= ]" \
	comment=0x88bc,"not a binary operator" \
	comment=0x88be,"A = A + 1 + (\$06)" \
	comment=0x88c0,"'+' in a string expression" \
	comment=0x88c4,"A = A - 1 if numeric expression" \
	comment=0x88c9,"A = A * 3" \
	comment=0x88cb,"binary operator precedence table" \
	comment=0x88d0,"precedence of last operator" \
	comment=0x88d4,"new op. has a lower precedence" \
	comment=0x88d6,"validate numeric expression" \
	comment=0x88da,"push op handler & FPA1 / get expression" \
	comment=0x88e3,"LDB <\$4F  RTS" \
	comment=0x88e9,"set up precedence / handler for rel. op." \
	comment=0x88e9,"numeric / string flag" \
	comment=0x88ec,"move source pointer back one" \
	comment=0x88f3,"numeric / string flag" \
	comment=0x88f7,"move source pointer back one" \
	comment=0x88f7,"BASIC source pointer" \
	comment=0x88f9,"subtract 1 from X & store in \$a6" \
	comment=0x88fc,"rel. op. precedence & handler" \
	comment=0x8905,"push op handler & FPA1 onto stack / get expression" \
	comment=0x8905,"op handler" \
	comment=0x8909,"push FPA1 onto stack" \
	comment=0x890b,"rel. op. flag" \
	comment=0x890d,"get expression" \
	comment=0x8910,"?SN ERROR" \
	comment=0x8913,"push FPA1 onto stack" \
	comment=0x8925,"end of expression / execute operator" \
	comment=0x8925,"zero" \
	comment=0x8929,"LDB <\$4F  RTS" \
	comment=0x892f,"validate numeric expression" \
	comment=0x8938,"RTS" \
	comment=0x893c,"RTS" \
	comment=0x893e,"sets carry if rel. op. was for string" \
	comment=0x8941,"pull FPA2 off stack" \
	comment=0x8943,"set \$62 up with sign difference" \
	comment=0x8947,"LDB <\$4F" \
	comment=0x894b,"RTS calls operator handler" \
	comment=0x894d,"(with carry from above)" \
	comment=0x8954,"evaluate sub-expression ('+' & '-' treated as signs)" \
	comment=0x8954,"PATCH - evaluate expression" \
	comment=0x8957,"numeric / string flag" \
	comment=0x8959,"get next character from BASIC source" \
	comment=0x895d,"read numeric constant into FPA1" \
	comment=0x8960,"carry clear if A-Z" \
	comment=0x8963,"evaluate variable" \
	comment=0x8969,"token -" \
	comment=0x896b,"read expression & negate" \
	comment=0x896d,"token +" \
	comment=0x896f,"ignore +" \
	comment=0x8975,"BASIC source pointer" \
	comment=0x8977,"compile literal string at X" \
	comment=0x897c,"move source pointer to end of string" \
	comment=0x897f,"token NOT" \
	comment=0x8988,"read signed number from FPA1 to \$52 & D" \
	comment=0x898d,"assign D to FPA1" \
	comment=0x8990,"token FN" \
	comment=0x8998,"read octal or hex number into \$52 / \$53" \
	comment=0x899d,"evaluate function" \
	comment=0x899f,"skip open bracket (only legal chr. left)" \
	comment=0x89a1,"get expression" \
	comment=0x89a4,"check for close bracket" \
	comment=0x89a9,"check for open bracket" \
	comment=0x89a9,"(89A7 C628       LDB   #\$28)" \
	comment=0x89ac,"check for comma" \
	comment=0x89ac,"(89AA C62C       LDB   #\$2C)" \
	comment=0x89ac,"check for character in B" \
	comment=0x89b0,"?SN ERROR" \
	comment=0x89b2,"get next character from BASIC source" \
	comment=0x89b4,"?SN ERROR" \
	comment=0x89b6,"cause error" \
	comment=0x89b9,"read expression & negate FPA1" \
	comment=0x89be,"COM \$54 if FPA1 non zero" \
	comment=0x89c1,"evaluate variable" \
	comment=0x89c1,"get varptr of variable in X" \
	comment=0x89c6,"numeric / string flag" \
	comment=0x89c8,"RTS (string)" \
	comment=0x89ca,"load variable into FPA1 (X is varptr)" \
	comment=0x89cd,"evaluate function" \
	comment=0x89cd,"get next character from BASIC source" \
	comment=0x89d2,"get next character from BASIC source" \
	comment=0x89d8,"disk function despatch" \
	comment=0x89e0,"functions with single arguments" \
	comment=0x89e4,"functions with special or no arguments" \
	comment=0x89e6,"skip open bracket" \
	comment=0x89ec,"not LEFT\$, RIGHT\$ or MID\$" \
	comment=0x89ee,"get expression" \
	comment=0x89f1,"skip comma" \
	comment=0x89f3,"validate string" \
	comment=0x89fc,"get number into B" \
	comment=0x8a06,"(8A04 8D99       BSR   \$899F)   ;get expression inside brackets" \
	comment=0x8a08,"function despatch table" \
	comment=0x8a0e,"validate numeric expression" \
	comment=0x8a11,"OR" \
	comment=0x8a13,"AND" \
	comment=0x8a13,"(8A12 4F         CLRA)" \
	comment=0x8a15,"read signed number from FPA1 to \$52 & D" \
	comment=0x8a1a,"copy FPA2 to FPA1" \
	comment=0x8a1d,"read signed number from FPA1 to \$52 & D" \
	comment=0x8a2e,"assign D to FPA1" \
	comment=0x8a31,"handler for relational operators" \
	comment=0x8a31,"validate string / numeric using carry" \
	comment=0x8a34,"valid string" \
	comment=0x8a3e,"FPA2" \
	comment=0x8a41,"compare FPA1 - varptr X" \
	comment=0x8a46,"numeric / string flag" \
	comment=0x8a4a,"point X to string just compiled & len in B" \
	comment=0x8a53,"point X to string & length in B" \
	comment=0x8a7c,"map [-1, 0, 1] to [1, 2, 4]" \
	comment=0x8a7f,"rel. op. number" \
	comment=0x8a85,"assign B to FPA1 (result of relation)" \
	comment=0x8a88,"skip comma" \
	comment=0x8a8b,"DIM" \
	comment=0x8a8d,"create variable" \
	comment=0x8a8f,"get current character from BASIC source" \
	comment=0x8a91,"skip comma & read next array" \
	comment=0x8a94,"gets VARPTR address of following variable" \
	comment=0x8a94,"set \$08 to #\$80 to exclude array variables" \
	comment=0x8a94,"creates new variable if not found" \
	comment=0x8a94,"returns \$39 = X = varptr address" \
	comment=0x8a95,"get current character from BASIC source" \
	comment=0x8a97,"set B to cause error if array variable already exists" \
	comment=0x8a9b,"get current character from BASIC source" \
	comment=0x8a9d,"carry clear if A-Z" \
	comment=0x8a9f,"?SN ERROR" \
	comment=0x8aa4,"numeric / string flag" \
	comment=0x8aa6,"get next character from BASIC source" \
	comment=0x8aaa,"carry clear if A-Z" \
	comment=0x8ab0,"get next character from BASIC source" \
	comment=0x8ab4,"carry clear if A-Z" \
	comment=0x8aba,"numeric variable" \
	comment=0x8abc,"numeric / string flag" \
	comment=0x8ac0,"get next character from BASIC source" \
	comment=0x8ac4,"set \$08 to #\$80 to exclude array variables" \
	comment=0x8ac8,"array variable" \
	comment=0x8ace,"start of simple variables" \
	comment=0x8ad2,"start of array variables" \
	comment=0x8ad4,"not found - create variable" \
	comment=0x8ad9,"found existing variable - STX <\$39 & RTS" \
	comment=0x8add,"keep looking" \
	comment=0x8adf,"clear carry if A contains 'A'-'Z'" \
	comment=0x8ae8,"create variable" \
	comment=0x8aed,"if called by evaluate variable routine - RTS" \
	comment=0x8af1,"(with X pointing to zero)" \
	comment=0x8af3,"end of BASIC storage" \
	comment=0x8afc,"start of array variables" \
	comment=0x8b00,"move memory contents up" \
	comment=0x8b05,"end of BASIC storage" \
	comment=0x8b09,"start of array variables" \
	comment=0x8b0d,"variable name" \
	comment=0x8b1c,"FP constant -32768" \
	comment=0x8b21,"read unsigned number into \$52 & D" \
	comment=0x8b21,"get next character from BASIC source" \
	comment=0x8b23,"read numeric expression into FPA1" \
	comment=0x8b26,"validate numeric expression" \
	comment=0x8b29,"read +ve number from FPA1 into \$52 & D" \
	comment=0x8b2b,"?FC ERROR" \
	comment=0x8b2d,"read signed number from FPA1 into \$52 & D" \
	comment=0x8b2d,"validate numeric expression" \
	comment=0x8b36,"only 16 bit number allowed is -32768" \
	comment=0x8b39,"compare FPA1 - varptr X" \
	comment=0x8b3c,"?FC ERROR" \
	comment=0x8b3e,"denormalize FPA1 to an integer" \
	comment=0x8b44,"get varptr of variable continued (handle arrays)" \
	comment=0x8b46,"numeric / string flag" \
	comment=0x8b4f,"read unsigned number into \$52 & D" \
	comment=0x8b5a,"get current character from BASIC source" \
	comment=0x8b5e,"get next dimension" \
	comment=0x8b60,"number of dimensions" \
	comment=0x8b62,"skip close bracket" \
	comment=0x8b67,"numeric / string flag" \
	comment=0x8b6b,"start of array variables" \
	comment=0x8b6d,"end of BASIC storage" \
	comment=0x8b6f,"not found - create new array" \
	comment=0x8b76,"found array name" \
	comment=0x8b7c,"keep looking" \
	comment=0x8b7e,"?DD ERROR" \
	comment=0x8b82,"cause error if array exists & \$05 set" \
	comment=0x8b88,"correct number of dimensions" \
	comment=0x8b8a,"?BS ERROR" \
	comment=0x8b8f,"(8B8D C608       LDB   #\$08)    ;?FC ERROR" \
	comment=0x8b8f,"cause error" \
	comment=0x8b92,"bytes per element" \
	comment=0x8b99,"array name" \
	comment=0x8b9d,"number of dimensions" \
	comment=0x8b9f,"memory check" \
	comment=0x8ba2,"start of array header" \
	comment=0x8ba4,"default number of elements" \
	comment=0x8bb2,"D = word at 5,X * word at \$64" \
	comment=0x8bba,"next dimension" \
	comment=0x8bbc,"start of array element storage" \
	comment=0x8bbe,"D = end of array" \
	comment=0x8bc0,"?OM ERROR" \
	comment=0x8bc6,"memory check (also adds #\$3a to D)" \
	comment=0x8bcc,"end of BASIC storage" \
	comment=0x8bcf,"clear array" \
	comment=0x8bd7,"array header" \
	comment=0x8bd9,"end of BASIC storage" \
	comment=0x8bdd,"offset to next array (when it's created)" \
	comment=0x8be1,"RTS" \
	comment=0x8bf2,"?BS ERROR" \
	comment=0x8bf8,"D = word at 5,X * word at \$64" \
	comment=0x8c08,"D = D * 5" \
	comment=0x8c11,"D = word at 5,X * word at \$64" \
	comment=0x8c1d,"?BS ERROR" \
	comment=0x8c27,"?BS ERROR" \
	comment=0x8c2e,"?BS ERROR" \
	comment=0x8c31,"MEM" \
	comment=0x8c33,"...continued" \
	comment=0x8c36,"assign B to FPA1" \
	comment=0x8c37,"assign D to FPA1 (signed)" \
	comment=0x8c37,"numeric / string flag" \
	comment=0x8c3d,"signed assign!" \
	comment=0x8c40,"STR\$" \
	comment=0x8c40,"validate numeric expression" \
	comment=0x8c46,"convert FPA1 to string at U" \
	comment=0x8c49,"lose return address" \
	comment=0x8c4e,"compile literal string at X" \
	comment=0x8c50,"reserve B bytes of string space" \
	comment=0x8c50,"returns X = \$58 = start of requested block" \
	comment=0x8c50,"B = \$56 = length of block" \
	comment=0x8c52,"reserve B bytes of string space" \
	comment=0x8c59,"register a delimited string pointed to by X" \
	comment=0x8c59,"if string is in keyboard buffer, then copy it into free string space." \
	comment=0x8c59,"stores string start, end & length in \$62, \$64 & \$56" \
	comment=0x8c59,"string start also in \$58" \
	comment=0x8c59,"if copied to string space, start & end also in \$58 & \$4d" \
	comment=0x8c80,"PATCH - reset BASIC memory" \
	comment=0x8c89,"push temp string onto varptr stack" \
	comment=0x8c8b,"reserve B bytes of string space" \
	comment=0x8c8f,"copy string of length B from X+ to (\$25)+" \
	comment=0x8c99,"?ST ERROR" \
	comment=0x8c9b,"cause error" \
	comment=0x8ca8,"numeric / string flag" \
	comment=0x8cb3,"reserve B bytes of string space" \
	comment=0x8cb3,"returns X = pointer to requested block & B = length" \
	comment=0x8cb3,"requested block also in \$25" \
	comment=0x8cb8,"top of free string space" \
	comment=0x8cbc,"stack root / string storage start" \
	comment=0x8cbf,"not enough space" \
	comment=0x8cc1,"new free pointer" \
	comment=0x8cc7,"points to requested block" \
	comment=0x8ccb,"?OS ERROR" \
	comment=0x8ccf,"already done garbage collect - give up" \
	comment=0x8cd1,"string garbage collect" \
	comment=0x8cd5,"try to reserve space again" \
	comment=0x8cd7,"string space garbage collect" \
	comment=0x8cd7,"top of BASIC RAM" \
	comment=0x8cd9,"top of free string space" \
	comment=0x8cdf,"stack root / string storage start" \
	comment=0x8cee,"start of simple variables" \
	comment=0x8cf0,"start of array variables" \
	comment=0x8cfc,"end of BASIC storage" \
	comment=0x8d24,"top of free string space" \
	comment=0x8d41,"top of free string space" \
	comment=0x8d45,"move memory contents up (no memory check)" \
	comment=0x8d55,"handle '+' in a string expression (concatenate)" \
	comment=0x8d59,"evaluate sub-expression" \
	comment=0x8d5c,"validate string expression" \
	comment=0x8d67,"add string lengths" \
	comment=0x8d69,"not too long" \
	comment=0x8d6b,"?LS ERROR" \
	comment=0x8d6d,"cause error" \
	comment=0x8d70,"reserve B bytes of string space" \
	comment=0x8d77,"copy string (len B) from varptr X to (\$25)+" \
	comment=0x8d7b,"point X to string & length in B" \
	comment=0x8d7d,"copy string of length B from X+ to (\$25)+" \
	comment=0x8d81,"point X to string & length in B" \
	comment=0x8d83,"push temp string onto varptr stack" \
	comment=0x8d86,"back to expression handler" \
	comment=0x8d89,"copy string of length B from varptr X to (\$25)+" \
	comment=0x8d8b,"copy string of length B from X+ to (\$25)+" \
	comment=0x8d9a,"validate result of string expression" \
	comment=0x8d9a,"point X to 1st character & length in B" \
	comment=0x8d9a,"(if it is the most recent temp string then delete it)" \
	comment=0x8d9a,"validate string expression" \
	comment=0x8da1,"if X is top of string stack then pull it" \
	comment=0x8da3,"normal varptr" \
	comment=0x8da9,"top of free string space" \
	comment=0x8daf,"top of free string space" \
	comment=0x8db1,"top of free string space" \
	comment=0x8dbb,"if X is top of string stack then pull it" \
	comment=0x8dc7,"LEN" \
	comment=0x8dc7,"validate string & test length" \
	comment=0x8dc9,"assign B to FPA1" \
	comment=0x8dcc,"validate string & test length" \
	comment=0x8dcc,"validate string & point X to it" \
	comment=0x8dce,"numeric / string flag" \
	comment=0x8dd2,"CHR\$" \
	comment=0x8dd2,"read 8 bit value into B from FPA1" \
	comment=0x8dd7,"reserve B bytes of string space" \
	comment=0x8ddc,"store string details as for temp string" \
	comment=0x8de3,"push temp string onto varptr stack" \
	comment=0x8de6,"ASC" \
	comment=0x8de6,"get 1st character of string into B" \
	comment=0x8de8,"assign B to FPA1" \
	comment=0x8dea,"get 1st character of string into B" \
	comment=0x8dea,"validate string & test length" \
	comment=0x8dec,"?FC ERROR" \
	comment=0x8df1,"LEFT\$" \
	comment=0x8df1,"get str varptr in X & \$4D, arg. in A & B" \
	comment=0x8df6,"number of chrs <= string length" \
	comment=0x8dfd,"reserve B bytes of string space" \
	comment=0x8e02,"point X to string & length in B" \
	comment=0x8e06,"adjust string start for MID\$ / RIGHT\$" \
	comment=0x8e09,"copy string of length B from X+ to (\$25)+" \
	comment=0x8e0c,"push temp string onto varptr stack" \
	comment=0x8e0e,"RIGHT\$" \
	comment=0x8e0e,"get str varptr in X & \$4D, arg. in A & B" \
	comment=0x8e12,"A = string length - argument" \
	comment=0x8e13,"create new string" \
	comment=0x8e15,"MID\$" \
	comment=0x8e15,"default length" \
	comment=0x8e19,"get current character from BASIC source" \
	comment=0x8e1d,"length not specified" \
	comment=0x8e1f,"skip comma" \
	comment=0x8e22,"get number into B (& \$53)" \
	comment=0x8e24,"get str varptr in X & \$4D, arg. in A & B" \
	comment=0x8e26,"?FC ERROR" \
	comment=0x8e29,"A = pos - 1" \
	comment=0x8e2c,"pos past end - create empty string" \
	comment=0x8e32,"B = string length - pos" \
	comment=0x8e35,"no. of chrs available <= requested length" \
	comment=0x8e39,"use requested length" \
	comment=0x8e3b,"called by LEFT\$, RIGHT\$ & MID\$" \
	comment=0x8e3b,"get string varptr in X & \$4D, argument in A & B" \
	comment=0x8e3b,"skip close bracket" \
	comment=0x8e4c,"?FC ERROR" \
	comment=0x8e4f,"skip character & get 8 bit value into B" \
	comment=0x8e4f,"get next character from BASIC source" \
	comment=0x8e51,"read 8 bit value into B" \
	comment=0x8e51,"read numeric expression into FPA1" \
	comment=0x8e54,"read 8 bit value into B from FPA1" \
	comment=0x8e54,"read unsigned number into \$52 & D from FPA1" \
	comment=0x8e58,"?FC ERROR" \
	comment=0x8e5a,"get current character from BASIC source" \
	comment=0x8e5c,"VAL" \
	comment=0x8e5c,"validate string & test length" \
	comment=0x8e5f,"clear exponents in FPA1 (\$4f & \$54)" \
	comment=0x8e63,"save source pointer" \
	comment=0x8e65,"point source pointer to start of string" \
	comment=0x8e68,"save byte at end of string" \
	comment=0x8e6c,"put a zero at end of string" \
	comment=0x8e6e,"get current character from BASIC source" \
	comment=0x8e70,"read numeric expression into FPA1" \
	comment=0x8e75,"restore byte at end of string" \
	comment=0x8e77,"restore source pointer" \
	comment=0x8e7a,"read pair of numbers from command" \
	comment=0x8e7a,"1st in \$2b / \$2c & 2nd in B" \
	comment=0x8e7a,"read 16 bit number into X" \
	comment=0x8e7e,"skip comma" \
	comment=0x8e81,"get number into B" \
	comment=0x8e83,"read 16 bit unsigned number into X" \
	comment=0x8e83,"read numeric expression into FPA1" \
	comment=0x8e86,"read 16 bit unsigned number into X from FPA1" \
	comment=0x8e88,"?FC ERROR" \
	comment=0x8e8e,"?FC ERROR" \
	comment=0x8e90,"denormalize FPA1 to an integer" \
	comment=0x8e96,"PEEK" \
	comment=0x8e96,"read 16 bit number into X from FPA1" \
	comment=0x8e9a,"assign B to FPA1" \
	comment=0x8e9d,"POKE" \
	comment=0x8e9d,"read pair of numbers into \$2b/2c & B" \
	comment=0x8ea4,"LLIST" \
	comment=0x8ea6,"DEVN" \
	comment=0x8ea8,"get current character from BASIC source" \
	comment=0x8eaa,"LIST" \
	comment=0x8eac,"read line number & store in \$2b" \
	comment=0x8eaf,"search program for line number in <\$2b" \
	comment=0x8eb8,"get current character from BASIC source" \
	comment=0x8ebc,"token -" \
	comment=0x8ec0,"get next character from BASIC source" \
	comment=0x8ec4,"read line number & store in \$2b" \
	comment=0x8ed3,"initialise virtual DEVN device & new line" \
	comment=0x8ed6,"scan for BREAK & pause if DEVN is not -1" \
	comment=0x8edd,"close DEVN stream" \
	comment=0x8ee0,"DEVN" \
	comment=0x8ee2,"command mode" \
	comment=0x8eee,"print unsigned number in D" \
	comment=0x8ef1,"print a space to DEVN" \
	comment=0x8ef6,"detokenize BASIC line" \
	comment=0x8f03,"output character to DEVN" \
	comment=0x8f08,"detokenize BASIC line" \
	comment=0x8f08,"PATCH - detokenize" \
	comment=0x8f67,"tokenize BASIC line" \
	comment=0x8f67,"PATCH - tokenize" \
	comment=0x8f6a,"BASIC source pointer" \
	comment=0x8f7b,"carry clear if A-Z" \
	comment=0x8fae,"BASIC source pointer" \
	comment=0x9027,"carry clear if A-Z" \
	comment=0x903d,"PRINT" \
	comment=0x903d,"send CR to DEVN" \
	comment=0x9041,"DEVN" \
	comment=0x9048,"handle PRINT@" \
	comment=0x9051,"read #-n & set up DEVN" \
	comment=0x9054,"if DEVN = -1, test cassette OK for output" \
	comment=0x9057,"get current character from BASIC source" \
	comment=0x9059,"send CR to DEVN" \
	comment=0x905b,"skip comma" \
	comment=0x905e,"token USING" \
	comment=0x9064,"RTS" \
	comment=0x9066,"token TAB(" \
	comment=0x9070,"skip semicolon" \
	comment=0x9072,"get expression" \
	comment=0x9075,"numeric / string flag" \
	comment=0x9079,"string expression" \
	comment=0x907b,"convert FPA1 to string at \$3DA" \
	comment=0x907e,"register string at X" \
	comment=0x9081,"print string just compiled" \
	comment=0x9085,"initialise virtual DEVN device" \
	comment=0x9088,"cassette IO flag" \
	comment=0x908a,"no IO in progress" \
	comment=0x908c,"send CR to DEVN" \
	comment=0x908e,"get current character from BASIC source" \
	comment=0x9093,"string just printed so no space" \
	comment=0x9095,"get current character from BASIC source" \
	comment=0x909b,"print a space to DEVN" \
	comment=0x909d,"get current character from BASIC source" \
	comment=0x90a1,"send CR to DEVN" \
	comment=0x90a3,"output character to DEVN" \
	comment=0x90a5,"initialise virtual DEVN device & new line" \
	comment=0x90a5,"initialise virtual DEVN device" \
	comment=0x90a8,"send CR to DEVN" \
	comment=0x90aa,"device current column" \
	comment=0x90ac,"send CR to DEVN" \
	comment=0x90af,"called by PRINT to handle ," \
	comment=0x90af,"initialise virtual DEVN device" \
	comment=0x90b4,"device current column" \
	comment=0x90b6,"device last comma field" \
	comment=0x90ba,"send CR to DEVN" \
	comment=0x90be,"device current column" \
	comment=0x90c0,"device comma field width" \
	comment=0x90c7,"called by PRINT to handle TAB" \
	comment=0x90c7,"skip character & get number in B" \
	comment=0x90cc,"?SN ERROR" \
	comment=0x90d0,"initialise virtual DEVN device" \
	comment=0x90d3,"device current column" \
	comment=0x90d7,"cassette IO flag" \
	comment=0x90d9,"IO in progress" \
	comment=0x90db,"print a space to DEVN" \
	comment=0x90e0,"get next character from BASIC source" \
	comment=0x90e5,"print string to DEVN" \
	comment=0x90e5,"compile literal string at X" \
	comment=0x90e8,"point X to string just compiled & len in B" \
	comment=0x90ed,"RTS" \
	comment=0x90f1,"output character to DEVN" \
	comment=0x90f5,"print a space to DEVN" \
	comment=0x90fa,"print '?' to DEVN" \
	comment=0x90fa,"(90F8 863F       LDA   #\$3F)" \
	comment=0x90fa,"output character to DEVN" \
	comment=0x90fd,"add 0.5 to FPA1" \
	comment=0x90fd,"FP constant 0.5" \
	comment=0x9100,"add varptr X to FPA1" \
	comment=0x9102,"subtract FPA1 from varptr X" \
	comment=0x9102,"load FPA2 from varptr X" \
	comment=0x910b,"add varptr X to FPA1" \
	comment=0x910b,"load FPA2 from varptr X" \
	comment=0x910e,"FPA1 exponent" \
	comment=0x910f,"copy FPA2 to FPA1 (because FPA1 zero)" \
	comment=0x9113,"FPA2" \
	comment=0x9116,"A = B = FPA2 exponent" \
	comment=0x9119,"RTS (FPA2 is zero)" \
	comment=0x911b,"B = FPA2 exponent - FPA1 exponent" \
	comment=0x911d,"FPA1 & FPA2 same order" \
	comment=0x911f,"FPA1 higher order" \
	comment=0x9127,"FPA1" \
	comment=0x912d,"more than 8 bits to shift" \
	comment=0x9132,"shift mantissa of varptr X right -B bits" \
	comment=0x9135,"(carries into A)" \
	comment=0x9137,"FPA1 & FPA2 same sign" \
	comment=0x913b,"2's complement FPA1" \
	comment=0x913d,"carry is picked up below" \
	comment=0x9148,"add mantissa in FPA2 to FPA1" \
	comment=0x915f,"signs were same" \
	comment=0x9161,"normalize FPA1" \
	comment=0x9163,"2's complent mantissa in FPA1" \
	comment=0x9168,"normalize bit-wise" \
	comment=0x9188,"shift mantissa of varptr X right -B bits" \
	comment=0x91a2,"clear exponents in FPA1 (\$4f & \$54)" \
	comment=0x91a7,"(91A5 2508       BCS   \$91AF)" \
	comment=0x91b1,"?OV ERROR" \
	comment=0x91bd,"add the carry to mantissa in FPA1" \
	comment=0x91c2,"2's complement mantissa in FPA1" \
	comment=0x91db,"?OV ERROR" \
	comment=0x91dd,"cause error" \
	comment=0x91e0,"shift \$13 - \$16 & \$63 right -B bits" \
	comment=0x91e0,"(shifts 8 bits before testing B)" \
	comment=0x91f7,"shift mantissa of varptr X right -B bits" \
	comment=0x91ff,"RTS" \
	comment=0x920e,"FP constant 1" \
	comment=0x9213,"log series coefficients" \
	comment=0x9214,"FP constant .4342559419" \
	comment=0x9219,"FP constant .5765845412" \
	comment=0x921e,"FP constant .9618007592" \
	comment=0x9223,"FP constant 2.885390073" \
	comment=0x9228,"FP constant root 2 / 2" \
	comment=0x922d,"FP constant root 2" \
	comment=0x9232,"FP constant -0.5" \
	comment=0x9237,"FP constant ln2" \
	comment=0x923c,"LOG" \
	comment=0x923c,"sets B to -1, 0 or 1 as per sign of FPA1" \
	comment=0x923f,"?FC ERROR" \
	comment=0x9243,"FP constant root 2 / 2" \
	comment=0x9250,"add varptr X to FPA1" \
	comment=0x9253,"FP constant root 2" \
	comment=0x9256,"FPA1 = varptr X / FPA1" \
	comment=0x9259,"FP constant 1" \
	comment=0x925c,"FPA1 = varptr X - FPA1" \
	comment=0x925f,"series coefficients" \
	comment=0x9262,"calculate odd power series" \
	comment=0x9265,"FP constant -0.5" \
	comment=0x9268,"add varptr X to FPA1" \
	comment=0x926d,"add B to FPA1" \
	comment=0x9270,"FP constant ln2" \
	comment=0x9273,"multiply FPA1 by varptr X" \
	comment=0x9273,"load FPA2 from varptr X" \
	comment=0x9275,"RTS (FPA1 zero)" \
	comment=0x9277,"add A to exponent in FPA1" \
	comment=0x9285,"multiply mantissa in FPA2 by B" \
	comment=0x928d,"multiply mantissa in FPA2 by B" \
	comment=0x9295,"multiply mantissa in FPA2 by B" \
	comment=0x92a3,"copy mantissa from \$13 - \$16 to FPA1" \
	comment=0x92a6,"normalize FPA1" \
	comment=0x92a9,"multiply mantissa in FPA2 by B" \
	comment=0x92a9,"accumulate result in \$13 - \$16 & \$63 & shift result right 8 bits" \
	comment=0x92a9,"B=0 (shift \$13 - \$16 & \$63 right 8 bits)" \
	comment=0x92b1,"RTS" \
	comment=0x92da,"load FPA2 from varptr X & set \$62 with FPA1 / FPA2 sign difference" \
	comment=0x92da,"A = exponent from FPA2" \
	comment=0x92da,"B = exponent from FPA1" \
	comment=0x92f3,"add A to exponent in FPA1" \
	comment=0x9300,"clear exponents in FPA1 (\$4f & \$54)" \
	comment=0x9302,"sign difference FPA1 / FPA2" \
	comment=0x930e,"clear exponents in FPA1 (\$4f & \$54)" \
	comment=0x9312,"?OV ERROR" \
	comment=0x9315,"multiply FPA1 by 10" \
	comment=0x9315,"copy FPA1 to FPA2" \
	comment=0x931a,"x4" \
	comment=0x931c,"?OV ERROR" \
	comment=0x9320,"add FPA2 to FPA1 (FPA1 exponent in A)" \
	comment=0x9323,"double result" \
	comment=0x9325,"?OV ERROR" \
	comment=0x9328,"FP constant 10" \
	comment=0x932d,"divide FPA1 by 10" \
	comment=0x932d,"copy FPA1 to FPA2" \
	comment=0x9330,"FP constant 10" \
	comment=0x9336,"load variable into FPA1 (X is varptr)" \
	comment=0x933c,"divide varptr X by FPA1" \
	comment=0x933c,"(933A 8D9E       BSR   \$92DA)   ;load FPA2 from varptr X" \
	comment=0x933c,"?/0 ERROR (FPA1 zero)" \
	comment=0x9340,"add A to exponent in FPA1" \
	comment=0x9344,"?OV ERROR" \
	comment=0x9367,"identical mantissas - set carry" \
	comment=0x93ac,"copy mantissa from \$13 - \$16 to FPA1" \
	comment=0x93ae,"normalize FPA1" \
	comment=0x93b1,"?/0 ERROR" \
	comment=0x93b3,"cause error" \
	comment=0x93b6,"copy mantissa from \$13 - \$16 to FPA1" \
	comment=0x93bf,"load variable into FPA1 (X is varptr)" \
	comment=0x93d5,"assign FPA1 to variable store \$45 - \$49" \
	comment=0x93d8,"assign FPA1 to varptr in X" \
	comment=0x93da,"assign FPA1 to variable store \$40 - \$44" \
	comment=0x93e0,"assign FPA1 to varptr in <\$3b" \
	comment=0x93e0,"(93DE 9E3B       LDX   <\$3B)" \
	comment=0x93e0,"assign FPA1 to varptr in X" \
	comment=0x93f5,"copy FPA2 to FPA1 (A = sign)" \
	comment=0x940a,"copy FPA1 to FPA2 & test for exponent = 0" \
	comment=0x9418,"sets B to -1, 0 or 1 according to sign of FPA1" \
	comment=0x9425,"SGN" \
	comment=0x9425,"sets B to -1, 0 or 1 as per sign of FPA1" \
	comment=0x942f,"set carry according to sign" \
	comment=0x9433,"zero" \
	comment=0x943b,"normalize FPA1 (if carry clear, negate 1st)" \
	comment=0x943e,"ABS" \
	comment=0x943e,"simply clear sign byte" \
	comment=0x9441,"compare FPA1 - varptr X  (set B to -1, 0 or 1)" \
	comment=0x9443,"sets B to -1, 0 or 1 as per sign of FPA1" \
	comment=0x9449,"set B to -1 or 1 as per sign of FPA1" \
	comment=0x944b,"compare FPA1 - varptr X (of same sign)" \
	comment=0x946e,"turn carry into sign" \
	comment=0x9471,"reduce B to +/- 1" \
	comment=0x9473,"denormalize FPA1 to an integer (but don't update exponent)" \
	comment=0x9475,"clear mantissa in FPA1" \
	comment=0x947f,"2's complement mantissa in FPA1 (not \$54)" \
	comment=0x9482,"FPA1" \
	comment=0x9489,"shift mantissa of varptr X right -B bits" \
	comment=0x9496,"shift mantissa of varptr X right -B bits" \
	comment=0x9499,"INT" \
	comment=0x949b,"when exponent >= \$A0, no fractional part" \
	comment=0x949d,"RTS (already an integer)" \
	comment=0x949f,"denormalize FPA1 to an integer" \
	comment=0x94b1,"normalize FPA1 (if carry clear, negate 1st)" \
	comment=0x94b4,"clear mantissa in FPA1" \
	comment=0x94bd,"read a numeric constant into FPA1" \
	comment=0x94bd,"zero" \
	comment=0x94c7,"\$47 & \$48 = decimal exponent & sign" \
	comment=0x94c9,"\$45 & \$46 decimal place counter & flag" \
	comment=0x94cb,"read sig. figs. into FPA1" \
	comment=0x94cf,"read hex or octal" \
	comment=0x94df,"get next character from BASIC source" \
	comment=0x94e1,"read sig. figs. into FPA1" \
	comment=0x94e9,"finished reading number, now finalise." \
	comment=0x94eb,"get next character from BASIC source" \
	comment=0x94ed,"read decimal exponent into \$47" \
	comment=0x94ef,"token -" \
	comment=0x94f7,"token +" \
	comment=0x9503,"get next character from BASIC source" \
	comment=0x9505,"read decimal exponent into \$47" \
	comment=0x9509,"finished reading number, now finalise." \
	comment=0x950b,"-ve exponent" \
	comment=0x950d,"finished reading number, now finalise." \
	comment=0x9511,"1st decimal point encountered" \
	comment=0x9513,"finished reading number, now finalise." \
	comment=0x951d,"divide FPA1 by 10" \
	comment=0x9526,"multiply FPA1 by 10" \
	comment=0x952f,"RTS" \
	comment=0x9531,"COM \$54 if FPA1 non zero" \
	comment=0x9534,"read sig. figs. into FPA1" \
	comment=0x9534,"increment decimal place counter" \
	comment=0x9536,"if decimal point passed" \
	comment=0x953c,"multiply FPA1 by 10" \
	comment=0x9543,"add B to FPA1" \
	comment=0x9547,"add B to FPA1" \
	comment=0x9547,"assign FPA1 to variable store \$40 - \$44" \
	comment=0x954a,"assign B to FPA1" \
	comment=0x9550,"add varptr X to FPA1" \
	comment=0x9553,"read decimal exponent into \$47" \
	comment=0x9553,"(note that it doesn't check for more than two digits)" \
	comment=0x9559,"B = 10 * \$47" \
	comment=0x9564,"used by print number routine" \
	comment=0x9564,"FP constant 99999999.9" \
	comment=0x9569,"FP constant 999999999" \
	comment=0x956e,"FP constant 1000000000" \
	comment=0x9573,"print 'IN xxxx' (current line number)" \
	comment=0x9578,"current line number" \
	comment=0x957a,"print unsigned number in D" \
	comment=0x957e,"set carry for correct result" \
	comment=0x957f,"normalize FPA1 using exponent in B" \
	comment=0x9582,"convert FPA1 to string at \$3DA" \
	comment=0x9584,"print string to DEVN" \
	comment=0x9587,"convert FPA1 to string at \$3DA" \
	comment=0x9592,"print '-' for negative numbers else space" \
	comment=0x959c,"number is zero" \
	comment=0x95a3,"number >= 1" \
	comment=0x95a5,"FP constant 1000000000" \
	comment=0x95a8,"multiply varptr X & FPA1" \
	comment=0x95ab,"-9" \
	comment=0x95ad,"decimal exponent" \
	comment=0x95af,"FP constant 999999999" \
	comment=0x95b2,"compare FPA1 - varptr X (of same sign)" \
	comment=0x95b7,"FP constant 99999999.9" \
	comment=0x95ba,"compare FPA1 - varptr X (of same sign)" \
	comment=0x95bd,"(FPA1 is now 100000000 to 999999999)" \
	comment=0x95bf,"multiply FPA1 by 10" \
	comment=0x95c2,"correct exponent" \
	comment=0x95c6,"divide FPA1 by 10" \
	comment=0x95c9,"correct exponent" \
	comment=0x95cd,"add 0.5 to FPA1 (round it up)" \
	comment=0x95d0,"denormalize FPA1 to an integer" \
	comment=0x95d3,"1 digit before point for sci. notation" \
	comment=0x95d7,"exponent now 2 more than it should be" \
	comment=0x95d9,"actual exponent < -2 (use sci. notation)" \
	comment=0x95dd,"actual exponent >= 9 (use sci. notation)" \
	comment=0x95e0,"number of digits before point = exp + 1" \
	comment=0x95e6,"decimal exponent" \
	comment=0x95e8,"number of digits before decimal point" \
	comment=0x95ea,"no leading decimal point" \
	comment=0x95f2,"can only be zero or -ve here" \
	comment=0x95f3,"no zero reqd after point & before 1st digit" \
	comment=0x95fc,"sign bit used for zero crossing logic" \
	comment=0x95fe,"resolves a decimal digit by adding powers" \
	comment=0x9600,"of 10 until zero is passed." \
	comment=0x9606,"On 1st pass -ve values are used to get FPA1" \
	comment=0x9608,"below zero. The digit is no. of loops - 1." \
	comment=0x960c,"On 2nd pass +ve values are used to get FPA1" \
	comment=0x960e,"above zero. The digit is 10 - no. loops." \
	comment=0x9612,"This continues with alternating signs." \
	comment=0x9616,"loop counter" \
	comment=0x9617,"logic to test if zero passed" \
	comment=0x961b,"digit = loops - 1" \
	comment=0x9620,"1 less & ASCII conversion" \
	comment=0x9626,"lose sign bit" \
	comment=0x962c,"haven't reached decimal point yet" \
	comment=0x9632,"alternates B between \$00 & \$80" \
	comment=0x963a,"backtrack over digits" \
	comment=0x963c,"until non-zero found" \
	comment=0x9642,"if no sig. figs. after decimal point" \
	comment=0x9644,"then lose it." \
	comment=0x964a,"normal number (no decimal exponent)" \
	comment=0x964c,"+ve exponent" \
	comment=0x9657,"convert B to ASCII number in D" \
	comment=0x9662,"terminate string" \
	comment=0x9668,"terminate string" \
	comment=0x966e,"FP constant 0.5" \
	comment=0x9673,"table of 32 bit numbers used by convert number to string routine" \
	comment=0x9673,"(to resolve decimal digits)" \
	comment=0x9673,"-100000000" \
	comment=0x9677,"10000000" \
	comment=0x967b,"-1000000" \
	comment=0x967f,"100000" \
	comment=0x9683,"-10000" \
	comment=0x9687,"1000" \
	comment=0x968b,"-100" \
	comment=0x968f,"10" \
	comment=0x9693,"-1" \
	comment=0x9697,"SQR" \
	comment=0x9697,"copy FPA1 to FPA2" \
	comment=0x969a,"FP constant 0.5" \
	comment=0x969d,"raise FPA2 to power varptr X" \
	comment=0x969d,"load variable into FPA1 (X is varptr)" \
	comment=0x96a0,"EXP" \
	comment=0x96a7,"?/0 ERROR" \
	comment=0x96ab,"clear FPA1 exponents" \
	comment=0x96b1,"assign FPA1 to varptr in X" \
	comment=0x96b9,"INT" \
	comment=0x96c1,"compare FPA1 - varptr X (of same sign)" \
	comment=0x96c9,"copy FPA2 to FPA1 & put A in \$54" \
	comment=0x96ce,"LOG" \
	comment=0x96d4,"multiply varptr X & FPA1" \
	comment=0x96d7,"EXP" \
	comment=0x96dc,"RTS" \
	comment=0x96e5,"FP constant 1/ln 2" \
	comment=0x96ea,"EXP series coefficient table" \
	comment=0x96ea,"values appear to be error compensated" \
	comment=0x96eb,"FP constant .0000214987637  (ln2)^7 / 7!" \
	comment=0x96f0,"FP constant .0001435231404  (ln2)^6 / 6!" \
	comment=0x96f5,"FP constant .001342263483   (ln2)^5 / 5!" \
	comment=0x96fa,"FP constant .009614017014   (ln2)^4 / 4!" \
	comment=0x96ff,"FP constant .05550512686    (ln2)^3 / 3!" \
	comment=0x9704,"FP constant .2402263846     (ln2)^2 / 2!" \
	comment=0x9709,"FP constant .6931471862      ln2" \
	comment=0x970e,"FP constant 1" \
	comment=0x9713,"EXP" \
	comment=0x9713,"calculates exp(x) by first calculating q=x/ln2 such that exp(x) = 2^q" \
	comment=0x9713,"fractional part of q is used for good convergence" \
	comment=0x9713,"integer part of q is simply added to FPA1 exponent afterwards" \
	comment=0x9713,"FP constant 1/ln 2" \
	comment=0x9716,"multiply FPA1 by varptr X" \
	comment=0x9718,"assign FPA1 to variable store \$40 - \$44" \
	comment=0x9721,"?OV ERROR if FPA1 +ve else FPA1 = 0" \
	comment=0x9724,"INT" \
	comment=0x9727,"integer part of argument" \
	comment=0x972b,"?OV ERROR" \
	comment=0x9733,"FPA1 = varptr X - FPA1" \
	comment=0x9736,"EXP coefficient table" \
	comment=0x9739,"series calculation" \
	comment=0x973f,"add A to exponent in FPA1" \
	comment=0x9743,"calculate odd power series" \
	comment=0x9743,"X points to coefficient table (1st byte is n)" \
	comment=0x9743,"x in FPA1" \
	comment=0x9743,"result = (a0xx+a1)xx+a2)xx+a3 ...)xx+an) * x" \
	comment=0x9743,"( = a0*x^(2n+1) + a1*x^(2n-1) + ... + a(n-1)*x^3 + an*x )" \
	comment=0x9743,"result in FPA1" \
	comment=0x9745,"assign FPA1 to variable store \$40 - \$44" \
	comment=0x9748,"multiply varptr X & FPA1 (x squared)" \
	comment=0x974a,"calculate series" \
	comment=0x974f,"multiply varptr X & FPA1 (odd powers)" \
	comment=0x9752,"calculate power series (polynomial of nth order)" \
	comment=0x9752,"X points to coefficient table (1st byte is n)" \
	comment=0x9752,"x in FPA1" \
	comment=0x9752,"result = (a0x+a1)x+a2)x+a3 ...)x+an" \
	comment=0x9752,"( = a0*x^n + a1*x^(n-1) + ... + a(n-1)*x + an )" \
	comment=0x9752,"result in FPA1" \
	comment=0x9754,"assign FPA1 to variable store \$45 - \$49" \
	comment=0x975f,"multiply varptr X & FPA1" \
	comment=0x9767,"add varptr X to FPA1" \
	comment=0x9772,"RND" \
	comment=0x9772,"sets B to -1, 0 or 1 as per sign of FPA1" \
	comment=0x9779,"INT" \
	comment=0x977b,"assign FPA1 to variable store \$40 - \$44" \
	comment=0x9783,"multiply varptr X & FPA1" \
	comment=0x9785,"FP constant 1" \
	comment=0x9788,"add varptr X to FPA1" \
	comment=0x978b,"INT" \
	comment=0x97a2,"multiply FPA1 by mantissa in FPA2" \
	comment=0x97c4,"normalize FPA1" \
	comment=0x97c7,"RND multiplier" \
	comment=0x97cb,"COS ... cos x = sin (x+pi/2)" \
	comment=0x97cb,"FP constant pi/2" \
	comment=0x97ce,"add varptr X to FPA1" \
	comment=0x97d1,"SIN" \
	comment=0x97d1,"copy FPA1 to FPA2" \
	comment=0x97d4,"FP constant 2*pi" \
	comment=0x97d9,"STB \$62 & divide FPA2 by varptr X (result FPA1)" \
	comment=0x97dc,"copy FPA1 to FPA2" \
	comment=0x97df,"INT" \
	comment=0x97e7,"subtract FPA1 from FPA2 (B=FPA1 exponent)" \
	comment=0x97ea,"FP constant 0.25" \
	comment=0x97ed,"FPA1 = varptr X - FPA1" \
	comment=0x97f4,"angle is 1st quadrant" \
	comment=0x97f6,"add 0.5 to FPA1" \
	comment=0x97ff,"COM \$54 if FPA1 non zero" \
	comment=0x9802,"FP constant 0.25" \
	comment=0x9805,"add varptr X to FPA1" \
	comment=0x980d,"COM \$54 if FPA1 non zero" \
	comment=0x9810,"series coefficients" \
	comment=0x9813,"calculate odd power series" \
	comment=0x9816,"TAN ... tan x = sin x / cos x" \
	comment=0x9816,"assign FPA1 to variable store \$40 - \$44" \
	comment=0x981b,"SIN" \
	comment=0x9820,"assign FPA1 to varptr in X" \
	comment=0x9826,"load variable into FPA1 (X is varptr)" \
	comment=0x982d,"must calculate cos" \
	comment=0x9831,"?OV ERROR" \
	comment=0x9838,"FPA1 = varptr X / FPA1" \
	comment=0x983f,"FP constant pi/2" \
	comment=0x9844,"FP constant 2*pi" \
	comment=0x9849,"FP constant 0.25" \
	comment=0x984e,"sin series coefficient table" \
	comment=0x984e,"values appear to be error compensated" \
	comment=0x984f,"FP constant -14.38139067   -(2pi)^11 / 11!" \
	comment=0x9854,"FP constant  42.00779712    (2pi)^9 / 9!" \
	comment=0x9859,"FP constant -76.70417025   -(2pi)^7 / 7!" \
	comment=0x985e,"FP constant  81.60522368    (2pi)^5 / 5!" \
	comment=0x9863,"FP constant -41.34170211   -(2pi)^3 / 3!" \
	comment=0x9868,"FP constant  2*pi" \
	comment=0x986d,"FP constant  7324114470" \
	comment=0x9872,"FP constant  26913.76914" \
	comment=0x9877,"ATN" \
	comment=0x9877,"calculates atn(x) or pi/2-atn(1/x)" \
	comment=0x9877,"same result either way but series only works -1 < x <= 1" \
	comment=0x987d,"COM \$54 if FPA1 non zero" \
	comment=0x9887,"FP constant 1" \
	comment=0x988a,"divide varptr X by FPA1" \
	comment=0x988c,"series coefficients" \
	comment=0x988f,"calculate odd power series" \
	comment=0x9897,"FP constant pi/2" \
	comment=0x989a,"FPA1 = varptr X - FPA1" \
	comment=0x98a2,"COM \$54 if FPA1 non zero" \
	comment=0x98a6,"ATN series coefficients" \
	comment=0x98a6,"values appear to be error compensated" \
	comment=0x98a7,"FP constant -.0006847939119" \
	comment=0x98ac,"FP constant  .004850942155" \
	comment=0x98b1,"FP constant -.01611170184" \
	comment=0x98b6,"FP constant  .03420963805" \
	comment=0x98bb,"FP constant -.05427913276" \
	comment=0x98c0,"FP constant  .07245719654" \
	comment=0x98c5,"FP constant -.08980239538" \
	comment=0x98ca,"FP constant  .1109324134" \
	comment=0x98cf,"FP constant -.1425398077" \
	comment=0x98d4,"FP constant  .1999991205" \
	comment=0x98d9,"FP constant -.3333333157" \
	comment=0x98de,"FP constant 1" \
	comment=0x98e3,"part of reset routine: sets up sound & graphics variables" \
	comment=0x98e6,"PLAY volume data" \
	comment=0x98ea,"PLAY tempo" \
	comment=0x98ec,"PLAY octave" \
	comment=0x98ef,"PLAY note length" \
	comment=0x98f1,"PLAY duration" \
	comment=0x98f3,"zero" \
	comment=0x98f5,"DRAW angle" \
	comment=0x98f9,"graphics X" \
	comment=0x98fd,"graphics Y" \
	comment=0x9900,"called by CSAVE to do CSAVEM" \
	comment=0x9900,"get next character from BASIC source" \
	comment=0x9902,"get filename" \
	comment=0x9905,"get start address" \
	comment=0x990a,"get end address" \
	comment=0x990e,"?FC ERROR" \
	comment=0x9912,"get entry address" \
	comment=0x9917,"get current character from BASIC source" \
	comment=0x991b,"file type = 2 = binary" \
	comment=0x991d,"non-ASCII & ungapped" \
	comment=0x991f,"write filename block" \
	comment=0x9922,"cassette status" \
	comment=0x9924,"block type" \
	comment=0x9926,"write leader" \
	comment=0x992b,"IO buffer" \
	comment=0x992f,"block length" \
	comment=0x9933,"IO buffer" \
	comment=0x9939,"NEG \$7c CLR \$7d & write last block" \
	comment=0x9943,"block length" \
	comment=0x9945,"write block to tape" \
	comment=0x994a,"get a number from command and leave it on stack" \
	comment=0x994a,"skip comma" \
	comment=0x994d,"read 16 bit number into X" \
	comment=0x9956,"FIX" \
	comment=0x9956,"sets B to -1, 0 or 1 as per sign of FPA1" \
	comment=0x995b,"INT" \
	comment=0x9962,"COM \$54 if FPA1 non zero" \
	comment=0x9965,"EDIT" \
	comment=0x9965,"get line number in \$2b" \
	comment=0x9968,"lose return address" \
	comment=0x996e,"search program for line number in <\$2b" \
	comment=0x9971,"?UL ERROR" \
	comment=0x9975,"detokenize BASIC line" \
	comment=0x997d,"line length" \
	comment=0x9981,"print unsigned number in D" \
	comment=0x9984,"print a space to DEVN" \
	comment=0x998c,"print entire line" \
	comment=0x998f,"read keys (carry clear if control key)" \
	comment=0x9992,"set carry if A is non-numeric character" \
	comment=0x9997,"accumulate typed digits in B" \
	comment=0x99a6,"(A = abandon changes & start again)" \
	comment=0x99aa,"send CR to DEVN" \
	comment=0x99af,"(L = show line in current state)" \
	comment=0x99b3,"output ASCIIZ string to DEVN (X is pointer)" \
	comment=0x99b7,"send CR to DEVN" \
	comment=0x99bc,"lose return address" \
	comment=0x99be,"(RETURN = save changes, show line & quit)" \
	comment=0x99c2,"output ASCIIZ string to DEVN (X is pointer)" \
	comment=0x99c4,"send CR to DEVN" \
	comment=0x99ca,"BASIC source pointer" \
	comment=0x99cc,"enter BASIC line" \
	comment=0x99cf,"(E = save changes & quit)" \
	comment=0x99d3,"(Q = discard changes & quit)" \
	comment=0x99d7,"send CR to DEVN" \
	comment=0x99da,"command mode" \
	comment=0x99e1,"(SPACE = show more characters)" \
	comment=0x99e8,"output ASCIIZ string to DEVN (stops at 249 characters)" \
	comment=0x99e8,"(99E6 C6F9       LDB   #\$F9)" \
	comment=0x99ec,"output character to DEVN" \
	comment=0x99f2,"show another (in EDIT context)" \
	comment=0x99f5,"EDIT: test for Delete" \
	comment=0x99f5,"(D = delete a number of characters)" \
	comment=0x99fd,"close line up over removed character" \
	comment=0x9a03,"EDIT: close line up over removed character" \
	comment=0x9a10,"EDIT: test for insert mode functions" \
	comment=0x9a10,"(I = insert mode)" \
	comment=0x9a14,"(X = insert mode at end of line)" \
	comment=0x9a18,"(H = wipe rest of line & insert)" \
	comment=0x9a23,"updated line length" \
	comment=0x9a25,"output ASCIIZ string to DEVN (X is pointer)" \
	comment=0x9a27,"read keys (carry clear if control key)" \
	comment=0x9a2c,"RETURN" \
	comment=0x9a30,"RTS (escape insert mode)" \
	comment=0x9a34,"not backspace" \
	comment=0x9a39,"nothing to delete" \
	comment=0x9a3b,"delete it on screen" \
	comment=0x9a3d,"delete it in memory" \
	comment=0x9a41,"EDIT: test for Change" \
	comment=0x9a41,"(C = change a number of characters)" \
	comment=0x9a47,"RTS" \
	comment=0x9a49,"read keys (carry clear if control key)" \
	comment=0x9a52,"output character to DEVN" \
	comment=0x9a55,"change another" \
	comment=0x9a58,"EDIT: typed characters in insert mode" \
	comment=0x9a5e,"line full" \
	comment=0x9a62,"create a space for character" \
	comment=0x9a72,"output character to DEVN" \
	comment=0x9a78,"EDIT: backspace over a number of characters" \
	comment=0x9a7f,"backspace again" \
	comment=0x9a82,"EDIT: backspace" \
	comment=0x9a85,"RTS" \
	comment=0x9a8b,"output character to DEVN" \
	comment=0x9a8e,"EDIT: test for search functions" \
	comment=0x9a8e,"(K = wipe chrs until nth occurrence of chr)" \
	comment=0x9a92,"(S = search for nth occurrence of chr)" \
	comment=0x9a97,"EDIT: search functions" \
	comment=0x9a99,"read keys (carry clear if control key)" \
	comment=0x9a9f,"PULS Y,PC" \
	comment=0x9aa3,"Kill (not Search)" \
	comment=0x9aa5,"output character to DEVN" \
	comment=0x9aab,"close line up over removed character" \
	comment=0x9ab2,"not found" \
	comment=0x9ab5,"find next occurrence" \
	comment=0x9ab9,"read keys (carry clear if control key)" \
	comment=0x9ab9,"read character from DEVN & strip MSB" \
	comment=0x9abe,"pointless test!" \
	comment=0x9ac2,"not shift + CU" \
	comment=0x9ac8,"return" \
	comment=0x9acc,"escape" \
	comment=0x9ad0,"backspace" \
	comment=0x9ad4,"illegal" \
	comment=0x9ad9,"TRON" \
	comment=0x9adb,"TROFF" \
	comment=0x9adb,"(9ADA 4F         CLRA)" \
	comment=0x9ade,"POS" \
	comment=0x9ade,"DEVN" \
	comment=0x9ae2,"load DEVN from FPA1" \
	comment=0x9ae5,"if DEVN = -1, test cassette OK for output" \
	comment=0x9ae8,"initialise virtual DEVN device" \
	comment=0x9aeb,"device current column" \
	comment=0x9aef,"DEVN" \
	comment=0x9af1,"assign B to FPA1" \
	comment=0x9af4,"VARPTR" \
	comment=0x9af4,"skip open bracket" \
	comment=0x9af7,"end of BASIC storage" \
	comment=0x9afb,"get varptr of variable in X" \
	comment=0x9afe,"skip close bracket" \
	comment=0x9b05,"not allowed to create new variable" \
	comment=0x9b07,"?FC ERROR" \
	comment=0x9b09,"assign D to FPA1" \
	comment=0x9b0c,"MID\$ on LHS" \
	comment=0x9b0c,"get next character from BASIC source" \
	comment=0x9b0e,"skip open bracket" \
	comment=0x9b11,"get varptr of variable in X" \
	comment=0x9b18,"stack root / string storage start" \
	comment=0x9b1d,"top of BASIC RAM" \
	comment=0x9b23,"reserve B bytes of string space" \
	comment=0x9b2a,"copy string (len B) from varptr X to (\$25)+" \
	comment=0x9b39,"?FC ERROR" \
	comment=0x9b46,"skip close bracket" \
	comment=0x9b4b,"skip character in B" \
	comment=0x9b4e,"get string expression & point X to it" \
	comment=0x9b5a,"?FC ERROR" \
	comment=0x9b79,"copy B bytes from X to U" \
	comment=0x9b7e,"get string expression & point X to it (B=len)" \
	comment=0x9b7e,"get expression" \
	comment=0x9b81,"validate string & point X to it (B=len)" \
	comment=0x9b84,"STRING\$" \
	comment=0x9b84,"skip open bracket" \
	comment=0x9b87,"get number into B" \
	comment=0x9b8c,"skip comma" \
	comment=0x9b8f,"get expression" \
	comment=0x9b92,"skip close bracket" \
	comment=0x9b95,"numeric / string flag" \
	comment=0x9b99,"read 8 bit value into B from FPA1" \
	comment=0x9b9e,"get 1st character of string into B" \
	comment=0x9ba3,"number of copies" \
	comment=0x9ba5,"reserve B bytes of string space" \
	comment=0x9bb4,"INSTR" \
	comment=0x9bb4,"skip open bracket" \
	comment=0x9bb7,"get expression" \
	comment=0x9bba,"default start position" \
	comment=0x9bbe,"numeric / string flag" \
	comment=0x9bc0,"start pos not specified" \
	comment=0x9bc2,"read 8 bit value into B from FPA1" \
	comment=0x9bc7,"?FC ERROR" \
	comment=0x9bc9,"skip comma" \
	comment=0x9bcc,"get expression" \
	comment=0x9bcf,"validate string expression" \
	comment=0x9bd6,"skip comma" \
	comment=0x9bd9,"get string expression & point X to it" \
	comment=0x9bde,"skip close bracket" \
	comment=0x9be1,"varptr of main string" \
	comment=0x9be3,"point X to string & length in B" \
	comment=0x9bea,"main string is shorter than start pos" \
	comment=0x9bec,"target string length" \
	comment=0x9bf0,"start pos" \
	comment=0x9bf4,"Y = X = position to start search" \
	comment=0x9bf6,"U -> target characters" \
	comment=0x9bf8,"B = target length" \
	comment=0x9bfa,"A = main string length" \
	comment=0x9bfe,"A = A - start pos + 1" \
	comment=0x9c01,"remaining length is shorter than target" \
	comment=0x9c07,"didn't match" \
	comment=0x9c0a,"test next character in target" \
	comment=0x9c0c,"found it" \
	comment=0x9c10,"(9C0F 5F         CLRB)" \
	comment=0x9c12,"assign B to FPA1" \
	comment=0x9c17,"advance start pos & try again" \
	comment=0x9c1b,"read octal or hex number from command into \$52 / \$53" \
	comment=0x9c22,"get next character from BASIC source" \
	comment=0x9c2c,"get current character from BASIC source" \
	comment=0x9c32,"?SN ERROR" \
	comment=0x9c38,"shift word at ,X left B bits" \
	comment=0x9c3a,"get next character from BASIC source" \
	comment=0x9c3e,"assign contents of \$52 / \$53 to FPA1" \
	comment=0x9c42,"numeric / string flag" \
	comment=0x9c4c,"normalize FPA1" \
	comment=0x9c4f,"read hex digits from command into ,X" \
	comment=0x9c4f,"get next character from BASIC source" \
	comment=0x9c53,"carry clear if A-Z" \
	comment=0x9c56,"assign contents of \$52 / \$53 to FPA1" \
	comment=0x9c5a,"assign contents of \$52 / \$53 to FPA1" \
	comment=0x9c60,"shift word at ,X left B bits" \
	comment=0x9c64,"shift word at ,X left B bits" \
	comment=0x9c68,"?OV ERROR" \
	comment=0x9c76,"cause error if in command mode" \
	comment=0x9c76,"current line number" \
	comment=0x9c7a,"not in command mode" \
	comment=0x9c7c,"?ID ERROR" \
	comment=0x9c7e,"cause error" \
	comment=0x9c81,"DEF" \
	comment=0x9c85,"DEF USR" \
	comment=0x9c8e,"test for command mode" \
	comment=0x9c90,"skip open bracket" \
	comment=0x9c95,"array illegal flag" \
	comment=0x9c97,"get varptr of variable in X" \
	comment=0x9c9c,"skip close bracket" \
	comment=0x9ca1,"skip character in B" \
	comment=0x9ca6,"BASIC source pointer" \
	comment=0x9cae,"skip to start of next statement" \
	comment=0x9cb1,"token FN" \
	comment=0x9cb3,"skip character in B" \
	comment=0x9cb8,"array illegal flag" \
	comment=0x9cc1,"validate numeric expression" \
	comment=0x9cc8,"get expression inside brackets" \
	comment=0x9ccf,"?UF ERROR" \
	comment=0x9cd3,"cause error" \
	comment=0x9cd5,"BASIC source pointer" \
	comment=0x9cda,"BASIC source pointer" \
	comment=0x9ce6,"assign FPA1 to varptr in X" \
	comment=0x9ce9,"read numeric expression into FPA1" \
	comment=0x9cf6,"get current character from BASIC source" \
	comment=0x9cf8,"?SN ERROR" \
	comment=0x9cfc,"BASIC source pointer" \
	comment=0x9d00,"DEF USRx = address" \
	comment=0x9d00,"get next character from BASIC source" \
	comment=0x9d02,"get next character from BASIC source" \
	comment=0x9d0d,"called by USR: converts following digit into USR table pointer" \
	comment=0x9d0e,"get current character from BASIC source" \
	comment=0x9d16,"get next character from BASIC source" \
	comment=0x9d18,"address of USR table" \
	comment=0x9d1d,"USRx" \
	comment=0x9d23,"get expression inside brackets" \
	comment=0x9d26,"FPA1" \
	comment=0x9d29,"numeric / string flag" \
	comment=0x9d2d,"point X to string just compiled & len in B" \
	comment=0x9d32,"numeric / string flag" \
	comment=0x9d35,"skips = sign & reads 16 bit number into X" \
	comment=0x9d35,"token =" \
	comment=0x9d37,"skip character in B" \
	comment=0x9d3a,"read 16 bit number into X" \
	comment=0x9d3d,"IRQ service routine" \
	comment=0x9d40,"vsync" \
	comment=0x9d46,"TIMER value" \
	comment=0x9d4e,"...continued" \
	comment=0x9d51,"TIMER on LHS" \
	comment=0x9d51,"get next character from BASIC source" \
	comment=0x9d55,"TIMER value" \
	comment=0x9d59,"TIMER" \
	comment=0x9d59,"TIMER value" \
	comment=0x9d5e,"assign contents of \$52 / \$53 to FPA1" \
	comment=0x9d61,"DEL" \
	comment=0x9d61,"?FC ERROR" \
	comment=0x9d65,"read line number & store in \$2b" \
	comment=0x9d68,"search program for line number in <\$2b" \
	comment=0x9d6d,"get current character from BASIC source" \
	comment=0x9d71,"token -" \
	comment=0x9d75,"get next character from BASIC source" \
	comment=0x9d86,"(9D84 EEC4       LDU   ,U)" \
	comment=0x9d92,"move program down from U to X" \
	comment=0x9d94,"clear variables and reset stack & cmd ptr" \
	comment=0x9d99,"set up next line pointers from X onwards" \
	comment=0x9d9c,"command mode" \
	comment=0x9d9f,"read line number & store in \$2b" \
	comment=0x9da2,"cause error if next byte is not zero" \
	comment=0x9da9,"start of simple variables" \
	comment=0x9dae,"start of simple variables" \
	comment=0x9db1,"LINE INPUT" \
	comment=0x9db1,"test for command mode" \
	comment=0x9db4,"get next character from BASIC source" \
	comment=0x9dba,"read #-n & set up DEVN" \
	comment=0x9dbd,"test cassette status OK for input" \
	comment=0x9dc0,"skip comma" \
	comment=0x9dc5,"no prompt" \
	comment=0x9dc7,"read literal string" \
	comment=0x9dcc,"skip character in B" \
	comment=0x9dcf,"print string just compiled" \
	comment=0x9dd9,"DEVN" \
	comment=0x9ddb,"get varptr of variable in X" \
	comment=0x9de0,"validate string expression" \
	comment=0x9de7,"compile literal string at X" \
	comment=0x9dea,"assign string variable" \
	comment=0x9ded,"read line number into X & \$2b" \
	comment=0x9ded,"read line number & store in \$2b" \
	comment=0x9df3,"RENUM: search for start line" \
	comment=0x9df7,"search program for line number in <\$2b" \
	comment=0x9dfa,"RENUM" \
	comment=0x9dfa,"clear variables & reset stack" \
	comment=0x9e00,"default RENUM 10,0,10" \
	comment=0x9e07,"get current character from BASIC source" \
	comment=0x9e0b,"read line number into X & \$2b" \
	comment=0x9e0d,"new start line" \
	comment=0x9e0f,"get current character from BASIC source" \
	comment=0x9e13,"skip comma" \
	comment=0x9e18,"read line number into X & \$2b" \
	comment=0x9e1a,"line to start renumbering at" \
	comment=0x9e1c,"get current character from BASIC source" \
	comment=0x9e20,"skip comma" \
	comment=0x9e25,"read line number into X & \$2b" \
	comment=0x9e27,"line increment" \
	comment=0x9e29,"?FC ERROR" \
	comment=0x9e2b,"cause error if next byte is not zero" \
	comment=0x9e2e,"search for start line" \
	comment=0x9e30,"save address" \
	comment=0x9e34,"search for new start line" \
	comment=0x9e36,"not allowed to be lower than start line" \
	comment=0x9e38,"?FC ERROR" \
	comment=0x9e3a,"dry run - check lines don't get too high" \
	comment=0x9e3c,"prepare line numbers in statements" \
	comment=0x9e3f,"set up next line pointers in BASIC program" \
	comment=0x9e42,"search for start line" \
	comment=0x9e44,"save address" \
	comment=0x9e46,"convert line numbers to addresses" \
	comment=0x9e48,"do the actual renumbering" \
	comment=0x9e4a,"convert addresses to line numbers" \
	comment=0x9e4c,"convert line numbers back to ASCII" \
	comment=0x9e4f,"clear variables & reset stack" \
	comment=0x9e52,"set up next line pointers in BASIC program" \
	comment=0x9e55,"command mode" \
	comment=0x9e58,"RENUM: dry run to check that line numbers don't get too high" \
	comment=0x9e5a,"RENUM: renumber!" \
	comment=0x9e5a,"(9E59 4F         CLRA)" \
	comment=0x9e5c,"start address" \
	comment=0x9e5e,"new start number" \
	comment=0x9e60,"test for end of program" \
	comment=0x9e62,"dry run flag" \
	comment=0x9e66,"store new line number" \
	comment=0x9e68,"point X to next line" \
	comment=0x9e6a,"test for end of program" \
	comment=0x9e6c,"increment line number" \
	comment=0x9e6e,"?FC ERROR" \
	comment=0x9e74,"?FC ERROR" \
	comment=0x9e77,"RENUM: test for end of program" \
	comment=0x9e7f,"return 2 levels if at end of program" \
	comment=0x9e82,"RENUM: on 1st call converts the line numbers in each info block" \
	comment=0x9e82,"into line addresses. On 2nd call converts them back into" \
	comment=0x9e82,"line numbers." \
	comment=0x9e82,"start of BASIC program" \
	comment=0x9e88,"test for end of program" \
	comment=0x9e90,"end of line" \
	comment=0x9e95,"1st pass - convert line number to address" \
	comment=0x9e98,"2nd pass - convert address to line number" \
	comment=0x9ea3,"reconstruct line number coded in block" \
	comment=0x9eb5,"search program for line number in <\$2b" \
	comment=0x9eba,"line not found - store a 3 for 'UL'" \
	comment=0x9ebc,"address of line" \
	comment=0x9ec4,"becomes a 1 in a moment" \
	comment=0x9ec6,"address of line" \
	comment=0x9ec8,"actual line number" \
	comment=0x9ecc,"store it in info block" \
	comment=0x9ece,"RENUM: prepare line numbers in statements" \
	comment=0x9ece,"(replaces line number digits with 5 byte info block)" \
	comment=0x9ece,"start of BASIC program" \
	comment=0x9ed2,"BASIC source pointer" \
	comment=0x9ed6,"test for end of program" \
	comment=0x9edc,"BASIC source pointer" \
	comment=0x9ede,"get next character from BASIC source" \
	comment=0x9ee1,"end of line" \
	comment=0x9ee3,"non-token" \
	comment=0x9ee5,"BASIC source pointer" \
	comment=0x9ee9,"skip function token" \
	comment=0x9eeb,"PATCH - CLS GET PUT ???" \
	comment=0x9eee,"token THEN" \
	comment=0x9ef2,"token ELSE" \
	comment=0x9ef6,"token GO" \
	comment=0x9efa,"get next character from BASIC source" \
	comment=0x9efc,"token TO" \
	comment=0x9f00,"token SUB" \
	comment=0x9f02,"keep looking for interesting stuff" \
	comment=0x9f04,"get next character from BASIC source" \
	comment=0x9f06,"found digit" \
	comment=0x9f08,"get current character from BASIC source" \
	comment=0x9f0c,"BASIC source pointer" \
	comment=0x9f0e,"start of digits" \
	comment=0x9f10,"read line number & store in \$2b" \
	comment=0x9f13,"BASIC source pointer" \
	comment=0x9f17,"set carry if A is non-numeric character" \
	comment=0x9f1c,"end of digits" \
	comment=0x9f24,"exactly 5 digits" \
	comment=0x9f26,"less than 5 digits" \
	comment=0x9f2d,"move program down from U to X" \
	comment=0x9f34,"start of simple variables" \
	comment=0x9f3d,"start of simple variables" \
	comment=0x9f3f,"move memory contents up" \
	comment=0x9f44,"BASIC source pointer" \
	comment=0x9f46,"start of digits" \
	comment=0x9f4a,"replace line number with 5 byte info block" \
	comment=0x9f4c,"line number coded to avoid zeros" \
	comment=0x9f4e,"otherwise world would fall apart" \
	comment=0x9f64,"get current character from BASIC source" \
	comment=0x9f68,"comma - look for another line number" \
	comment=0x9f6c,"RENUM: convert line numbers into ASCII again (also flags UL errors)" \
	comment=0x9f6c,"start of BASIC program" \
	comment=0x9f74,"current line number" \
	comment=0x9f76,"test for end of program" \
	comment=0x9f7f,"end of line" \
	comment=0x9f82,"found an info block" \
	comment=0x9f8a,"/UL /" \
	comment=0x9f8d,"print string to DEVN" \
	comment=0x9f94,"print unsigned number in D" \
	comment=0x9f97,"print 'IN xxxx' (current line number)" \
	comment=0x9f9a,"send CR to DEVN" \
	comment=0x9fa1,"adjusted line number" \
	comment=0x9fa5,"assign contents of \$52 / \$53 to FPA1" \
	comment=0x9fa8,"convert FPA1 to string at \$3DA" \
	comment=0x9faf,"write line number into program" \
	comment=0x9fbd,"exactly 5 digits - no problem" \
	comment=0x9fc3,"move program down from U to X" \
	comment=0x9fca,"/UL /" \
	comment=0x9fce,"MEM continued" \
	comment=0x9fce,"end of BASIC storage" \
	comment=0x9fd0,"numeric / string flag" \
	comment=0x9fd4,"meaningless" \
	comment=0x9fd6,"assign contents of \$52 / \$53 to FPA1" \
	comment=0x9fd9,"unused" \
	comment=0xa000,"(\$A000 - \$BFFF)" \
	comment=0xa000,"indirect jump vectors" \
	comment=0xa000,"scan keyboard" \
	comment=0xa002,"output character to DEVN" \
	comment=0xa004,"read leader" \
	comment=0xa006,"read block" \
	comment=0xa008,"write block" \
	comment=0xa00a,"update joysticks" \
	comment=0xa00c,"write leader" \
	comment=0xa00e,"HEX\$" \
	comment=0xa00e,"read 16 bit number into X from FPA1 (& \$52)" \
	comment=0xa01b,"get a nibble into B" \
	comment=0xa024,"digit non-zero" \
	comment=0xa029,"at last digit" \
	comment=0xa02e,"don't store leading zeroes" \
	comment=0xa034,"not A - F" \
	comment=0xa041,"lose return address" \
	comment=0xa046,"register string at X" \
	comment=0xa049,"DLOAD" \
	comment=0xa049,"There is a logic bug in the serial system. The routines that call" \
	comment=0xa049,"the serial I/O drivers expect to see the Z flag set for success. The" \
	comment=0xa049,"serial drivers don't change the flags, however. Either re-write the" \
	comment=0xa049,"drivers for correct operation or skip the checks by changing BNE to" \
	comment=0xa049,"BRN at locations \$a13d, \$a16e & \$a1ab." \
	comment=0xa049,"close cassette stream & set DEVN to 0" \
	comment=0xa04e,"get current character from BASIC source" \
	comment=0xa056,"get next character from BASIC source" \
	comment=0xa058,"get filename" \
	comment=0xa05b,"get current character from BASIC source" \
	comment=0xa05f,"check comma" \
	comment=0xa066,"get number in B" \
	comment=0xa069,"select baud rate" \
	comment=0xa06c,"?FC ERROR" \
	comment=0xa070,"send filename & get 1st block" \
	comment=0xa077,"DEVN = -3" \
	comment=0xa07d,"DLOADM" \
	comment=0xa07f,"ensure nothing else on command line" \
	comment=0xa082,"B must not be 0" \
	comment=0xa083,"?FM ERROR" \
	comment=0xa085,"NEW BASIC" \
	comment=0xa088,"command mode / no device initialise" \
	comment=0xa08b,"?FM ERROR" \
	comment=0xa08e,"called by CLOAD to handle CLOADM" \
	comment=0xa08e,"cassette IO status" \
	comment=0xa090,"get next character from BASIC source" \
	comment=0xa092,"get filename" \
	comment=0xa095,"find file & set up buffer" \
	comment=0xa098,"gap flag" \
	comment=0xa09b,"continuous file" \
	comment=0xa09f,"U = file type & ASCII flag" \
	comment=0xa0a2,"DEVN" \
	comment=0xa0a4,"get block from tape" \
	comment=0xa0a9,"called by DLOAD to handle DLOADM" \
	comment=0xa0a9,"For both CLOADM & DLOADM, this is now a gapped binary file, with data" \
	comment=0xa0a9,"being read on a character by character basis. Note that data blocks do" \
	comment=0xa0a9,"not have to align with physical file blocks; the data is treated as a" \
	comment=0xa0a9,"continuous stream." \
	comment=0xa0a9,"Within the file data itself, the first byte is an end of file marker." \
	comment=0xa0a9,"Next 4 bytes are the data length and the load address, followed by the" \
	comment=0xa0a9,"data. This repeats until the end of file marker is true, whereupon" \
	comment=0xa0a9,"the final load address encountered becomes the EXEC address. There is" \
	comment=0xa0a9,"no data in the EOF block." \
	comment=0xa0ac,"?FM ERROR" \
	comment=0xa0ae,"zero" \
	comment=0xa0b0,"get current character from BASIC source" \
	comment=0xa0b4,"check comma" \
	comment=0xa0b7,"get 16 bit number into X" \
	comment=0xa0ba,"load offset" \
	comment=0xa0bc,"ensure nothing else on command line" \
	comment=0xa0bf,"read character from DEVN" \
	comment=0xa0c3,"read 2 characters from DEVN into D" \
	comment=0xa0c5,"Y = data length" \
	comment=0xa0c7,"read 2 characters from DEVN into D" \
	comment=0xa0cb,"default EXEC address" \
	comment=0xa0cd,"X = load address (inc. offset)" \
	comment=0xa0d1,"close DEVN stream & set DEVN to 0" \
	comment=0xa0d5,"read character from DEVN" \
	comment=0xa0d9,"checks that we are loading into RAM" \
	comment=0xa0db,"?IO ERROR" \
	comment=0xa0e3,"read 2 characters from DEVN into D" \
	comment=0xa0e5,"read character from DEVN" \
	comment=0xa0ea,"read character from device DEVN" \
	comment=0xa0ea,"(+cause error if EOF)" \
	comment=0xa0ed,"EOF flag" \
	comment=0xa0f1,"?IO ERROR" \
	comment=0xa0f4,"send filename & get 1st block" \
	comment=0xa0f4,"send filename to serial port" \
	comment=0xa0fb,"zero" \
	comment=0xa0fd,"get block from serial port" \
	comment=0xa101,"?NE ERROR" \
	comment=0xa106,"get block from serial port into IO buffer" \
	comment=0xa10c,"IO buffer" \
	comment=0xa10f,"get serial block & store at X" \
	comment=0xa112,"update IO buffer size / reset header address" \
	comment=0xa115,"send filename to serial port" \
	comment=0xa11c,"5 retries only" \
	comment=0xa120,"clear checksum, write, read & compare" \
	comment=0xa124,"filename" \
	comment=0xa129,"update checksum & write serial" \
	comment=0xa12c,"IO buffer" \
	comment=0xa12f,"filename now sent" \
	comment=0xa131,"send checksum & clear, read & compare #\$c8" \
	comment=0xa135,"read serial & update checksum" \
	comment=0xa13b,"read serial & update checksum" \
	comment=0xa141,"read serial, update checksum & load A" \
	comment=0xa149,"retry count - cause error if count reaches 5" \
	comment=0xa153,"write serial character" \
	comment=0xa156,"?IO ERROR" \
	comment=0xa159,"clear checksum, write serial, read & compare" \
	comment=0xa15b,"clear checksum, write serial & read" \
	comment=0xa163,"send checksum & clear, read & compare #\$c8" \
	comment=0xa165,"clear checksum, write serial & read" \
	comment=0xa16c,"read serial, update checksum & load A" \
	comment=0xa16c,"read serial & update checksum" \
	comment=0xa173,"read serial & update checksum" \
	comment=0xa173,"read serial character" \
	comment=0xa17e,"get block from serial & store starting at X" \
	comment=0xa18b,"5 retries only" \
	comment=0xa18f,"clear checksum, write, read & compare" \
	comment=0xa195,"update checksum & write serial" \
	comment=0xa199,"update checksum & write serial" \
	comment=0xa19b,"send checksum & clear, read & compare #\$c8" \
	comment=0xa19f,"read serial & update checksum" \
	comment=0xa1a9,"read serial & update checksum" \
	comment=0xa1b2,"read serial, update checksum & load A" \
	comment=0xa1ba,"clear checksum, write serial & read" \
	comment=0xa1be,"read serial character" \
	comment=0xa1c1,"update checksum & write serial" \
	comment=0xa1c9,"write serial character" \
	comment=0xa1cc,"handle ! (PRINT USING 1st character)" \
	comment=0xa1d1,"print a plus sign to DEVN if \$DA set" \
	comment=0xa1d4,"get current character from BASIC source" \
	comment=0xa1dc,"get expression" \
	comment=0xa1df,"validate string" \
	comment=0xa1e8,"perform left\$ of B chrs on varptr X" \
	comment=0xa1eb,"print string just compiled to DEVN" \
	comment=0xa1f9,"send a space to DEVN" \
	comment=0xa1fe,"handle % (PRINT USING string field)" \
	comment=0xa21d,"print a plus sign to DEVN if \$DA set" \
	comment=0xa220,"output character to DEVN" \
	comment=0xa225,"called by PRINT to handle USING" \
	comment=0xa225,"get expression" \
	comment=0xa228,"validate string" \
	comment=0xa22d,"skip semicolon" \
	comment=0xa232,"varptr of USING string" \
	comment=0xa238,"?FC ERROR" \
	comment=0xa23c,"comma counter?" \
	comment=0xa240,"USING string has a length" \
	comment=0xa242,"?FC ERROR" \
	comment=0xa245,"point X to USING string" \
	comment=0xa24f,"print 1st character" \
	comment=0xa255,"numeric field" \
	comment=0xa25a,"print a plus sign to DEVN if \$DA set" \
	comment=0xa25d,"output character to DEVN" \
	comment=0xa260,"get current character from BASIC source" \
	comment=0xa268,"send CR to DEVN" \
	comment=0xa26d,"point X to string & length in B" \
	comment=0xa274,"print a plus sign to DEVN if \$DA set" \
	comment=0xa324,"get current character from BASIC source" \
	comment=0xa335,"?FC ERROR" \
	comment=0xa33e,"print string to DEVN" \
	comment=0xa343,"get current character from BASIC source" \
	comment=0xa34d,"check comma" \
	comment=0xa352,"get next character from BASIC source" \
	comment=0xa366,"print a plus sign to DEVN if \$DA set" \
	comment=0xa36e,"output character to DEVN" \
	comment=0xa394,"FP constant 1000000000" \
	comment=0xa397,"compare FPA1 - varptr X (of same sign)" \
	comment=0xa39c,"convert FPA1 to string at \$3da" \
	comment=0xa3b7,"convert FPA1 to sig figs & exponent in \$47" \
	comment=0xa3cb,"print number to U (commas & point if reqd)" \
	comment=0xa420,"carry set if A non-numeric" \
	comment=0xa438,"carry clear if A is ASCII digit" \
	comment=0xa451,"divide FPA1 by 10" \
	comment=0xa48d,"print number to U (commas & point if reqd)" \
	comment=0xa4a1,"convert FPA1 to sig figs & exponent in \$47" \
	comment=0xa4c2,"divide FPA1 by 10" \
	comment=0xa4da,"print number to U (commas & point if reqd)" \
	comment=0xa55b,"convert FPA1 to sig figs & exponent in \$47" \
	comment=0xa566,"FP constant 1000000000" \
	comment=0xa569,"FPA1 = varptr X * FPA1" \
	comment=0xa572,"divide FPA1 by 10" \
	comment=0xa577,"FP constant 999999999" \
	comment=0xa57a,"compare FPA1 - varptr X (of same sign)" \
	comment=0xa57f,"FP constant 99999999.9" \
	comment=0xa582,"compare FPA1 - varptr X (of same sign)" \
	comment=0xa587,"multiply FPA1 by 10" \
	comment=0xa590,"print number to U (commas & point if reqd)" \
	comment=0xa592,"add 0.5 to FPA1" \
	comment=0xa595,"denormalize FPA1 to an integer" \
	comment=0xa59a,"powers of 10 table" \
	comment=0xa5e4,"store a comma if required" \
	comment=0xa61d,"get address of pixel calc routine for current PMODE" \
	comment=0xa620,"current PMODE" \
	comment=0xa626,"call relevant pixel calc routine for PMODE" \
	comment=0xa62a,"JMP table containing pixel calc routines for each PMODE" \
	comment=0xa634,"calculate pixel address & mask for 2 colour modes" \
	comment=0xa636,"bytes per line in current graphics mode" \
	comment=0xa63b,"start of current graphics" \
	comment=0xa650,"calculate pixel address & mask for 4 colour modes" \
	comment=0xa652,"bytes per line in current graphics mode" \
	comment=0xa657,"start of current graphics" \
	comment=0xa66b,"pixel mask table for 2 colour modes" \
	comment=0xa673,"pixel mask table for 4 colour modes" \
	comment=0xa677,"move X one line down for all PMODEs" \
	comment=0xa677,"bytes per line in current graphics mode" \
	comment=0xa67b,"pixel step routine for 2 colour PMODEs" \
	comment=0xa67b,"used by LINE" \
	comment=0xa682,"pixel step routine for 4 colour PMODEs" \
	comment=0xa682,"used by LINE" \
	comment=0xa68a,"read coordinates into \$bd & \$bf" \
	comment=0xa68a,"read pair of numbers into \$2b/\$2c & B" \
	comment=0xa6a8,"read coords into \$bd & \$bf and adjust for PMODE" \
	comment=0xa6a8,"read coordinates into \$bd & \$bf" \
	comment=0xa6ab,"adjust standard coords into true pixel coords" \
	comment=0xa6ae,"current PMODE" \
	comment=0xa6b4,"adjust Y for PMODEs 0 & 1" \
	comment=0xa6ba,"current PMODE" \
	comment=0xa6c0,"adjust X for PMODEs 0 to 3" \
	comment=0xa6c7,"PPOINT" \
	comment=0xa6c7,"get coords into \$bd / \$bf" \
	comment=0xa6ca,"adjust coords for PMODE" \
	comment=0xa6cd,"call relevant pixel calc routine for PMODE" \
	comment=0xa6d2,"current PMODE" \
	comment=0xa6e1,"current colour set" \
	comment=0xa6e6,"assign B to FPA1" \
	comment=0xa6ef,"PSET" \
	comment=0xa6f3,"PRESET" \
	comment=0xa6f4,"PRESET / PSET flag" \
	comment=0xa6f6,"skip open bracket" \
	comment=0xa6f9,"read coords into \$bd & \$bf and adjust" \
	comment=0xa6fc,"read optional colour" \
	comment=0xa6ff,"skip close bracket" \
	comment=0xa702,"call relevant pixel calc routine for PMODE" \
	comment=0xa705,"called by LINE to plot pixel" \
	comment=0xa70e,"byte value of plot colour" \
	comment=0xa71d,"reads coordinate pair into \$bd / \$bf & \$c3 / \$c5" \
	comment=0xa71d,"if first pair is missing then current coords are used" \
	comment=0xa725,"token -" \
	comment=0xa731,"skip open bracket" \
	comment=0xa734,"read pair of numbers into \$2b/\$2c & B" \
	comment=0xa73e,"skip close bracket" \
	comment=0xa740,"read coordinates inside brackets" \
	comment=0xa740,"(into \$bd & \$bf)" \
	comment=0xa740,"skip open bracket" \
	comment=0xa743,"read coordinates into \$bd & \$bf" \
	comment=0xa746,"skip close bracket" \
	comment=0xa749,"LINE" \
	comment=0xa749,"token INPUT" \
	comment=0xa74b,"LINE INPUT" \
	comment=0xa753,"token -" \
	comment=0xa759,"optional @ before coords" \
	comment=0xa75c,"sets up \$bd/\$bf & \$c3/\$c5" \
	comment=0xa75f,"with coords" \
	comment=0xa767,"check comma" \
	comment=0xa76a,"token PRESET" \
	comment=0xa76e,"token PSET" \
	comment=0xa770,"?SN ERROR" \
	comment=0xa778,"(A777 5F         CLRB)" \
	comment=0xa77a,"get next character from BASIC source" \
	comment=0xa77c,"adjust coords for PMODE" \
	comment=0xa781,"PRESET / PSET flag" \
	comment=0xa783,"set up current colour" \
	comment=0xa786,"get current character from BASIC source" \
	comment=0xa788,"must be a normal line" \
	comment=0xa78c,"check comma" \
	comment=0xa791,"check for 'B'" \
	comment=0xa796,"draw empty rectangle" \
	comment=0xa7ae,"adjust line's coords for current PMODE" \
	comment=0xa7b7,"only 'F' allowed after 'B'" \
	comment=0xa7c2,"draw a solid rectangle" \
	comment=0xa7c2,"draw horizontal line" \
	comment=0xa7cb,"next Y up or down?" \
	comment=0xa7d2,"draw horizontal line from left to right" \
	comment=0xa7d6,"calc +ve difference in x ords" \
	comment=0xa7dd,"store lower of two values for calc" \
	comment=0xa7e3,"calc pixel" \
	comment=0xa7ea,"get address of pixel stepper in U" \
	comment=0xa7ec,"store pixel mask" \
	comment=0xa7ee,"plot" \
	comment=0xa7f3,"next pixel" \
	comment=0xa7fa,"jumped from general line routine" \
	comment=0xa7fc,"draw vertical line downwards" \
	comment=0xa800,"+ve difference in Y ords" \
	comment=0xa80d,"call relevant pixel calc routine for PMODE" \
	comment=0xa818,"table of addresses of pixel step routines according to PMODE" \
	comment=0xa822,"get address of pixel step routine according to PMODE" \
	comment=0xa825,"current PMODE" \
	comment=0xa82b,"set U up with address of vertical pixel stepper" \
	comment=0xa82f,"draw general line" \
	comment=0xa82f,"increment Y ord" \
	comment=0xa833,"+ve difference in Y ords" \
	comment=0xa836,"horizontal line" \
	comment=0xa83a,"draw left to right" \
	comment=0xa83c,"decrement Y ord" \
	comment=0xa842,"increment X ord" \
	comment=0xa845,"+ve difference in X ords" \
	comment=0xa848,"vertical line" \
	comment=0xa84a,"draw top to bottom" \
	comment=0xa84c,"decrement X ord" \
	comment=0xa854,"delta X >= delta Y" \
	comment=0xa856,"get main stepper in U" \
	comment=0xa858,"get larger delta in D" \
	comment=0xa85e,"make initial total 1/2 of large" \
	comment=0xa85f,"delta for equal end segments" \
	comment=0xa860,"large delta was odd" \
	comment=0xa866,"main stepper is in +ve direction" \
	comment=0xa868,"mystery tweak" \
	comment=0xa86d,"get pixel calc in U" \
	comment=0xa872,"plot" \
	comment=0xa87b,"dec counter" \
	comment=0xa87d,"step pixel in main direction" \
	comment=0xa882,"add small delta" \
	comment=0xa884,"to total" \
	comment=0xa886,"subtract larger delta" \
	comment=0xa888,"threshold not reached" \
	comment=0xa88c,"step pixel in lesser direction" \
	comment=0xa894,"increment X ord (LINE / PAINT)" \
	comment=0xa89b,"increment Y ord (LINE)" \
	comment=0xa8a2,"decrement X ord (LINE / PAINT)" \
	comment=0xa8a9,"decrement Y ord (LINE)" \
	comment=0xa8b0,"sets up \$d3 / \$d5 with max coords adjusted for PMODE" \
	comment=0xa8c0,"PCLS" \
	comment=0xa8c7,"start of current graphics" \
	comment=0xa8cb,"1st byte after current graphics" \
	comment=0xa8d0,"current background colour" \
	comment=0xa8d4,"COLOR" \
	comment=0xa8da,"current foreground colour" \
	comment=0xa8dc,"get current character from BASIC source" \
	comment=0xa8e0,"check comma" \
	comment=0xa8e5,"current background colour" \
	comment=0xa8e8,"read number and interpret as colour" \
	comment=0xa8e8,"(returns 0 - 3)" \
	comment=0xa8e8,"get number in B" \
	comment=0xa8ed,"?FC ERROR" \
	comment=0xa8fc,"current PMODE" \
	comment=0xa90f,"read optional colour & set up \$b5 accordingly" \
	comment=0xa90f,"set up colours" \
	comment=0xa912,"get current character from BASIC source" \
	comment=0xa91a,"check comma" \
	comment=0xa926,"get current character from BASIC source" \
	comment=0xa928,"stores either foreground or background colour" \
	comment=0xa928,"as current depending on plot flag \$c2" \
	comment=0xa928,"current foreground colour" \
	comment=0xa92a,"PRESET / PSET flag" \
	comment=0xa92e,"current background colour" \
	comment=0xa930,"plot colour" \
	comment=0xa935,"byte value of plot colour" \
	comment=0xa938,"called by SCREEN: sets up text or graphics according to Z" \
	comment=0xa93a,"reset VDU" \
	comment=0xa95d,"set up graphics display" \
	comment=0xa95f,"current PMODE" \
	comment=0xa968,"current colour set" \
	comment=0xa976,"start of current graphics" \
	comment=0xa979,"set up SAM VDG base" \
	comment=0xa97c,"current PMODE" \
	comment=0xa985,"set up SAM VDG mem mode" \
	comment=0xa989,"set up SAM VDG mode" \
	comment=0xa99d,"set up VDG offset" \
	comment=0xa9a4,"select VDG colour set" \
	comment=0xa9a9,"current colour set" \
	comment=0xa9af,"PMODE" \
	comment=0xa9b3,"get number in B" \
	comment=0xa9b8,"?FC ERROR" \
	comment=0xa9ba,"MSB of start of graphics page 1" \
	comment=0xa9bc,"start of current graphics" \
	comment=0xa9bf,"PMODE setup table + 1" \
	comment=0xa9c4,"start of BASIC program" \
	comment=0xa9c6,"?FC ERROR" \
	comment=0xa9c8,"1st byte after current graphics" \
	comment=0xa9ce,"bytes per line in current graphics mode" \
	comment=0xa9d1,"current PMODE" \
	comment=0xa9d4,"current background colour" \
	comment=0xa9d8,"current foreground colour" \
	comment=0xa9da,"get current character from BASIC source" \
	comment=0xa9dc,"RTS" \
	comment=0xa9de,"skip comma & get number in B" \
	comment=0xa9e2,"?FC ERROR" \
	comment=0xa9e8,"MSB of start of graphics page 1" \
	comment=0xa9ec,"1st byte after current graphics" \
	comment=0xa9ee,"start of current graphics" \
	comment=0xa9f0,"start of BASIC program" \
	comment=0xa9f2,"?FC ERROR" \
	comment=0xa9f4,"1st byte after current graphics" \
	comment=0xa9f8,"start of current graphics" \
	comment=0xa9fb,"?FC ERROR" \
	comment=0xa9fe,"SCREEN" \
	comment=0xaa02,"get number in B" \
	comment=0xaa09,"get current character from BASIC source" \
	comment=0xaa0d,"skip comma & get number in B" \
	comment=0xaa15,"current colour set" \
	comment=0xaa19,"PCLEAR" \
	comment=0xaa19,"get number in B" \
	comment=0xaa1d,"?FC ERROR" \
	comment=0xaa21,"?FC ERROR" \
	comment=0xaa26,"MSB of start of graphics page 1" \
	comment=0xaa2e,"1st byte after current graphics" \
	comment=0xaa31,"?FC ERROR" \
	comment=0xaa35,"start of BASIC program" \
	comment=0xaa37,"start of simple variables" \
	comment=0xaa3e,"stack root / string storage start" \
	comment=0xaa40,"?FC ERROR" \
	comment=0xaa42,"current line number" \
	comment=0xaa49,"start of BASIC program" \
	comment=0xaa4b,"BASIC source pointer" \
	comment=0xaa4f,"start of simple variables" \
	comment=0xaa5c,"start of BASIC program" \
	comment=0xaa61,"start of BASIC program" \
	comment=0xaa66,"set up next line pointers in BASIC program" \
	comment=0xaa69,"clear variables & reset stack" \
	comment=0xaa6c,"interpreter loop" \
	comment=0xaa6f,"start of BASIC program" \
	comment=0xaa7a,"start of simple variables" \
	comment=0xaa81,"called by reset routine to PCLEAR 4" \
	comment=0xaa83,"start of BASIC program" \
	comment=0xaa87,"MSB of start of graphics page 1" \
	comment=0xaa89,"start of current graphics" \
	comment=0xaa8c,"current PMODE" \
	comment=0xaa90,"bytes per line in current graphics mode" \
	comment=0xaa94,"current foreground colour" \
	comment=0xaa98,"1st byte after current graphics" \
	comment=0xaa9a,"start of BASIC program" \
	comment=0xaa9e,"NEW BASIC" \
	comment=0xaaa1,"PMODE setup table: bytes/line + MSB of display size" \
	comment=0xaaab,"calc +ve difference in Y ords" \
	comment=0xaab3,"D = -D" \
	comment=0xaab8,"calc +ve difference in X ords" \
	comment=0xaabe,"PCOPY" \
	comment=0xaac4,"check for token TO" \
	comment=0xaada,"converts number into graphics page address" \
	comment=0xaada,"get number in B" \
	comment=0xaade,"?FC ERROR" \
	comment=0xaae4,"MSB of start of graphics page 1" \
	comment=0xaae6,"page address must be lower" \
	comment=0xaae8,"than BASIC program" \
	comment=0xaaed,"?FC ERROR" \
	comment=0xaaf0,"notes concerning GET & PUT:" \
	comment=0xaaf0,"when G is not specified for GET, whole bytes are transferred from the" \
	comment=0xaaf0,"screen to the array. The effective width will therefore be a multiple" \
	comment=0xaaf0,"of 8. Using such an array, PUT with no action will only display correctly" \
	comment=0xaaf0,"on byte boundaries. (although it will be fast)" \
	comment=0xaaf0,"If G is specified for GET then screen bits are packed into the array." \
	comment=0xaaf0,"PUT with no action will only work if the array image width is a multiple" \
	comment=0xaaf0,"of 8 and then only on a screen byte boundary." \
	comment=0xaaf0,"PUT with an action works as long as the effective array image width is" \
	comment=0xaaf0,"observed in the first case of GET. In the second case, the precise width" \
	comment=0xaaf0,"is used as expected." \
	comment=0xaaf0,"GET" \
	comment=0xaaf3,"PUT" \
	comment=0xaaf7,"PATCH - CLS GET PUT" \
	comment=0xaafc,"optional @ before coords" \
	comment=0xaafe,"get next character from BASIC source" \
	comment=0xab00,"get coords into \$bd/\$bf & \$c3/\$c5" \
	comment=0xab03,"check comma" \
	comment=0xab06,"validate & get varptr of array" \
	comment=0xab11,"address of last byte of array+1" \
	comment=0xab15,"no. of dimensions" \
	comment=0xab19,"address of first byte of array" \
	comment=0xab1b,"string arrays not allowed" \
	comment=0xab1d,"?FC ERROR" \
	comment=0xab21,"get current character from BASIC source" \
	comment=0xab23,"no parameter after array" \
	comment=0xab27,"check comma" \
	comment=0xab2c,"PUT" \
	comment=0xab30,"skip G" \
	comment=0xab33,"GET ,G" \
	comment=0xab3a,"set up action routines for PUT" \
	comment=0xab46,"?SN ERROR" \
	comment=0xab4e,"get next character from BASIC source" \
	comment=0xab52,"bytewise GET / PUT" \
	comment=0xab54,"current PMODE" \
	comment=0xab57,"2 colour modes" \
	comment=0xab5d,"adjust horizontal coords to align with bytes" \
	comment=0xab65,"calc +ve difference in x ords" \
	comment=0xab68,"1st is less than 2nd" \
	comment=0xab6e,"x ord difference" \
	comment=0xab70,"+ve difference in Y ords" \
	comment=0xab73,"1st is less than 2nd" \
	comment=0xab79,"y ord difference" \
	comment=0xab7b,"current PMODE" \
	comment=0xab80,"2 colour modes" \
	comment=0xab86,"adjust coords for PMODE" \
	comment=0xab8f,"add 1 to y difference to get height" \
	comment=0xab93,"action specified" \
	comment=0xab9e,"width of image in bytes" \
	comment=0xaba0,"call relevant pixel calc routine for PMODE" \
	comment=0xaba9,"GET" \
	comment=0xabab,"increment array pointer (U)" \
	comment=0xabb2,"repeat until line done" \
	comment=0xabb6,"move X one line down for all PMODEs" \
	comment=0xabbb,"another line" \
	comment=0xabbe,"increment array pointer (U)" \
	comment=0xabc7,"RTS" \
	comment=0xabc9,"?FC ERROR" \
	comment=0xabcc,"action for GET without G parameter" \
	comment=0xabce,"increment array pointer (U)" \
	comment=0xabd4,"PUT action JMP table" \
	comment=0xabd4,"action for a clear array bit / action for a set array bit / token" \
	comment=0xabd4,"PSET" \
	comment=0xabd9,"PRESET" \
	comment=0xabde,"OR" \
	comment=0xabe3,"AND" \
	comment=0xabe8,"NOT" \
	comment=0xabed,"GET(G) & PUT(action) - does it bitwise" \
	comment=0xabf0,"width of image in bits" \
	comment=0xabf4,"PUT" \
	comment=0xabf8,"clear array for GET" \
	comment=0xabff,"call relevant pixel calc routine for PMODE" \
	comment=0xac02,"current PMODE" \
	comment=0xac05,"2 colour modes" \
	comment=0xac07,"reduce mask to single bit" \
	comment=0xac10,"U = image width in bits" \
	comment=0xac14,"step array bit pointer" \
	comment=0xac17,"B = \$80" \
	comment=0xac18,"filled an array byte, so point to next one" \
	comment=0xac1a,"test for end of array" \
	comment=0xac1d,"?FC ERROR" \
	comment=0xac21,"GET" \
	comment=0xac23,"test array bit" \
	comment=0xac27,"action if array bit set" \
	comment=0xac2b,"action if array bit clear" \
	comment=0xac2f,"action for PSET 0, PRESET 1, AND 0" \
	comment=0xac32,"clear screen bit" \
	comment=0xac34,"next bit" \
	comment=0xac36,"action for PSET 1, PRESET 0, OR 1" \
	comment=0xac38,"set screen bit" \
	comment=0xac3a,"next bit" \
	comment=0xac3c,"action for NOT 0, NOT 1" \
	comment=0xac3e,"invert screen bit" \
	comment=0xac40,"next bit" \
	comment=0xac42,"GET bit" \
	comment=0xac42,"test screen bit" \
	comment=0xac44,"don't set array bit - next pixel" \
	comment=0xac4a,"set array bit" \
	comment=0xac4c,"next bit (also action for OR 0, AND 1)" \
	comment=0xac4c,"pixel mask & width counter" \
	comment=0xac4e,"step bit one to right" \
	comment=0xac53,"zero" \
	comment=0xac56,"not end of line" \
	comment=0xac5a,"bytes per line in current graphics mode" \
	comment=0xac5c,"point X to next line" \
	comment=0xac64,"do another line" \
	comment=0xac67,"called by GET / PUT: get varptr for specified array" \
	comment=0xac67,"get varptr address" \
	comment=0xac6e,"get variable name in U" \
	comment=0xac74,"?FC ERROR" \
	comment=0xac78,"search array storage to ensure" \
	comment=0xac7b,"that specified variable is an" \
	comment=0xac7d,"array" \
	comment=0xac83,"varptr" \
	comment=0xac87,"PAINT" \
	comment=0xac89,"optional @ before coords" \
	comment=0xac8b,"get next character from BASIC source" \
	comment=0xac8d,"get coords into \$bd / \$bf" \
	comment=0xac90,"adjust coords for PMODE" \
	comment=0xac95,"PRESET / PSET flag" \
	comment=0xac97,"read optional colour" \
	comment=0xac9a,"plot colour" \
	comment=0xac9e,"get current character from BASIC source" \
	comment=0xaca2,"read optional colour" \
	comment=0xaca5,"byte value of plot colour" \
	comment=0xacab,"plot colour" \
	comment=0xacb0,"set up max coords for PMODE" \
	comment=0xacb3,"get address of pixel calc routine" \
	comment=0xacb6,"pixel calc" \
	comment=0xacb8,"paint left & count pixels in U, D & X" \
	comment=0xacbb,"none painted" \
	comment=0xacbd,"paint right after previous left" \
	comment=0xacc4,"save pos on stack" \
	comment=0xacc9,"save pos on stack" \
	comment=0xaccf,"(main loop)" \
	comment=0xacd1,"pixels were painted on previous line" \
	comment=0xacd8,"pixel changed flag (updated by plot)" \
	comment=0xacdf,"current x pos" \
	comment=0xace1,"no. of pixels painted on previous line" \
	comment=0xace3,"up / down flag" \
	comment=0xace5,"RTS - pulled final stack entry" \
	comment=0xace7,"paint up" \
	comment=0xacec,"not off bottom of screen" \
	comment=0xacf0,"at top/bottom of screen" \
	comment=0xacf5,"paint left & count pixels in U, D & X" \
	comment=0xacf8,"none painted" \
	comment=0xacfe,"only 1 or 2 pixels painted" \
	comment=0xad02,"save pos on stack with reverse direction" \
	comment=0xad04,"paint right after previous left" \
	comment=0xad07,"save pos on stack" \
	comment=0xad11,"increment X ord" \
	comment=0xad14,"calc pixel & test for border colour" \
	comment=0xad1e,"decrement X ord" \
	comment=0xad21,"copy X ord to \$c3" \
	comment=0xad23,"paint right & count pixels in U, D & X" \
	comment=0xad27,"increment X ord" \
	comment=0xad37,"save pos on stack with reverse direction" \
	comment=0xad39,"loop again" \
	comment=0xad3c,"save pos with reverse direction" \
	comment=0xad4f,"memory check" \
	comment=0xad55,"save pos on stack" \
	comment=0xad61,"copy X ord to \$c3" \
	comment=0xad66,"paint right after previous left" \
	comment=0xad66,"X = total no. of pixels painted left & right" \
	comment=0xad66,"D = no. of pixels painted right + 1" \
	comment=0xad6b,"copy X ord to \$c3" \
	comment=0xad70,"paint right & count pixels in U, D & X" \
	comment=0xad7a,"paint left & return pixel count in U, D & X" \
	comment=0xad7a,"copy X ord to \$c3" \
	comment=0xad7d,"decrement X ord" \
	comment=0xad83,"paint right & return pixel count in U, D & X" \
	comment=0xad83,"increment X ord" \
	comment=0xad87,"step X ord" \
	comment=0xad89,"zero" \
	comment=0xad8d,"< min X" \
	comment=0xad91,"> max X" \
	comment=0xad95,"calc pixel & test for border colour" \
	comment=0xad99,"plot" \
	comment=0xada0,"step X ord" \
	comment=0xadaa,"CMPD #0" \
	comment=0xadad,"calc pixel & test for border colour" \
	comment=0xadad,"pixel calc" \
	comment=0xadbd,"PLAY" \
	comment=0xadbd,"zero" \
	comment=0xadc3,"get expression" \
	comment=0xadc7,"B=0 to select d/a sound" \
	comment=0xadca,"enable audio" \
	comment=0xadcd,"validate string & point X to it (len in B)" \
	comment=0xadd4,"string length" \
	comment=0xadd8,"1st byte in string" \
	comment=0xadda,"nothing to do - disable audio & quit" \
	comment=0xadde,"remaining string length" \
	comment=0xade2,"get character" \
	comment=0xadef,"execute substring" \
	comment=0xadf3,"interpret meta-command" \
	comment=0xadf7,"change octave" \
	comment=0xadfb,"PLAY octave" \
	comment=0xadfe,"modify B according to PLAY parameter" \
	comment=0xae03,"?FC ERROR" \
	comment=0xae05,"PLAY octave" \
	comment=0xae08,"change volume" \
	comment=0xae0c,"PLAY d/a high value" \
	comment=0xae12,"modify B according to PLAY parameter" \
	comment=0xae16,"?FC ERROR" \
	comment=0xae23,"PLAY volume data" \
	comment=0xae26,"change note length" \
	comment=0xae2a,"PLAY note length" \
	comment=0xae2c,"modify B according to PLAY parameter" \
	comment=0xae2f,"?FC ERROR" \
	comment=0xae31,"PLAY note length" \
	comment=0xae33,"duration modifier (no. of dots)" \
	comment=0xae3a,"remaining string length" \
	comment=0xae3e,"get character" \
	comment=0xae45,"move string pointer back one" \
	comment=0xae4a,"duration modifier (no. of dots)" \
	comment=0xae4d,"change tempo" \
	comment=0xae51,"PLAY tempo" \
	comment=0xae53,"modify B according to PLAY parameter" \
	comment=0xae56,"?FC ERROR" \
	comment=0xae58,"PLAY tempo" \
	comment=0xae5b,"change a PLAY parameter (modifies value in B)" \
	comment=0xae5e,"play a pause" \
	comment=0xae62,"check for number or =variable (get into B)" \
	comment=0xae68,"?FC ERROR" \
	comment=0xae6b,"duration modifier (no. of dots)" \
	comment=0xae6d,"PLAY volume data" \
	comment=0xae73,"PLAY d/a high value" \
	comment=0xae75,"PLAY d/a low value" \
	comment=0xae77,"duration modifier (no. of dots)" \
	comment=0xae7d,"duration modifier (no. of dots)" \
	comment=0xae7f,"PLAY volume data" \
	comment=0xae86,"ignore an N!" \
	comment=0xae8a,"get character" \
	comment=0xae95,"check for number or =variable (get into B)" \
	comment=0xae9c,"note number XLAT table" \
	comment=0xae9f,"XLAT into number" \
	comment=0xaea1,"remaining string length" \
	comment=0xaea5,"get character" \
	comment=0xaeb0,"sharpen note" \
	comment=0xaeb7,"flatten note" \
	comment=0xaeba,"move string pointer back one" \
	comment=0xaec0,"?FC ERROR" \
	comment=0xaec4,"PLAY note length" \
	comment=0xaec6,"PLAY tempo" \
	comment=0xaec9,"PLAY duration decrement value" \
	comment=0xaecb,"point U to return address (\$ADF5)" \
	comment=0xaecd,"PLAY octave" \
	comment=0xaed3,"pitch XLAT table for octaves 1 & 2" \
	comment=0xaede,"XLAT note for octaves 1 & 2" \
	comment=0xaee0,"compute PLAY duration" \
	comment=0xaee2,"PLAY duration counter" \
	comment=0xaee4,"zero d/a" \
	comment=0xaee6,"PLAY d/a high value" \
	comment=0xaee8,"set d/a" \
	comment=0xaeea,"zero d/a" \
	comment=0xaeec,"PLAY d/a low value" \
	comment=0xaeee,"set d/a" \
	comment=0xaef0,"irq routine controls duration" \
	comment=0xaef2,";forces jump to \$adf5" \
	comment=0xaeff,"XLAT table for octaves 3 - 5 (-\$18)" \
	comment=0xaf08,"XLAT note for octaves 3 - 5" \
	comment=0xaf09,"compute PLAY duration" \
	comment=0xaf0b,"PLAY duration counter" \
	comment=0xaf0d,"zero d/a" \
	comment=0xaf0f,"PLAY d/a high value" \
	comment=0xaf11,"set d/a" \
	comment=0xaf13,"zero d/a" \
	comment=0xaf15,"PLAY d/a low value" \
	comment=0xaf17,"set d/a" \
	comment=0xaf19,"irq routine controls duration" \
	comment=0xaf1b,";forces jump to \$adf5" \
	comment=0xaf27,"compute PLAY duration" \
	comment=0xaf29,"duration modifier (no. of dots)" \
	comment=0xaf33,"get next character in string, skipping over spaces" \
	comment=0xaf33,"(called by PLAY & DRAW)" \
	comment=0xaf35,"remaining string length" \
	comment=0xaf39,"string pointer" \
	comment=0xaf3d,"string pointer" \
	comment=0xaf3f,"remaining string length" \
	comment=0xaf47,"change a PLAY parameter (modifies value in B)" \
	comment=0xaf47,"get character" \
	comment=0xaf49,"inc" \
	comment=0xaf4d,"dec" \
	comment=0xaf51,"double" \
	comment=0xaf55,"halve" \
	comment=0xaf59,"equals a variable" \
	comment=0xaf5d,"carry set if A non-numeric" \
	comment=0xaf60,"?FC ERROR" \
	comment=0xaf6b,"?FC ERROR" \
	comment=0xaf6f,"?FC ERROR" \
	comment=0xaf71,"remaining string length" \
	comment=0xaf75,"get character" \
	comment=0xaf78,"carry set if A non-numeric" \
	comment=0xaf7d,"remaining string length" \
	comment=0xaf7f,"string pointer" \
	comment=0xaf83,"string pointer" \
	comment=0xaf86,"?FC ERROR" \
	comment=0xaf89,"increment PLAY parameter" \
	comment=0xaf8a,"?FC ERROR" \
	comment=0xaf8d,"decrement PLAY parameter" \
	comment=0xaf8e,"?FC ERROR" \
	comment=0xaf92,"halve PLAY parameter" \
	comment=0xaf93,"?FC ERROR" \
	comment=0xaf97,"double PLAY parameter" \
	comment=0xaf98,"?FC ERROR" \
	comment=0xaf9c,"PLAY parameter equals a variable" \
	comment=0xaf9e,"validate variable" \
	comment=0xafa0,"get number in B from FPA1" \
	comment=0xafa5,"execute PLAY substring" \
	comment=0xafa5,"validate variable" \
	comment=0xafaa,"memory check" \
	comment=0xafad,"remaining string length" \
	comment=0xafaf,"string pointer" \
	comment=0xafb6,"validate PLAY / DRAW variable" \
	comment=0xafb6,"string pointer" \
	comment=0xafba,"get character" \
	comment=0xafbd,"carry clear if A-Z" \
	comment=0xafc0,"?FC ERROR" \
	comment=0xafc2,"get character" \
	comment=0xafcb,"BASIC source pointer" \
	comment=0xafcf,"BASIC source pointer" \
	comment=0xafd6,"BASIC source pointer" \
	comment=0xafd9,"IRQ service routine continued" \
	comment=0xafdc,"PLAY duration counter" \
	comment=0xafe2,"must be in PLAY loop" \
	comment=0xafe4,"therefore calculate" \
	comment=0xafe6,"duration remaining" \
	comment=0xafe8,"PLAY duration counter" \
	comment=0xafee,"points S to old U (=\$adf5)" \
	comment=0xaff1,"mask entire state save" \
	comment=0xaff3,"RTI will now return to \$adf5" \
	comment=0xaff6,"PLAY letter to note number XLAT table" \
	comment=0xaffd,"PLAY pitch XLAT table for octaves 1 & 2" \
	comment=0xb02d,"PLAY pitch XLAT table for octaves 3 - 5" \
	comment=0xb051,"DRAW" \
	comment=0xb051,"zero" \
	comment=0xb057,"PRESET / PSET flag" \
	comment=0xb05b,"set up colours" \
	comment=0xb05e,"get expression" \
	comment=0xb061,"validate string & point X to it (len in B)" \
	comment=0xb066,"get character" \
	comment=0xb069,"check for number or =variable (get into B)" \
	comment=0xb06e,"remaining string length" \
	comment=0xb072,"string pointer" \
	comment=0xb074,"nothing left to do - RTS" \
	comment=0xb078,"remaining string length" \
	comment=0xb07c,"get character" \
	comment=0xb0a7,"remaining string length" \
	comment=0xb0ab,"get character" \
	comment=0xb0ae,"carry clear if A-Z" \
	comment=0xb0b3,"move string pointer back one" \
	comment=0xb0ba,"check for number or =variable (get into B)" \
	comment=0xb0e7,"?FC ERROR" \
	comment=0xb0ea,"DRAW 'C'" \
	comment=0xb0ea,"interpret colour in B" \
	comment=0xb0ed,"foreground colour" \
	comment=0xb0ef,"set up colours" \
	comment=0xb0f4,"DRAW 'A'" \
	comment=0xb0f6,"?FC ERROR" \
	comment=0xb0f8,"angle" \
	comment=0xb0fc,"DRAW 'S'" \
	comment=0xb0fe,"?FC ERROR" \
	comment=0xb100,"scale" \
	comment=0xb104,"DRAW 'H'    (D = X = -B)" \
	comment=0xb105,"NEGB, A=A-C" \
	comment=0xb109,"DRAW 'F'    (D = X = B)" \
	comment=0xb109,"(B108 4F         CLRA)" \
	comment=0xb10d,"DRAW 'E'    (D = B, X = -B)" \
	comment=0xb110,"NEGB, A=A-C" \
	comment=0xb116,"DRAW 'G'    (D = -B, X = B)" \
	comment=0xb119,"NEGB, A=A-C" \
	comment=0xb11d,"DRAW 'R'    (D = B, X = 0)" \
	comment=0xb11e,"zero" \
	comment=0xb122,"DRAW 'L'    (D = -B, X = 0)" \
	comment=0xb123,"NEGB, A=A-C" \
	comment=0xb127,"DRAW 'D'    (D = 0, X = B)" \
	comment=0xb12a,"DRAW 'U'    (D = 0, X = -B)" \
	comment=0xb12b,"NEGB, A=A-C" \
	comment=0xb12d,"zero" \
	comment=0xb133,"DRAW 'X'" \
	comment=0xb133,"validate variable" \
	comment=0xb138,"memory check" \
	comment=0xb13b,"remaining string length" \
	comment=0xb13d,"string pointer" \
	comment=0xb13f,"store current string" \
	comment=0xb141,"start again with new string" \
	comment=0xb144,"apply DRAW scale factor to X" \
	comment=0xb14f,"D = -D" \
	comment=0xb151,"Y:U = D * X" \
	comment=0xb166,"apply scale & angle to relative movement vector in D & X," \
	comment=0xb166,"calculate new pos & draw." \
	comment=0xb166,"(D = horizontal component, X = vertical component)" \
	comment=0xb168,"scale X into D" \
	comment=0xb16e,"scale X into D" \
	comment=0xb172,"angle" \
	comment=0xb17b,"swap vector components" \
	comment=0xb17d,"D = -D" \
	comment=0xb181,"rotate another 90 degrees" \
	comment=0xb185,"zero" \
	comment=0xb187,"current X" \
	comment=0xb18b,"U = new X" \
	comment=0xb18f,"zero" \
	comment=0xb191,"current Y" \
	comment=0xb1a5,"X = new Y" \
	comment=0xb1b6,"no position update" \
	comment=0xb1bc,"adjust coords for PMODE" \
	comment=0xb1c1,"blank move" \
	comment=0xb1c3,"draw line" \
	comment=0xb1cd,"DRAW 'M'" \
	comment=0xb1cd,"get character" \
	comment=0xb1d2,"get ordinate into D" \
	comment=0xb1d7,"get character" \
	comment=0xb1e0,"get ordinate into D" \
	comment=0xb1ef,"absolute position" \
	comment=0xb1f3,"relative movement" \
	comment=0xb1f6,"get ordinate for Move" \
	comment=0xb1f6,"get character" \
	comment=0xb201,"move string pointer back one" \
	comment=0xb207,"check for number or =variable (get into B)" \
	comment=0xb214,"CIRCLE trig factor look-up table" \
	comment=0xb214,"circle is drawn in 8 main sectors with 8 or 9 subdivisions each" \
	comment=0xb238,"CIRCLE" \
	comment=0xb23a,"optional @ before coords" \
	comment=0xb23c,"get next character from BASIC source" \
	comment=0xb23e,"set up max coords for PMODE" \
	comment=0xb241,"get coords from command into \$bd / \$bf" \
	comment=0xb244,"adjust coords for PMODE" \
	comment=0xb24f,"check comma" \
	comment=0xb252,"get 16 bit number into X" \
	comment=0xb258,"circle radius" \
	comment=0xb25a,"adjust radius correct for PMODE" \
	comment=0xb25f,"PRESET / PSET flag" \
	comment=0xb261,"read optional colour" \
	comment=0xb267,"get current character from BASIC source" \
	comment=0xb26b,"check comma" \
	comment=0xb26e,"get FP number (h/w ratio)" \
	comment=0xb275,"multiply FP number by 256" \
	comment=0xb277,"read 16 bit number into X from FPA1" \
	comment=0xb27a,"current PMODE" \
	comment=0xb282,"double hw ratio for PMODEs 2 & 3" \
	comment=0xb288,"PRESET / PSET flag" \
	comment=0xb28c,"read optional start value" \
	comment=0xb291,"read optional end value" \
	comment=0xb298,"loop starts here" \
	comment=0xb29a,"move old end coords to start coords" \
	comment=0xb2aa,"B = 8-B for odd sectors" \
	comment=0xb2b2,"X= (,U) x radius" \
	comment=0xb2bb,"X= (,U) x radius" \
	comment=0xb2be,"X & Y now hold circle coord offsets" \
	comment=0xb2ca,"swap X & Y for sectors 1,2,5,6" \
	comment=0xb2cc,"x offset" \
	comment=0xb2d2,"Y:U = D * X" \
	comment=0xb2d5,"D = hw ratio x y ord" \
	comment=0xb2d8,"?FC ERROR" \
	comment=0xb2dc,"MSB of y offset" \
	comment=0xb2e0,"LSB of y offset" \
	comment=0xb2ee,"x = centre - offset" \
	comment=0xb2f0,"for sectors 2,3,4,5" \
	comment=0xb2f2,"keep on screen" \
	comment=0xb2f8,"x = centre + offset" \
	comment=0xb2fa,"for sectors 0,1,6,7" \
	comment=0xb2fc,"keep on screen" \
	comment=0xb303,"circle x ord now calculated" \
	comment=0xb30d,"y = centre - offset" \
	comment=0xb30f,"for sectors 4,5,6,7" \
	comment=0xb311,"keep on screen" \
	comment=0xb317,"y = centre + offset" \
	comment=0xb319,"for sectors 0,1,2,3" \
	comment=0xb31b,"keep on screen" \
	comment=0xb322,"circle y ord now calculated" \
	comment=0xb326,"1st loop - don't draw" \
	comment=0xb328,"draw line (\$bd,\$bf)-(\$c3,\$c5)" \
	comment=0xb32e,"1st loop - don't test end condition" \
	comment=0xb330,"reached end angle?" \
	comment=0xb335,"increment angle counter" \
	comment=0xb342,"multiply radius by value pointed to by U" \
	comment=0xb342,"radius" \
	comment=0xb34b,"Y:U = D * X" \
	comment=0xb350,"multiplies D by X & leaves result in Y:U" \
	comment=0xb37a,"called by CIRCLE" \
	comment=0xb37a,"draw line" \
	comment=0xb37d,"called by CIRCLE: reads optional start/end value" \
	comment=0xb37d,"reduces to 6 bits and leaves top 3 bits in A" \
	comment=0xb37d,"& bottom 3 bits in B" \
	comment=0xb37e,"get current character from BASIC source" \
	comment=0xb382,"check comma" \
	comment=0xb385,"get FP number" \
	comment=0xb38c,"multiply FP number by 64" \
	comment=0xb38e,"get FP number in B" \
	comment=0xb39b,"reset routine continued" \
	comment=0xb39f,"enable cart FIRQ" \
	comment=0xb3a4,"cold boot flag" \
	comment=0xb3a8,"cold boot" \
	comment=0xb3aa,"soft reset vector" \
	comment=0xb3b0,"cold boot" \
	comment=0xb3b2,"soft reset" \
	comment=0xb3b4,"reset routine (CPU vector)" \
	comment=0xb3b7,"JMP to \$BB3C" \
	comment=0xb3ba,"reset routine - invalid soft vector" \
	comment=0xb3ba,"clear 0 - 3ff" \
	comment=0xb3c3,"clear text screen" \
	comment=0xb3c8,"start of BASIC program" \
	comment=0xb3ca,"memory test" \
	comment=0xb3d9,"top of RAM" \
	comment=0xb3db,"top of BASIC RAM" \
	comment=0xb3dd,"top of free string space" \
	comment=0xb3e3,"stack root / string storage start" \
	comment=0xb3e7,"calls \$BB88" \
	comment=0xb3ed,"initialise system variables" \
	comment=0xb3f2,"copy B bytes from X to U" \
	comment=0xb3f5,"initialise system variables" \
	comment=0xb3fa,"copy B bytes from X to U" \
	comment=0xb3fd,"?SN ERROR" \
	comment=0xb400,"dummy disk command jump" \
	comment=0xb402,"dummy disk function jump" \
	comment=0xb404,"set patch vectors to RTS" \
	comment=0xb40f,"mystery RTS" \
	comment=0xb412,"NEW BASIC" \
	comment=0xb415,"set up PLAY & graphics variables" \
	comment=0xb418,"set up USR vectors" \
	comment=0xb41b,"address of USR table" \
	comment=0xb41d,"?FC ERROR" \
	comment=0xb427,"PCLEAR 4" \
	comment=0xb42f,"enable vsync irq" \
	comment=0xb432,"check for 'DK' disk" \
	comment=0xb435,"cartridge sigature" \
	comment=0xb43c,"enable interrupts" \
	comment=0xb441,"display copyright message" \
	comment=0xb444,"set up soft reset vector" \
	comment=0xb447,"soft reset vector" \
	comment=0xb44b,"cold boot flag" \
	comment=0xb44d,"(JMP \$8371 - command mode)" \
	comment=0xb44f,"normal soft reset routine" \
	comment=0xb450,"clear PLAY duration counter" \
	comment=0xb454,"enable vsync irq" \
	comment=0xb45c,"DEVN = VDU" \
	comment=0xb45e,"reset stack" \
	comment=0xb461,"enable interrupts" \
	comment=0xb463,"clear screen" \
	comment=0xb466,"command mode" \
	comment=0xb469,"FIRQ service routine" \
	comment=0xb46c,"cartridge" \
	comment=0xb46f,"delay" \
	comment=0xb47b,"cold boot flag" \
	comment=0xb480,"delay before starting FIRQ cartrige" \
	comment=0xb480,"zero" \
	comment=0xb487,"copied to \$9d - \$aa on start up" \
	comment=0xb487,"(default EXEC & get character routine)" \
	comment=0xb495,"copied to \$10c - \$129 on start up" \
	comment=0xb495,"(IRQ, FIRQ, RND seeds, key delay, command addresses)" \
	comment=0xb4b3,"copyright message" \
	comment=0xb505,"read 7 bit character from device DEVN" \
	comment=0xb50a,"read character from device DEVN" \
	comment=0xb50a,"(+set EOF file flag if applicable)" \
	comment=0xb50a,"PATCH - input character from DEVN" \
	comment=0xb50d,"EOF flag" \
	comment=0xb50f,"DEVN" \
	comment=0xb511,"get character from keyboard" \
	comment=0xb513,"no. of characters in buffer" \
	comment=0xb515,"get character from file" \
	comment=0xb517,"set EOF flag" \
	comment=0xb51a,"read character from file" \
	comment=0xb51c,"buffer pointer" \
	comment=0xb522,"buffer pointer" \
	comment=0xb524,"no. of characters in buffer" \
	comment=0xb528,"DEVN" \
	comment=0xb52c,"serial" \
	comment=0xb52e,"get block from tape" \
	comment=0xb533,"get block from serial" \
	comment=0xb538,"wait for character from keyboard" \
	comment=0xb538,"(with cursor)" \
	comment=0xb53a,"blink cursor" \
	comment=0xb53d,"scan keyboard" \
	comment=0xb544,"text cursor address" \
	comment=0xb54a,"output character to device DEVN" \
	comment=0xb54a,"PATCH - output character to DEVN" \
	comment=0xb54f,"DEVN" \
	comment=0xb553,"not -3 (serial output not supported)" \
	comment=0xb55a,"send to printer" \
	comment=0xb55e,"send to VDU" \
	comment=0xb560,"send to file" \
	comment=0xb562,"cassette IO status" \
	comment=0xb565,"input - quit" \
	comment=0xb567,"no. of characters in buffer" \
	comment=0xb56c,"flush tape buffer" \
	comment=0xb56e,"buffer pointer" \
	comment=0xb572,"buffer pointer" \
	comment=0xb574,"no. of characters in buffer" \
	comment=0xb578,"flush tape buffer" \
	comment=0xb57a,"block type" \
	comment=0xb57c,"IO buffer" \
	comment=0xb581,"no. of characters in buffer" \
	comment=0xb583,"block length" \
	comment=0xb587,"write leader & block to tape" \
	comment=0xb58c,"reset IO buffer" \
	comment=0xb58f,"send character to VDU" \
	comment=0xb58f,"reset VDU" \
	comment=0xb592,"write to VDU" \
	comment=0xb595,"initialise virtual DEVN device" \
	comment=0xb595,"PATCH - device initialisation" \
	comment=0xb59a,"cassette IO flag" \
	comment=0xb59c,"DEVN" \
	comment=0xb59e,"VDU" \
	comment=0xb5a1,"cassette" \
	comment=0xb5a3,"printer comma field width / last comma field" \
	comment=0xb5a5,"printer line width / head pos" \
	comment=0xb5ab,"get VDU column number" \
	comment=0xb5b2,"comma field width / last comma field" \
	comment=0xb5b4,"current column number" \
	comment=0xb5b6,"line width" \
	comment=0xb5ba,"set cassette IO flag" \
	comment=0xb5c3,"clear screen" \
	comment=0xb5c3,"clear screen" \
	comment=0xb5c6,"command mode line input from DEVN" \
	comment=0xb5c6,"PATCH - line input file" \
	comment=0xb5c9,"last key pressed" \
	comment=0xb5ce,"B = character count" \
	comment=0xb5d0,"read 7 bit character from DEVN" \
	comment=0xb5d3,"EOF flag" \
	comment=0xb5d5,"EOF" \
	comment=0xb5d7,"DEVN" \
	comment=0xb5d9,"not keyed input" \
	comment=0xb5db,"CLEAR key" \
	comment=0xb5df,"backspace" \
	comment=0xb5e4,"nothing to delete" \
	comment=0xb5ea,"shift + backspace" \
	comment=0xb5ef,"nothing to delete" \
	comment=0xb5f3,"output character to DEVN" \
	comment=0xb5f8,"BREAK" \
	comment=0xb5fe,"RETURN" \
	comment=0xb605,"send CR to DEVN" \
	comment=0xb60a,"return with carry set if" \
	comment=0xb60d,"input aborted with BREAK" \
	comment=0xb611,"chr < \$20" \
	comment=0xb615,"chr >= \$7b" \
	comment=0xb619,"max no. of characters = \$fa" \
	comment=0xb61e,"echo typed character" \
	comment=0xb623,"test cassette status OK for input" \
	comment=0xb623,"PATCH - input file" \
	comment=0xb626,"DEVN" \
	comment=0xb628,"RTS" \
	comment=0xb62b,"?FM ERROR" \
	comment=0xb62d,"cassette IO status" \
	comment=0xb62f,"open" \
	comment=0xb631,"?NO ERROR" \
	comment=0xb637,"input - RTS" \
	comment=0xb639,"?FM ERROR" \
	comment=0xb63c,"if DEVN = -1 test cassette status for output" \
	comment=0xb63c,"PATCH - output file" \
	comment=0xb63f,"DEVN" \
	comment=0xb642,"not cassette" \
	comment=0xb644,"cassette IO status" \
	comment=0xb646,"?NO ERROR" \
	comment=0xb649,"?FM ERROR" \
	comment=0xb64c,"CLOSE" \
	comment=0xb64c,"Format: CLOSE [#-n[,#-n]]" \
	comment=0xb64c,"no parameter so close #-1" \
	comment=0xb64e,"read #-n & set up DEVN (no skip comma)" \
	comment=0xb651,"close DEVN stream & set DEVN to 0" \
	comment=0xb653,"get current character from BASIC source" \
	comment=0xb655,"RTS" \
	comment=0xb657,"read #-n & set up DEVN" \
	comment=0xb65a,"read next stream no." \
	comment=0xb65c,"PATCH - close all files" \
	comment=0xb65f,"close cassette stream & set DEVN to 0" \
	comment=0xb661,"DEVN" \
	comment=0xb663,"PATCH - close file" \
	comment=0xb666,"DEVN" \
	comment=0xb668,"DEVN" \
	comment=0xb66b,"not cassette" \
	comment=0xb66d,"cassette IO status" \
	comment=0xb671,"not output" \
	comment=0xb673,"no. of characters in buffer" \
	comment=0xb677,"flush tape buffer" \
	comment=0xb67c,"B = \$FF = EOF block" \
	comment=0xb67f,"cassette IO status" \
	comment=0xb682,"CSAVE" \
	comment=0xb684,"CSAVEM" \
	comment=0xb688,"get filename" \
	comment=0xb68b,"get current character from BASIC source" \
	comment=0xb68d,"normal CSAVE" \
	comment=0xb68f,"check comma" \
	comment=0xb694,"skip over 'A'" \
	comment=0xb697,"return if anything else on command line" \
	comment=0xb699,"file type = 0 = tokenized BASIC" \
	comment=0xb69a,"write filename block for gapped ASCII" \
	comment=0xb69f,"DEVN = -1" \
	comment=0xb6a2,"LIST to DEVN - very clever!" \
	comment=0xb6a5,"ungapped CSAVE" \
	comment=0xb6a5,"tokenized BASIC" \
	comment=0xb6a6,"non-ASCII & ungapped" \
	comment=0xb6a8,"write filename block" \
	comment=0xb6ab,"cassette IO status" \
	comment=0xb6ad,"block type" \
	comment=0xb6af,"write leader" \
	comment=0xb6b2,"start of BASIC program" \
	comment=0xb6b4,"IO buffer" \
	comment=0xb6b8,"block length" \
	comment=0xb6ba,"start of simple variables" \
	comment=0xb6bc,"IO buffer" \
	comment=0xb6c6,"block length" \
	comment=0xb6c8,"write block to tape" \
	comment=0xb6cd,"block type" \
	comment=0xb6cf,"block length" \
	comment=0xb6d1,"write block & cassette relay off" \
	comment=0xb6d4,"CLOAD" \
	comment=0xb6d4,"cassette IO status" \
	comment=0xb6d8,"CLOADM (returns to \$b73c if not gapped)" \
	comment=0xb6de,"get filename" \
	comment=0xb6e1,"find file & set up buffer" \
	comment=0xb6e4,"gap flag" \
	comment=0xb6e9,"ASCII flag" \
	comment=0xb6ec,"?FM ERROR" \
	comment=0xb6ee,"NEW BASIC" \
	comment=0xb6f3,"DEVN = -1" \
	comment=0xb6f5,"cassette status 1 = input" \
	comment=0xb6f7,"get block from tape" \
	comment=0xb6fa,"command mode / no device initialise" \
	comment=0xb6fd,"close file & return to command mode" \
	comment=0xb6fd,"PATCH - close ASCII file" \
	comment=0xb700,"close DEVN stream & set DEVN to 0" \
	comment=0xb703,"command mode" \
	comment=0xb706,"ungapped CLOAD" \
	comment=0xb706,"file type 0 = tokenized BASIC" \
	comment=0xb70b,"?FM ERROR" \
	comment=0xb70e,"NEW BASIC" \
	comment=0xb711,"read leader from tape" \
	comment=0xb714,"start of BASIC program" \
	comment=0xb716,"IO buffer" \
	comment=0xb71b,"memory check" \
	comment=0xb71e,"read block from tape" \
	comment=0xb721,"error" \
	comment=0xb723,"block type" \
	comment=0xb725,"error" \
	comment=0xb729,"start of simple variables" \
	comment=0xb72b,"cassette relay off" \
	comment=0xb730,"print string to DEVN" \
	comment=0xb733,"set up new BASIC program & go command mode" \
	comment=0xb736,"NEW BASIC" \
	comment=0xb739,"?IO ERROR" \
	comment=0xb73c,"returned to do ungapped CLOADM" \
	comment=0xb73c,"zero" \
	comment=0xb73e,"get current character from BASIC source" \
	comment=0xb742,"check comma" \
	comment=0xb745,"get 16 bit number into X" \
	comment=0xb748,"file type" \
	comment=0xb74b,"2 = binary" \
	comment=0xb74d,"?FM ERROR" \
	comment=0xb74f,"entry address" \
	comment=0xb752,"apply offset" \
	comment=0xb754,"EXEC address" \
	comment=0xb756,"load address" \
	comment=0xb75b,"IO buffer" \
	comment=0xb75d,"read leader from tape" \
	comment=0xb760,"read block from tape" \
	comment=0xb763,"?IO ERROR" \
	comment=0xb765,"IO buffer" \
	comment=0xb767,"block type" \
	comment=0xb769,"?IO ERROR" \
	comment=0xb76d,"cassette relay off" \
	comment=0xb770,"EXEC" \
	comment=0xb772,"get 16 bit number into X" \
	comment=0xb775,"default EXEC address" \
	comment=0xb77b,"scan for break & pause if DEVN not -1" \
	comment=0xb77b,"PATCH - check break & pause" \
	comment=0xb77e,"DEVN" \
	comment=0xb781,"RTS" \
	comment=0xb783,"scan keyboard for break & pause" \
	comment=0xb786,"called by PRINT to handle PRINT@" \
	comment=0xb786,"get unsigned number into D & \$52 from FPA1" \
	comment=0xb78c,"?FC ERROR" \
	comment=0xb793,"text cursor address" \
	comment=0xb796,"INKEY\$" \
	comment=0xb796,"last key pressed" \
	comment=0xb798,"key ready" \
	comment=0xb79a,"scan keyboard" \
	comment=0xb79d,"last key pressed" \
	comment=0xb7a1,"set up character & put on varptr stack" \
	comment=0xb7a7,"leas 2,s & put temp string on varptr stack" \
	comment=0xb7aa,"called by get filename routine" \
	comment=0xb7aa,"(reads filename from command into usual location)" \
	comment=0xb7b3,"IO buffer" \
	comment=0xb7b8,"get current character from BASIC source" \
	comment=0xb7ba,"RTS" \
	comment=0xb7bc,"get expression" \
	comment=0xb7bf,"validate string & point X to it (len in B)" \
	comment=0xb7c5,"store length" \
	comment=0xb7cc,"copy 8 bytes from X to U" \
	comment=0xb7cc,"(B7CA C608       LDB   #\$08)" \
	comment=0xb7cc,"copy B bytes from X to U" \
	comment=0xb7d4,"read #-n from command and sets up DEVN" \
	comment=0xb7d4,"check comma" \
	comment=0xb7db,"get next character from BASIC source" \
	comment=0xb7dd,"get numeric expression into FPA1" \
	comment=0xb7e0,"get 16 bit number into D & \$52 from FPA1" \
	comment=0xb7e6,"?DN ERROR" \
	comment=0xb7e9,"DEVN" \
	comment=0xb7eb,"PATCH - check device number" \
	comment=0xb7f0,"?DN ERROR" \
	comment=0xb7f4,"?DN ERROR" \
	comment=0xb7f7,"get filename from command" \
	comment=0xb7f7,"(sets up filename locations)" \
	comment=0xb7f7,"get filename" \
	comment=0xb7f9,"get current character from BASIC source" \
	comment=0xb7fb,"RTS" \
	comment=0xb7fd,"?SN ERROR" \
	comment=0xb800,"EOF" \
	comment=0xb800,"PATCH - check eof" \
	comment=0xb803,"DEVN" \
	comment=0xb807,"get device number from command" \
	comment=0xb809,"test cassette status OK for input" \
	comment=0xb80d,"DEVN" \
	comment=0xb80f,"VDU" \
	comment=0xb811,"no. of characters in buffer" \
	comment=0xb813,"not EOF" \
	comment=0xb818,"DEVN" \
	comment=0xb81b,"assign D to FPA1" \
	comment=0xb81e,"SKIPF" \
	comment=0xb81e,"get filename" \
	comment=0xb820,"find file & set up buffer" \
	comment=0xb822,"skip rest of file" \
	comment=0xb825,"?IO ERROR" \
	comment=0xb828,"OPEN" \
	comment=0xb828,"PATCH - device open" \
	comment=0xb82b,"get expression" \
	comment=0xb82e,"get 1st character of string into B" \
	comment=0xb833,"read #-n & set up DEVN" \
	comment=0xb835,"check comma" \
	comment=0xb838,"get filename" \
	comment=0xb83a,"DEVN" \
	comment=0xb83c,"DEVN" \
	comment=0xb842,"open for input" \
	comment=0xb846,"write filename block if A = -1" \
	comment=0xb848,"?FM ERROR" \
	comment=0xb84d,"(B84B C62A       LDB   #\$2A)    ;?IO ERROR" \
	comment=0xb850,"(B84E C626       LDB   #\$26)    ;?AO ERROR" \
	comment=0xb853,"(B851 C628       LDB   #\$28)    ;?DN ERROR" \
	comment=0xb856,"input stream must be >= -1" \
	comment=0xb857,"?FM ERROR" \
	comment=0xb859,"return if stream <> -1" \
	comment=0xb85b,"find file & set up buffer" \
	comment=0xb85d,"must be ASCII" \
	comment=0xb860,"and gapped" \
	comment=0xb863,"?FM ERROR" \
	comment=0xb865,"cassette IO status" \
	comment=0xb867,"read leader & block from tape" \
	comment=0xb86a,"?IO ERROR" \
	comment=0xb86c,"block must be data or EOF" \
	comment=0xb86e,"?IO ERROR" \
	comment=0xb870,"return if EOF block" \
	comment=0xb872,"block length" \
	comment=0xb874,"get another block if zero length" \
	comment=0xb876,"no. of characters in buffer" \
	comment=0xb878,"finish setting up buffer" \
	comment=0xb87a,"find file & set up buffer" \
	comment=0xb87a,"cassette IO status" \
	comment=0xb87c,"?AO ERROR" \
	comment=0xb87e,"find file" \
	comment=0xb880,"?IO ERROR" \
	comment=0xb882,"no. of characters in buffer" \
	comment=0xb884,"IO buffer" \
	comment=0xb887,"buffer pointer" \
	comment=0xb88a,"if A = -1 then write filename block for gapped ASCII" \
	comment=0xb88b,"RTS" \
	comment=0xb88d,"A = 1" \
	comment=0xb88e,"write filename block for gapped ASCII (file type in A)" \
	comment=0xb891,"cassette IO status" \
	comment=0xb893,"?AO ERROR" \
	comment=0xb895,"IO buffer" \
	comment=0xb89a,"file type" \
	comment=0xb89c,"ASCII flag & gap flag" \
	comment=0xb89e,"filename" \
	comment=0xb8a1,"copy 8 bytes from X to U" \
	comment=0xb8a4,"block type" \
	comment=0xb8a8,"block length" \
	comment=0xb8aa,"write leader & block to tape" \
	comment=0xb8ad,"2 = output" \
	comment=0xb8af,"cassette IO status" \
	comment=0xb8b1,"reset IO buffer" \
	comment=0xb8b3,"find file" \
	comment=0xb8b3,"IO buffer" \
	comment=0xb8b8,"current line number" \
	comment=0xb8bb,"not in command mode" \
	comment=0xb8bd,"clear screen" \
	comment=0xb8c0,"text cursor address" \
	comment=0xb8c6,"text cursor address" \
	comment=0xb8c8,"read leader & block from tape" \
	comment=0xb8ca,"block type" \
	comment=0xb8cc,"keep going until filename block loaded" \
	comment=0xb8ce,"IO buffer" \
	comment=0xb8d1,"filename to find" \
	comment=0xb8da,"current line number" \
	comment=0xb8df,"not in command mode" \
	comment=0xb8e1,"DEVN" \
	comment=0xb8e3,"output character to DEVN" \
	comment=0xb8f1,"matched filename" \
	comment=0xb8f5,"no filename specified" \
	comment=0xb8f7,"skip rest of file" \
	comment=0xb8f9,"return with error" \
	comment=0xb8fb,"try next file" \
	comment=0xb8ff,"display 'F'" \
	comment=0xb903,"skip rest of file" \
	comment=0xb903,"gap flag" \
	comment=0xb906,"gapped file" \
	comment=0xb908,"read leader from tape" \
	comment=0xb90b,"read block from tape" \
	comment=0xb90d,"test file status" \
	comment=0xb90f,"do next block" \
	comment=0xb911,"read leader & block from tape" \
	comment=0xb913,"test file status" \
	comment=0xb915,"do next block" \
	comment=0xb917,"test file status" \
	comment=0xb919,"block type" \
	comment=0xb91c,"normal block - RTS" \
	comment=0xb91f,"error status" \
	comment=0xb923,"cassette relay off & get status in B" \
	comment=0xb925,"flash loading cursor" \
	comment=0xb92a,"current line number" \
	comment=0xb92d,"not in command mode" \
	comment=0xb933,"read leader & block from tape" \
	comment=0xb933,"read leader from tape" \
	comment=0xb936,"read block from tape" \
	comment=0xb938,"cassette relay off" \
	comment=0xb93b,"error status" \
	comment=0xb93e,"read block from tape" \
	comment=0xb93e,"mask interrupts" \
	comment=0xb940,"flash loading cursor" \
	comment=0xb942,"IO buffer" \
	comment=0xb945,"bit in" \
	comment=0xb94b,"wait for sync byte" \
	comment=0xb94d,"byte in" \
	comment=0xb950,"block type" \
	comment=0xb952,"byte in" \
	comment=0xb955,"block length" \
	comment=0xb957,"block type" \
	comment=0xb959,"checksum" \
	comment=0xb95b,"block length" \
	comment=0xb95d,"use error status as counter" \
	comment=0xb95f,"no data" \
	comment=0xb961,"byte in" \
	comment=0xb966,"check that we are loading into RAM" \
	comment=0xb96c,"checksum" \
	comment=0xb970,"get next data byte" \
	comment=0xb972,"byte in" \
	comment=0xb975,"checksum" \
	comment=0xb977,"status = OK" \
	comment=0xb979,"status = CRC error" \
	comment=0xb97e,"(B97C 8602       LDA   #\$02)    ;status = no RAM" \
	comment=0xb97e,"status" \
	comment=0xb981,"MOTOR" \
	comment=0xb983,"get next character from BASIC source" \
	comment=0xb985,"token OFF" \
	comment=0xb987,"cassette relay off" \
	comment=0xb989,"token ON" \
	comment=0xb98b,"?SN ERROR if <>0" \
	comment=0xb98e,"cassette relay on" \
	comment=0xb991,"write leader & block to tape" \
	comment=0xb991,"write leader" \
	comment=0xb994,"write block to tape" \
	comment=0xb996,"cassette relay off" \
	comment=0xb999,"write block to tape" \
	comment=0xb999,"mask interrupts" \
	comment=0xb99b,"block length" \
	comment=0xb99d,"use error status as counter" \
	comment=0xb99f,"block length" \
	comment=0xb9a1,"no data" \
	comment=0xb9a3,"IO buffer address" \
	comment=0xb9a8,"calculate checksum" \
	comment=0xb9aa,"block type" \
	comment=0xb9ac,"checksum" \
	comment=0xb9ae,"IO buffer address" \
	comment=0xb9b0,"write single leader byte" \
	comment=0xb9b2,"sync byte" \
	comment=0xb9b4,"byte out" \
	comment=0xb9b6,"block type" \
	comment=0xb9b8,"byte out" \
	comment=0xb9ba,"block length" \
	comment=0xb9bc,"byte out" \
	comment=0xb9bf,"no data" \
	comment=0xb9c3,"byte out" \
	comment=0xb9c7,"keep going until all data sent" \
	comment=0xb9c9,"checksum" \
	comment=0xb9cb,"byte out" \
	comment=0xb9cd,"leader byte" \
	comment=0xb9cf,"byte out" \
	comment=0xb9d2,"SET" \
	comment=0xb9d2,"read coords & calc pixel" \
	comment=0xb9d6,"skip comma & get number in B" \
	comment=0xb9dd,"?FC ERROR" \
	comment=0xb9e0,"black" \
	comment=0xb9e9,"non-graphics block present" \
	comment=0xb9ef,"(B9EE 5F         CLRB)" \
	comment=0xb9f1,"skip close bracket" \
	comment=0xb9f7,"non-graphics block present" \
	comment=0xb9fa,"lo-res pixel mask" \
	comment=0xba03,"RESET" \
	comment=0xba03,"read coords & calc pixel" \
	comment=0xba05,"skip close bracket" \
	comment=0xba0c,"lo-res pixel mask" \
	comment=0xba13,"read coords & calc pixel for SET / RESET / POINT" \
	comment=0xba13,"skip open bracket" \
	comment=0xba16,"get number in B" \
	comment=0xba1b,"?FC ERROR" \
	comment=0xba1f,"skip comma & get number in B" \
	comment=0xba24,"?FC ERROR" \
	comment=0xba41,"lo-res pixel mask" \
	comment=0xba44,"POINT" \
	comment=0xba44,"read coords" \
	comment=0xba4a,"non-graphics block" \
	comment=0xba4c,"lo-res pixel mask" \
	comment=0xba59,"return number to BASIC" \
	comment=0xba5c,"skip close bracket" \
	comment=0xba5f,"CLS" \
	comment=0xba5f,"PATCH - CLS GET PUT" \
	comment=0xba62,"no parameter - clear to spaces" \
	comment=0xba64,"get number in B" \
	comment=0xba69,"CLS 9+" \
	comment=0xba6c,"CLS 0" \
	comment=0xba79,"clear text screen" \
	comment=0xba79,"(BA77 C660       LDB   #\$60)" \
	comment=0xba7c,"text cursor address" \
	comment=0xba86,"clear text screen & print copyright message for CLS9+" \
	comment=0xba86,"clear screen" \
	comment=0xba8b,"print string to DEVN" \
	comment=0xba8e,"get parameter for SOUND" \
	comment=0xba8e,"check comma" \
	comment=0xba91,"get number in B" \
	comment=0xba95,"RTS" \
	comment=0xba97,"?FC ERROR" \
	comment=0xba9a,"SOUND" \
	comment=0xba9a,"get pitch" \
	comment=0xba9c,"pitch" \
	comment=0xba9e,"skip comma & get duration" \
	comment=0xbaa3,"duration x 4" \
	comment=0xbaaa,"enable vsync irq" \
	comment=0xbaaf,"B=0 to select d/a sound" \
	comment=0xbab1,"enable audio" \
	comment=0xbab3,"centre d/a" \
	comment=0xbab7,"max d/a" \
	comment=0xbab9,"centre d/a" \
	comment=0xbabd,"min d/a" \
	comment=0xbabf,"loop until irq routine" \
	comment=0xbac1,"decrements duration to zero" \
	comment=0xbac3,"disable audio" \
	comment=0xbac7,"enable audio" \
	comment=0xbac7,"(BAC5 8608       LDA #\$08)" \
	comment=0xbad4,"reset D/A and delay" \
	comment=0xbad6,"store A in D/A and delay" \
	comment=0xbad9,"SOUND pitch value" \
	comment=0xbadf,"AUDIO" \
	comment=0xbae1,"get next character from BASIC source" \
	comment=0xbae3,"token OFF" \
	comment=0xbae7,"token ON" \
	comment=0xbae9,"?SN ERROR if <>0" \
	comment=0xbaed,"B=1 for cassette sound" \
	comment=0xbaef,"enable audio" \
	comment=0xbaf1,"select sound source" \
	comment=0xbb02,"SOUND duration counter" \
	comment=0xbb02,"(called by IRQ service routine)" \
	comment=0xbb02,"SOUND counter" \
	comment=0xbb09,"SOUND counter" \
	comment=0xbb0d,"JOYSTK" \
	comment=0xbb0d,"get number in B from FPA1" \
	comment=0xbb12,"?FC ERROR" \
	comment=0xbb19,"update joysticks if B = 0" \
	comment=0xbb1c,"joystick value table" \
	comment=0xbb1f,"get number again" \
	comment=0xbb23,"assign B to FPA1" \
	comment=0xbb26,"continued from fetch character routine at \$9f" \
	comment=0xbb26,"skips spaces and returns with carry set if" \
	comment=0xbb26,"character is a digit" \
	comment=0xbb28,"higher than '9'" \
	comment=0xbb2c,"not a space" \
	comment=0xbb2e,"get next character from BASIC source" \
	comment=0xbb32,"set carry if >= '0'" \
	comment=0xbb35,"unused" \
	comment=0xbb3c,"reset routine continued" \
	comment=0xbb3c,"initialise PIA0:" \
	comment=0xbb3f,"\$FF00 PDR rrrrrrrr" \
	comment=0xbb42,"\$FF02 PDR wwwwwwww" \
	comment=0xbb44,"CA2 bit3 output mode" \
	comment=0xbb46,"CB2 bit3 output mode" \
	comment=0xbb48,"IRQA disabled (hsync)" \
	comment=0xbb49,"IRQB disabled (vsync)" \
	comment=0xbb4f,"initialise PIA1:" \
	comment=0xbb52,"\$FF20 PDR wwwwwwwr" \
	comment=0xbb54,"\$FF22 PDR wwwwwrrr" \
	comment=0xbb56,"CA2 bit3 output mode" \
	comment=0xbb57,"CB2 bit3 output mode" \
	comment=0xbb59,"IRQA disabled (ack)" \
	comment=0xbb5b,"IRQB disabled (cart)" \
	comment=0xbb65,"initialise serial hardware:" \
	comment=0xbb68,"no parity, no IRQ, DTR low" \
	comment=0xbb6b,"1200 baud, 8 data, 2 stop" \
	comment=0xbb6e,"initialise SAM:" \
	comment=0xbb71,"512 byte display" \
	comment=0xbb73,"display base 1024" \
	comment=0xbb75,"mem page 0" \
	comment=0xbb76,"slow MPU rate" \
	comment=0xbb78,"64K dynamic memory" \
	comment=0xbb7b,"MAP 0" \
	comment=0xbb80,"boot 64K BASIC" \
	comment=0xbb83,"reset routine continued" \
	comment=0xbb86,"JMP to \$B39B" \
	comment=0xbb88,"part of start up reset routine" \
	comment=0xbb90,"copy B bytes from X to U" \
	comment=0xbb92,"set up serial printer parameters" \
	comment=0xbb9c,"copy B bytes from X to U" \
	comment=0xbb9f,"copied to \$8f - \$9b on start up" \
	comment=0xbb9f,"(cursor counter, leader count, COS timing, motor on delay," \
	comment=0xbb9f,"key scan delay, printer parameters)" \
	comment=0xbbac,"copied to \$148 - \$150 on start up" \
	comment=0xbbac,"(auto LF flag, caps flag, printer EOL sequence)" \
	comment=0xbbb5,"blink cursor" \
	comment=0xbbb5,"cursor flash counter" \
	comment=0xbbbb,"cursor flash counter" \
	comment=0xbbbd,"text cursor address" \
	comment=0xbbcd,"read key matrix & mask SHIFT key" \
	comment=0xbbd0,"mask analogue comp." \
	comment=0xbbda,"test for SHIFT key" \
	comment=0xbbe5,"scan keyboard & return ASCII" \
	comment=0xbbee,"key rollover table" \
	comment=0xbbf1,"test all keys" \
	comment=0xbbf7,"mask analogue comp." \
	comment=0xbbfb,"nothing changed - return NUL" \
	comment=0xbbff,"disable all keys" \
	comment=0xbc02,"read matrix & mask shift" \
	comment=0xbc06,"joystick button pressed - return NUL" \
	comment=0xbc08,"\$0151 = keyboard state" \
	comment=0xbc0a,"row counter" \
	comment=0xbc11,"read matrix & mask shift" \
	comment=0xbc17,"sets bits in B for new keys pressed" \
	comment=0xbc1b,"save new scan code" \
	comment=0xbc1e,"new keys pressed" \
	comment=0xbc22,"set carry" \
	comment=0xbc23,"next row" \
	comment=0xbc26,"more rows to do" \
	comment=0xbc28,"no new keys pressed - return NUL" \
	comment=0xbc2c,"debounce delay" \
	comment=0xbc30,"read matrix & mask shift" \
	comment=0xbc36,"key state changed during delay - return NUL" \
	comment=0xbc38,"row number" \
	comment=0xbc3c,"convert scan code into a number" \
	comment=0xbc3e,"between 0 and 54" \
	comment=0xbc3f,"(nb. shift masked out)" \
	comment=0xbc42,"zero key" \
	comment=0xbc46,"keys 1 to 9 : ;" \
	comment=0xbc4a,"keys , - . / @" \
	comment=0xbc4e,"arrows SPC RET CLR BRK" \
	comment=0xbc50,"ASCII A - Z" \
	comment=0xbc52,"test for SHIFT key" \
	comment=0xbc54,"SHIFT pressed" \
	comment=0xbc56,"CAPS flag" \
	comment=0xbc59,"upper case" \
	comment=0xbc5b,"convert to lower case" \
	comment=0xbc5f,"ASCII 1 to 9 : ;" \
	comment=0xbc61,"test for SHIFT key" \
	comment=0xbc64,"SHIFT not pressed" \
	comment=0xbc6a,"not shift + 0" \
	comment=0xbc6c,"CAPS flag" \
	comment=0xbc72,"XLAT key scan code to ASCII" \
	comment=0xbc77,"test for SHIFT key" \
	comment=0xbc84,"keyboard XLAT table" \
	comment=0xbc84,"(two bytes per entry - unshifted & shifted)" \
	comment=0xbc84,"0      ," \
	comment=0xbc88,"-      ." \
	comment=0xbc8c,"/      @" \
	comment=0xbc90,"CU     CD" \
	comment=0xbc94,"CL     CR" \
	comment=0xbc98,"SPC    RET" \
	comment=0xbc9c,"CLR    BRK" \
	comment=0xbca0,"clear VDU line + CR/LF" \
	comment=0xbcab,"write character to VDU" \
	comment=0xbcad,"text cursor address" \
	comment=0xbcb3,"backspace" \
	comment=0xbcbe,"return" \
	comment=0xbcc2,"clear VDU line + CR/LF" \
	comment=0xbcc8,"chr < \$20" \
	comment=0xbccb,"chr >= 128" \
	comment=0xbccf,"\$20 <= chr < \$40" \
	comment=0xbcd3,"\$40 <= chr < \$60" \
	comment=0xbcdb,"text cursor address" \
	comment=0xbce2,"scroll" \
	comment=0xbcef,"text cursor address" \
	comment=0xbcf1,"clear VDU line + CR/LF" \
	comment=0xbcf5,"write character direct to printer" \
	comment=0xbcf7,"printer type flag" \
	comment=0xbcfa,"continued..." \
	comment=0xbcfd,"write character to parallel port" \
	comment=0xbd05,"strobe" \
	comment=0xbd0a,"send EOL characters to printer" \
	comment=0xbd14,"send character direct to printer" \
	comment=0xbd16,"continued..." \
	comment=0xbd1a,"write character to printer" \
	comment=0xbd22,"don't advance head pos for CTRL chrs" \
	comment=0xbd24,"printer head pos" \
	comment=0xbd26,"send character to printer" \
	comment=0xbd28,"printer head pos" \
	comment=0xbd2a,"printer line width" \
	comment=0xbd2e,"printer auto LF flag" \
	comment=0xbd33,"printer head pos" \
	comment=0xbd39,"send character to printer" \
	comment=0xbd3b,"send EOL sequence" \
	comment=0xbd3d,"printer head pos" \
	comment=0xbd41,"select joystick source B (0-3)" \
	comment=0xbd52,"update joystick values in locations \$15a - \$15d" \
	comment=0xbd52,"(reads each channel up to 10 times until stable result is obtained)" \
	comment=0xbd54,"end of joystick table + 1" \
	comment=0xbd5d,"select joystick source B" \
	comment=0xbd67,"test analogue comp." \
	comment=0xbd6a,"approximation low" \
	comment=0xbd6c,"try smaller value" \
	comment=0xbd70,"try larger value" \
	comment=0xbd75,"do finer approximation" \
	comment=0xbd78,"convert range to 0-63" \
	comment=0xbd7b,"reading stable" \
	comment=0xbd7f,"do up to 10 readings until stable" \
	comment=0xbd86,"do next joystick channel" \
	comment=0xbd8a,"read state of cassette input comparator into carry" \
	comment=0xbd8a,"(+update wavelength timer)" \
	comment=0xbd8a,"wavelength timer" \
	comment=0xbd91,"wave timer" \
	comment=0xbd91,"wavelength timer" \
	comment=0xbd93,"phase flag" \
	comment=0xbd95,"time antiphase wave" \
	comment=0xbd97,"time +ve going wave" \
	comment=0xbd99,"time -ve going wave" \
	comment=0xbd99,"read cassette input & update timer" \
	comment=0xbd9e,"alternative wave timer (antiphase)" \
	comment=0xbd9e,"time -ve going wave" \
	comment=0xbda0,"time +ve going wave" \
	comment=0xbda0,"read cassette input & update timer" \
	comment=0xbda5,"read bit from tape into carry" \
	comment=0xbda7,"wavelength timer" \
	comment=0xbdaa,"wavelength threshold" \
	comment=0xbdad,"read byte from tape into A" \
	comment=0xbdb1,"read bit from tape into carry" \
	comment=0xbdb3,"LSB first" \
	comment=0xbdb6,"do next bit" \
	comment=0xbdb9,"called by read leader routine - test +ve going wave" \
	comment=0xbdb9,"wavelength timer" \
	comment=0xbdbb,"time +ve going wave" \
	comment=0xbdbf,"called by read leader routine - test -ve going wave" \
	comment=0xbdbf,"wavelength timer" \
	comment=0xbdc1,"time -ve going wave" \
	comment=0xbdc3,"wavelength timer" \
	comment=0xbdc5,"rejection threshold" \
	comment=0xbdc7,"bad wave - clear counter" \
	comment=0xbdc9,"discrimination threshold" \
	comment=0xbdcc,"phase lock counter" \
	comment=0xbdcf,"turn cassette relay on" \
	comment=0xbddc,"turn cassette relay off" \
	comment=0xbde7,"read leader from tape" \
	comment=0xbde7,"(+determine phase of signal)" \
	comment=0xbde7,"mask interrupts" \
	comment=0xbde9,"cassette relay on" \
	comment=0xbdeb,"phase lock counter" \
	comment=0xbded,"synchronise to in-phase wave (+ve then -ve)" \
	comment=0xbdef,"test +ve wave" \
	comment=0xbdf1,"0 or bad" \
	comment=0xbdf3,"test -ve wave" \
	comment=0xbdf5,"1 or bad" \
	comment=0xbdf7,"add 1 for each antiphase pair of cycles" \
	comment=0xbdff,"test -ve wave" \
	comment=0xbe01,"0 or bad" \
	comment=0xbe03,"test +ve wave" \
	comment=0xbe05,"1 or bad" \
	comment=0xbe07,"subtract 1 for each in-phase pair of cycles" \
	comment=0xbe0b,"SUBA #-\$60" \
	comment=0xbe0d,"need \$60 locks in a row (\$18 leader bytes)" \
	comment=0xbe0f,"phase flag" \
	comment=0xbe12,"write byte out to tape (A)" \
	comment=0xbe14,"send LSB first" \
	comment=0xbe16,"wave table" \
	comment=0xbe1a,"inter-wave level" \
	comment=0xbe21,"high frequency for 1" \
	comment=0xbe23,"low frequency for 0" \
	comment=0xbe29,"done 0" \
	comment=0xbe36,"done 1" \
	comment=0xbe3d,"inter-wave level" \
	comment=0xbe40,"do next bit" \
	comment=0xbe44,"wave table for cassette output" \
	comment=0xbe68,"write leader to tape" \
	comment=0xbe6a,"mask interrupts" \
	comment=0xbe6c,"cassette relay on" \
	comment=0xbe71,"cassette leader byte count" \
	comment=0xbe73,"write byte out to tape" \
	comment=0xbe77,"do next byte" \
	comment=0xbe7b,"read character from serial port into A" \
	comment=0xbe7d,"mask interrupts" \
	comment=0xbe86,"set DTR" \
	comment=0xbe8b,"wait until RX full" \
	comment=0xbe90,"clear DTR" \
	comment=0xbe98,"write character to serial port (A)" \
	comment=0xbe9c,"wait until TX ready" \
	comment=0xbea6,"serial baud rate select" \
	comment=0xbea6,"(parameter in B is as per DLOAD)" \
	comment=0xbea8,"B must be 0 - 6" \
	comment=0xbeaa,"serial baud setup table" \
	comment=0xbebe,"serial port baud setup table" \
	comment=0xbec4,"odd byte?" \
	comment=0xbec5,"printer direct out (continued from \$BCF5)" \
	comment=0xbecb,"printer busy" \
	comment=0xbed6,"wait until keys released" \
	comment=0xbedd,"send character to serial port" \
	comment=0xbee0,"scan keyboard continued" \
	comment=0xbee4,"key pressed" \
	comment=0xbee6,"stores a zero" \
	comment=0xbeea,"ASCII NUL" \
	comment=0xbeec,"repeat delay" \
	comment=0xbeef,"current key" \
	comment=0xbef2,"same key pressed - use normal repeat rate" \
	comment=0xbef5,"set up initial repeat delay" \
	comment=0xbef7,"repeat counter" \
	comment=0xbefa,"current key" \
	comment=0xbeff,"D64 extension to start up reset routine" \
	comment=0xbeff,"printer type flag" \
	comment=0xbf02,"serial printer EOL delay" \
	comment=0xbf0c,"send printer EOL characters (continued)" \
	comment=0xbf12,"EOL delay" \
	comment=0xbf18,"10ms delay" \
	comment=0xbf20,"D64 alternative IRQ service routine" \
	comment=0xbf20,"(gives autorepeat keys)" \
	comment=0xbf23,"not serial interrupt" \
	comment=0xbf27,"RX not full" \
	comment=0xbf2e,"set DTR low" \
	comment=0xbf32,"force complete keyboard read" \
	comment=0xbf35,"key repeat counter" \
	comment=0xbf38,"not yet..." \
	comment=0xbf3a,"clear key rollover table" \
	comment=0xbf46,"resume with normal IRQ routine" \
	comment=0xbf49,"boot 64K BASIC continued" \
	comment=0xbf49,"(doubles as 64K BASIC soft reset)" \
	comment=0xbf4a,"mask interrupts" \
	comment=0xbf4f,"IO buffer" \
	comment=0xbf54,"copy B bytes from X to U" \
	comment=0xbf57,"IO buffer" \
	comment=0xbf5a,"copied to cassette buffer & executed" \
	comment=0xbf5a,"64K BASIC flag" \
	comment=0xbf71,"64K BASIC checksum" \
	comment=0xbfa5,"?FC ERROR" \
	comment=0xbfa8,"64K BASIC checksum" \
	comment=0xbfbc,"64K BASIC checksum" \
	comment=0xbfd0,"top of RAM" \
	comment=0xbfd2,"top of BASIC RAM" \
	comment=0xbfd4,"top of free string space" \
	comment=0xbfda,"stack root / string storage start" \
	comment=0xbfe1,"soft reset vector" \
	comment=0xbff2,"unused" \
	comment=0xbff2,"\$BFE9 to" \
	comment=0xbff2,"\$BFF1" \
	comment=0xbff2,"interrupt vectors" \
	comment=0xbff2,"SWI3" \
	comment=0xbff4,"SWI2" \
	comment=0xbff6,"FIRQ" \
	comment=0xbff8,"IRQ" \
	comment=0xbffa,"SWI" \
	comment=0xbffc,"NMI" \
	comment=0xbffe,"RESET" \
    d64.rom | tee d64.asm

    ./asm6809.pl --output=d64_asm6809.rom --listing=d64_asm6809.lst d64.asm
    #~ rm d64.asm
)