from django.conf import settings
from django.contrib import admin
from nested_admin import NestedStackedInline, NestedTabularInline, NestedModelAdmin

from .models import (
    TestAdminWidgetsRoot, TestAdminWidgetsM2M, TestAdminWidgetsRelated1,
    TestAdminWidgetsRelated2, TestAdminWidgetsA, TestAdminWidgetsB,
    TestAdminWidgetsC0, TestAdminWidgetsC1, TestAdminWidgetsM2MTwo,
    TestWidgetMediaOrderRoot, TestWidgetMediaOrderA, TestWidgetMediaOrderB,
    TestWidgetMediaOrderC0, TestWidgetMediaOrderC1)


class TestAdminWidgetsC0Inline(NestedStackedInline):
    model = TestAdminWidgetsC0
    prepopulated_fields = {'slug': ('name', )}
    filter_horizontal = ['m2m']
    sortable_field_name = "position"
    extra = 0
    inline_classes = ("grp-collapse", "grp-open",)
    raw_id_fields = ['fk2', 'fk4', 'm2m_two', 'm2m_three']
    autocomplete_lookup_fields = {
        'fk': ['fk2'],
        'm2m': ['m2m_three'],
        'generic': [['relation_type', 'relation_id']],
    }
    autocomplete_fields = ['fk3']
    related_lookup_fields = {
        'fk': ['fk4'],
        'm2m': ['m2m_two'],
        'generic': [['content_type', 'object_id']],
    }


class TestAdminWidgetsC1Inline(NestedTabularInline):
    model = TestAdminWidgetsC1
    prepopulated_fields = {'slug': ('name', )}
    filter_horizontal = ['m2m']
    sortable_field_name = "position"
    extra = 0
    inline_classes = ("grp-collapse", "grp-open",)
    raw_id_fields = ['fk2', 'fk4', 'm2m_two']
    autocomplete_lookup_fields = {'fk': ['fk2']}
    autocomplete_fields = ['fk3']
    related_lookup_fields = {
        'fk': ['fk4'],
        'm2m': ['m2m_two'],
        'generic': [['content_type', 'object_id']],
    }


class TestAdminWidgetsBInline(NestedStackedInline):
    model = TestAdminWidgetsB
    inlines = [TestAdminWidgetsC0Inline, TestAdminWidgetsC1Inline]
    prepopulated_fields = {'slug': ('name', )}
    filter_horizontal = ['m2m']
    sortable_field_name = "position"
    extra = 1
    inline_classes = ("grp-collapse", "grp-open",)
    raw_id_fields = ['fk2', 'fk4', 'm2m_two', 'm2m_three']
    autocomplete_lookup_fields = {
        'fk': ['fk2'],
        'm2m': ['m2m_three'],
        'generic': [['relation_type', 'relation_id']],
    }
    autocomplete_fields = ['fk3']
    related_lookup_fields = {
        'fk': ['fk4'],
        'm2m': ['m2m_two'],
        'generic': [['content_type', 'object_id']],
    }


class TestAdminWidgetsAInline(NestedStackedInline):
    model = TestAdminWidgetsA
    inlines = [TestAdminWidgetsBInline]
    prepopulated_fields = {'slug': ('name', )}
    filter_horizontal = ['m2m']
    sortable_field_name = "position"
    extra = 1
    inline_classes = ("grp-collapse", "grp-open",)
    raw_id_fields = ['fk2', 'fk4', 'm2m_two', 'm2m_three']
    autocomplete_lookup_fields = {
        'fk': ['fk2'],
        'm2m': ['m2m_three'],
        'generic': [['relation_type', 'relation_id']],
    }
    autocomplete_fields = ['fk3']
    related_lookup_fields = {
        'fk': ['fk4'],
        'm2m': ['m2m_two'],
        'generic': [['content_type', 'object_id']],
    }


@admin.register(TestAdminWidgetsRoot)
class TestAdminWidgetsRootAdmin(NestedModelAdmin):
    inlines = [TestAdminWidgetsAInline]


admin.site.register(TestAdminWidgetsRelated1, NestedModelAdmin)
admin.site.register(TestAdminWidgetsM2M, NestedModelAdmin)
admin.site.register(TestAdminWidgetsM2MTwo, NestedModelAdmin)


@admin.register(TestAdminWidgetsRelated2)
class TestAdminWidgetsRelated2Admin(NestedModelAdmin):
    ordering = ['-date_created']
    search_fields = ['name']


class TestWidgetMediaOrderC0Inline(NestedStackedInline):
    model = TestWidgetMediaOrderC0
    sortable_field_name = "position"
    extra = 0


class TestWidgetMediaOrderC1Inline(NestedTabularInline):
    model = TestWidgetMediaOrderC1
    prepopulated_fields = {'slug': ('name', )}
    filter_horizontal = ['m2m']
    extra = 0
    inline_classes = ("grp-collapse", "grp-open",)
    raw_id_fields = ['fk2']
    autocomplete_lookup_fields = {'fk': ['fk2']}
    autocomplete_fields = ['fk3']


class TestWidgetMediaOrderBInline(NestedStackedInline):
    model = TestWidgetMediaOrderB
    inlines = [TestWidgetMediaOrderC0Inline, TestWidgetMediaOrderC1Inline]
    sortable_field_name = "position"
    extra = 1
    inline_classes = ("grp-collapse", "grp-open",)


class TestWidgetMediaOrderAInline(NestedStackedInline):
    model = TestWidgetMediaOrderA
    inlines = [TestWidgetMediaOrderBInline]
    sortable_field_name = "position"
    extra = 1
    inline_classes = ("grp-collapse", "grp-open",)


@admin.register(TestWidgetMediaOrderRoot)
class TestWidgetMediaOrderRootAdmin(NestedModelAdmin):
    inlines = [TestWidgetMediaOrderAInline]
