# Generated by Django 3.2.6 on 2021-08-25 17:40

import ckeditor.fields
import django.contrib.sites.managers
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('core', '0020_pdf_file_person_optional'),
        ('sites', '0002_alter_domain_unique'),
    ]

    operations = [
        migrations.CreateModel(
            name='EvaluationPart',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', models.JSONField(default=dict, editable=False)),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('order', models.IntegerField(verbose_name='Order')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.site')),
            ],
            options={
                'verbose_name': 'Evaluation part',
                'verbose_name_plural': 'Evaluation parts',
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name='EvaluationPhase',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', models.JSONField(default=dict, editable=False)),
                ('name', models.CharField(max_length=255, verbose_name='Display Name')),
                ('registration_date_start', models.DateField(verbose_name='First date teachers can register themselves for evaluation')),
                ('registration_date_end', models.DateField(verbose_name='Last date teachers can register themselves for evaluation')),
                ('evaluation_date_start', models.DateField(verbose_name='First date teachers can start the evaluation')),
                ('evaluation_date_end', models.DateField(verbose_name='Date when all evaluations stop')),
                ('results_date_start', models.DateField(verbose_name='First date teachers can see results')),
                ('privacy_notice', ckeditor.fields.RichTextField(verbose_name='Privacy notice which teachers have to agree')),
                ('evaluated_group', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='core.group', verbose_name='Group with teachers which can register for evaluation')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.site')),
            ],
            options={
                'verbose_name': 'Evaluation phase',
                'verbose_name_plural': 'Evaluation phases',
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name='EvaluationQuestion',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', models.JSONField(default=dict, editable=False)),
                ('order', models.IntegerField(verbose_name='Order')),
                ('name', models.CharField(help_text='as shown in results', max_length=255, verbose_name='Name')),
                ('question', ckeditor.fields.RichTextField(help_text='as shown on evaluation form', verbose_name='Question')),
                ('question_type', models.CharField(choices=[('free_text', 'Free text'), ('agreement', 'Agreement')], max_length=255, verbose_name='Question type')),
                ('part', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='evalu.evaluationpart', verbose_name='Evaluation part')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.site')),
            ],
            options={
                'verbose_name': 'Evaluation question',
                'verbose_name_plural': 'Evaluation questions',
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name='EvaluationRegistration',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', models.JSONField(default=dict, editable=False)),
                ('privacy_accepted', models.BooleanField(verbose_name='Privacy notice accepted')),
                ('privacy_accepted_at', models.DateTimeField(verbose_name='Privacy notice accepted at')),
                ('gpg_keys', models.TextField(editable=False, verbose_name='GPG keys used to encrypt the evaluation')),
                ('person', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.person', verbose_name='Evaluated person')),
                ('phase', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='evalu.evaluationphase', verbose_name='Evaluation phase')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.site')),
            ],
            options={
                'verbose_name': 'Evaluation registration',
                'verbose_name_plural': 'Evaluation registrations',
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name='EvaluationResult',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', models.JSONField(default=dict, editable=False)),
                ('result', models.TextField(verbose_name='Encrypted result')),
                ('question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='evalu.evaluationquestion', verbose_name='Question')),
                ('registration', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='evalu.evaluationregistration', verbose_name='Evaluated person')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.site')),
            ],
            options={
                'verbose_name': 'Evaluation result',
                'verbose_name_plural': 'Evaluation results',
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name='EvaluationGroup',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', models.JSONField(default=dict, editable=False)),
                ('unlocked', models.BooleanField(default=False, verbose_name='Evaluation unlocked')),
                ('group', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='core.group', verbose_name='Group of evaluating persons')),
                ('registration', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='evalu.evaluationregistration', verbose_name='Evaluated person')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.site')),
            ],
            options={
                'verbose_name': 'Evaluation group',
                'verbose_name_plural': 'Evaluation groups',
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name='DoneEvaluation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', models.JSONField(default=dict, editable=False)),
                ('evaluated_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.person', verbose_name='Evaluated by')),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='evalu.evaluationgroup', verbose_name='Evaluation group')),
                ('registration', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='evalu.evaluationregistration', verbose_name='Evaluated person')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.site')),
            ],
            options={
                'verbose_name': 'Done evaluation',
                'verbose_name_plural': 'Done evaluations',
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.AddConstraint(
            model_name='evaluationregistration',
            constraint=models.UniqueConstraint(fields=('person', 'phase', 'site'), name='person_phase_site_unique'),
        ),
        migrations.AddConstraint(
            model_name='evaluationquestion',
            constraint=models.UniqueConstraint(fields=('part', 'site', 'order'), name='part_site_order_unique'),
        ),
        migrations.AddConstraint(
            model_name='evaluationpart',
            constraint=models.UniqueConstraint(fields=('order', 'site'), name='order_site_unique'),
        ),
        migrations.AddConstraint(
            model_name='evaluationpart',
            constraint=models.UniqueConstraint(fields=('name', 'site'), name='name_site_unique'),
        ),
        migrations.AddConstraint(
            model_name='evaluationgroup',
            constraint=models.UniqueConstraint(fields=('registration', 'group', 'site'), name='registration_group_site_unique'),
        ),
        migrations.AddConstraint(
            model_name='doneevaluation',
            constraint=models.UniqueConstraint(fields=('registration', 'group', 'evaluated_by', 'site'), name='registration_group_evaluated_by_site_unique'),
        ),
    ]
