/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import py4j.NetworkUtil;
import py4j.Py4JNetworkException;

public class CallbackConnection {
    private boolean used;
    private final int DEFAULT_NONBLOCKING_SO_TIMEOUT = 1000;
    private final int port;
    private final InetAddress address;
    private Socket socket;
    private BufferedReader reader;
    private BufferedWriter writer;
    private final Logger logger = Logger.getLogger(CallbackConnection.class.getName());

    public CallbackConnection(int port, InetAddress address) {
        this.port = port;
        this.address = address;
    }

    public String sendCommand(String command) {
        return this.sendCommand(command, true);
    }

    public String sendCommand(String command, boolean blocking) {
        this.logger.log(Level.INFO, "Sending CB command: " + command);
        String returnCommand = null;
        try {
            this.used = true;
            this.writer.write(command);
            this.writer.flush();
            returnCommand = blocking ? this.readBlockingResponse(this.reader) : this.readNonBlockingResponse(this.socket, this.reader);
        }
        catch (Exception e) {
            throw new Py4JNetworkException("Error while sending a command: " + command, e);
        }
        this.logger.log(Level.INFO, "Returning CB command: " + returnCommand);
        return returnCommand;
    }

    protected String readBlockingResponse(BufferedReader reader) throws IOException {
        return reader.readLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readNonBlockingResponse(Socket socket, BufferedReader reader) throws IOException {
        String returnCommand = null;
        socket.setSoTimeout(1000);
        try {
            returnCommand = reader.readLine();
        }
        finally {
            socket.setSoTimeout(0);
        }
        socket.setSoTimeout(0);
        return returnCommand;
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    public void shutdown() {
        NetworkUtil.quietlyClose(this.reader);
        NetworkUtil.quietlyClose(this.writer);
        NetworkUtil.quietlyClose(this.socket);
    }

    public void start() throws IOException {
        this.logger.info("Starting Communication Channel on " + this.address + " at " + this.port);
        this.socket = new Socket(this.address, this.port);
        this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), Charset.forName("UTF-8")));
        this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), Charset.forName("UTF-8")));
    }

    public boolean wasUsed() {
        return this.used;
    }
}

