# Copyright (c) 2022 Qumulo, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may not
# use this file except in compliance with the License. You may obtain a copy of
# the License at http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations under
# the License.


from typing import Optional, TypedDict

import qumulo.lib.request as request

from qumulo.lib.auth import Credentials


class ApiV3UpgradeSettings(TypedDict):
    auto_commit: bool
    install_path: str
    target_version: str
    upgrade_type: str


class ApiV3UpgradeStatus(TypedDict):
    error_info: Optional[str]
    progress: Optional[int]
    settings: Optional[ApiV3UpgradeSettings]
    state: str


@request.request
def status(
    conninfo: request.Connection, _credentials: Optional[Credentials]
) -> request.RestResponse:
    method = 'GET'
    uri = '/v3/upgrade/status'
    return conninfo.send_request(method, uri)
