# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_only_resource_py3 import ProxyOnlyResource


class SitePhpErrorLogFlag(ProxyOnlyResource):
    """Used for getting PHP error logging flag.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param local_log_errors: Local log_errors setting.
    :type local_log_errors: str
    :param master_log_errors: Master log_errors setting.
    :type master_log_errors: str
    :param local_log_errors_max_length: Local log_errors_max_len setting.
    :type local_log_errors_max_length: str
    :param master_log_errors_max_length: Master log_errors_max_len setting.
    :type master_log_errors_max_length: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'local_log_errors': {'key': 'properties.localLogErrors', 'type': 'str'},
        'master_log_errors': {'key': 'properties.masterLogErrors', 'type': 'str'},
        'local_log_errors_max_length': {'key': 'properties.localLogErrorsMaxLength', 'type': 'str'},
        'master_log_errors_max_length': {'key': 'properties.masterLogErrorsMaxLength', 'type': 'str'},
    }

    def __init__(self, *, kind: str=None, local_log_errors: str=None, master_log_errors: str=None, local_log_errors_max_length: str=None, master_log_errors_max_length: str=None, **kwargs) -> None:
        super(SitePhpErrorLogFlag, self).__init__(kind=kind, **kwargs)
        self.local_log_errors = local_log_errors
        self.master_log_errors = master_log_errors
        self.local_log_errors_max_length = local_log_errors_max_length
        self.master_log_errors_max_length = master_log_errors_max_length
