# Generated by Django 3.1.2 on 2021-02-24 06:18

from django.db import migrations


def make_voucher_names_unique(apps, schema_editor):
    """
    Appends a number to non-unique voucher names.
    """
    Voucher = apps.get_model('voucher', 'Voucher')
    vouchers = Voucher.objects.order_by('date_created')
    # Find vouchers with non-unique names
    vouchers_for_name = {}
    for voucher in vouchers:
        if voucher.name not in vouchers_for_name:
            vouchers_for_name[voucher.name] = []
        vouchers_for_name[voucher.name].append(voucher.id)
    # Change names for vouchers with non-unique names
    for voucher in vouchers:
        if len(vouchers_for_name[voucher.name]) > 1:
            voucher.name = "%s - %d" % (voucher.name, vouchers_for_name[voucher.name].index(voucher.id) + 1)
            voucher.save()


class Migration(migrations.Migration):

    dependencies = [
        ('voucher', '0008_auto_20200801_0817'),
    ]

    operations = [
        migrations.RunPython(make_voucher_names_unique, migrations.RunPython.noop),
    ]
