#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['fastapi', 'fastapi.dependencies', 'fastapi.openapi', 'fastapi.security']

package_data = \
{'': ['*']}

install_requires = \
['starlette >=0.9.7', 'pydantic >=0.16']

extras_require = \
{'all': ['requests',
         'aiofiles',
         'jinja2',
         'python-multipart',
         'itsdangerous',
         'pyyaml',
         'graphene',
         'ujson',
         'ujson',
         'email_validator',
         'uvicorn'],
 'dev': ['prospector', 'rope'],
 'doc': ['mkdocs', 'mkdocs-material', 'markdown-include'],
 'test': ['pytest >=4.0.0', 'pytest-cov', 'mypy', 'black', 'isort', 'requests']}

setup(name='fastapi',
      version='0.1.11',
      description='FastAPI framework, high performance, easy to learn, fast to code, ready for production',
      author='Sebastián Ramírez',
      author_email='tiangolo@gmail.com',
      url='https://github.com/tiangolo/fastapi',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.6',
     )
