import { JupyterFrontEnd } from '@jupyterlab/application';
import { ReactWidget } from '@jupyterlab/apputils';
import { DocumentRegistry, ABCWidgetFactory, DocumentWidget } from '@jupyterlab/docregistry';
import { IFileBrowserFactory } from '@jupyterlab/filebrowser';
import { IconRegistry, IIconRegistry } from '@jupyterlab/ui-components';
import '@elyra/canvas/dist/common-canvas.min.css';
import '@elyra/canvas/dist/common-canvas.min.css';
import 'carbon-components/css/carbon-components.min.css';
import * as React from 'react';
export declare const commandIDs: {
    openPipelineEditor: string;
    openDocManager: string;
    newDocManager: string;
};
/**
 * Wrapper Class for Common Canvas React Component
 */
export declare class PipelineEditorWidget extends ReactWidget {
    app: JupyterFrontEnd;
    browserFactory: IFileBrowserFactory;
    context: DocumentRegistry.Context;
    iconRegistry: IconRegistry;
    constructor(props: any);
    render(): React.ReactElement;
}
/**
 * A namespace for Pipeline.
 */
export declare namespace PipelineEditor {
    /**
     * The props for PipelineEditor.
     */
    interface IProps {
        app: JupyterFrontEnd;
        browserFactory: IFileBrowserFactory;
        iconRegistry: IIconRegistry;
        widgetContext: DocumentRegistry.Context;
    }
    /**
     * The props for PipelineEditor.
     */
    interface IState {
        /**
         * Whether the properties dialog is visible.
         */
        showPropertiesDialog: boolean;
        /**
         * The form contents of the properties dialog.
         */
        propertiesInfo: any;
    }
}
/**
 * Class for Common Canvas React Component
 */
export declare class PipelineEditor extends React.Component<PipelineEditor.IProps, PipelineEditor.IState> {
    app: JupyterFrontEnd;
    browserFactory: IFileBrowserFactory;
    iconRegistry: IconRegistry;
    canvasController: any;
    widgetContext: DocumentRegistry.Context;
    position: number;
    node: React.RefObject<HTMLDivElement>;
    constructor(props: any);
    render(): any;
    propertiesInfo: {
        parameterDef: any;
        appData: {
            id: string;
        };
    };
    addDockerImages(properties: any): any;
    openPropertiesDialog(source: any): void;
    applyPropertyChanges(propertySet: any, appData: any): void;
    closePropertiesDialog(): void;
    contextMenuHandler(source: any, defaultMenu: any): any;
    contextMenuActionHandler(action: any, source: any): void;
    editActionHandler(data: any): void;
    handleAdd(x?: number, y?: number): Promise<any>;
    handleRun(): void;
    handleSave(): void;
    handleOpen(): void;
    handleNew(): void;
    handleClear(): Promise<any>;
    /**
     * Handles submitting pipeline runs
     */
    toolbarMenuActionHandler(action: any, source: any): void;
    componentDidMount(): void;
    componentWillUnmount(): void;
    /**
     * Handle the DOM events.
     *
     * @param event - The DOM event.
     */
    handleEvent(event: Event): void;
}
export declare class PipelineEditorFactory extends ABCWidgetFactory<DocumentWidget> {
    app: JupyterFrontEnd;
    browserFactory: IFileBrowserFactory;
    iconRegistry: IconRegistry;
    constructor(options: any);
    protected createNewWidget(context: DocumentRegistry.Context): DocumentWidget;
}
