import * as React from 'react';
import { classes } from 'typestyle';
import { fileChangedLabelBrandStyle, fileChangedLabelInfoStyle, fileChangedLabelStyle, fileStyle, gitMarkBoxStyle, selectedFileChangedLabelStyle, selectedFileStyle } from '../style/FileItemStyle';
import { openListedFile } from '../utils';
import { FilePath } from './FilePath';
// Git status codes https://git-scm.com/docs/git-status
export const STATUS_CODES = {
    M: 'Modified',
    A: 'Added',
    D: 'Deleted',
    R: 'Renamed',
    C: 'Copied',
    U: 'Updated',
    '?': 'Untracked',
    '!': 'Ignored'
};
export class FileItem extends React.Component {
    getFileChangedLabel(change) {
        return STATUS_CODES[change];
    }
    getFileChangedLabelClass(change) {
        if (change === 'M') {
            return this.props.selected
                ? classes(fileChangedLabelStyle, fileChangedLabelBrandStyle, selectedFileChangedLabelStyle)
                : classes(fileChangedLabelStyle, fileChangedLabelBrandStyle);
        }
        else {
            return this.props.selected
                ? classes(fileChangedLabelStyle, fileChangedLabelInfoStyle, selectedFileChangedLabelStyle)
                : classes(fileChangedLabelStyle, fileChangedLabelInfoStyle);
        }
    }
    getFileClass() {
        return this.props.selected
            ? classes(fileStyle, selectedFileStyle)
            : fileStyle;
    }
    render() {
        const status = this.getFileChangedLabel(this.props.file.y) ||
            this.getFileChangedLabel(this.props.file.x);
        return (React.createElement("li", { className: this.getFileClass(), onClick: this.props.selectFile &&
                (() => this.props.selectFile(this.props.file)), onContextMenu: this.props.contextMenu &&
                (event => {
                    if (this.props.selectFile) {
                        this.props.selectFile(this.props.file);
                    }
                    this.props.contextMenu(event);
                }), onDoubleClick: () => {
                openListedFile(this.props.file, this.props.model);
            }, title: `${this.props.file.to} ● ${status}` },
            this.props.markBox && (React.createElement(GitMarkBox, { fname: this.props.file.to, stage: this.props.file.status, model: this.props.model })),
            React.createElement(FilePath, { filepath: this.props.file.to, selected: this.props.selected }),
            this.props.actions,
            React.createElement("span", { className: this.getFileChangedLabelClass(this.props.file.y) }, this.props.file.y === '?'
                ? 'U'
                : this.props.file.y.trim() || this.props.file.x)));
    }
}
export class GitMarkBox extends React.Component {
    constructor(props) {
        super(props);
        this._onClick = (event) => {
            // toggle will emit a markChanged signal
            this.props.model.toggleMark(this.props.fname);
            // needed if markChanged doesn't force an update of a parent
            this.forceUpdate();
        };
        this._onDoubleClick = (event) => {
            event.stopPropagation();
        };
    }
    render() {
        // idempotent, will only run once per file
        this.props.model.addMark(this.props.fname, this.props.stage !== 'untracked');
        return (React.createElement("input", { name: "gitMark", className: gitMarkBoxStyle, type: "checkbox", checked: this.props.model.getMark(this.props.fname), onChange: this._onClick, onDoubleClick: this._onDoubleClick }));
    }
}
//# sourceMappingURL=FileItem.js.map