# pmx  Copyright Notice
# ============================
#
# The pmx source code is copyrighted, but you can freely use and
# copy it as long as you don't change or remove any of the copyright
# notices.
#
# ----------------------------------------------------------------------
# pmx is Copyright (C) 2006-2018 by Daniel Seeliger
#
#                        All Rights Reserved
#
# Permission to use, copy, modify, distribute, and distribute modified
# versions of this software and its documentation for any purpose and
# without fee is hereby granted, provided that the above copyright
# notice appear in all copies and that both the copyright notice and
# this permission notice appear in supporting documentation, and that
# the name of Daniel Seeliger not be used in advertising or publicity
# pertaining to distribution of the software without specific, written
# prior permission.
#
# DANIEL SEELIGER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
# SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS.  IN NO EVENT SHALL DANIEL SEELIGER BE LIABLE FOR ANY
# SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
# RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
# CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
# CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
# ----------------------------------------------------------------------

"""**pmx** is a essentially a collection of classes and functions that allow
the manipulation of molecular structure and topolofy files. It has been thought
to be mainly used in conjunction with the Gromacs simulation package. In fact,
**pmx** makes use of some Gromacs functions to read/write trajectory data
and to allow fast neighborsearching from a python script. With time, **pmx**
has also become a library for the setup and analysis of alchemical free energy
calculations in Gromacs."""


from .atom import Atom
from .molecule import Molecule
from .chain import Chain
from .model import Model
from .forcefield import Topology
from .estimators import BAR, Crooks, Jarz
from .analysis import *
from .alchemy import *
from . import gmx

from ._version import get_versions
__version__ = get_versions()['version']
del get_versions
