import argparse

import annofabcli
import annofabcli.annotation_specs.list_annotation_specs_history
import annofabcli.annotation_specs.list_annotation_specs_label
import annofabcli.annotation_specs.print_label_color
import annofabcli.common.cli


def parse_args(parser: argparse.ArgumentParser):

    subparsers = parser.add_subparsers(dest='subcommand_name')

    # サブコマンドの定義
    annofabcli.annotation_specs.list_annotation_specs_history.add_parser(subparsers)
    annofabcli.annotation_specs.list_annotation_specs_label.add_parser(subparsers)
    annofabcli.annotation_specs.print_label_color.add_parser(subparsers)


def add_parser(subparsers: argparse._SubParsersAction):
    subcommand_name = "annotation_specs"
    subcommand_help = "アノテーション仕様関係のサブコマンド"
    description = "アノテーション仕様関係のサブコマンド"

    parser = annofabcli.common.cli.add_parser(subparsers, subcommand_name, subcommand_help, description)
    parse_args(parser)
