
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, List
from ...types.theme import TypeTheme
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_document import TypeInputDocument
    from ...types.input_theme_settings import TypeInputThemeSettings


class CreateTheme(TLRequest[TypeTheme]):
    """
    Create a theme

    Raises:
        `400`ThemeMimeInvalidError: The theme's MIME type is invalid.
        `400`ThemeTitleInvalidError: The specified theme title is invalid.

    """

    _id = 0X652E4400
    _result_id = 0X5E6FFFBC

    def __init__(
        self,
        slug: str,
        title: str,
        document: Optional['TypeInputDocument'] = None,
        settings: Optional[List['TypeInputThemeSettings']] = None
    ):

        """
        Create a theme

        Args:
            slug (str): Unique theme ID used to generate [theme deep links](https://core.telegram.org/api/links#theme-links), can be empty to autogenerate a random ID.
            title (str): Theme name
            document (Optional['TypeInputDocument'], optional): Theme file
            settings (Optional[List['TypeInputThemeSettings']], optional): Theme settings, multiple values can be provided for the different base themes (day/night mode, etc).
        """

        self.slug = slug
        self.title = title
        self.document = document
        self.settings = settings

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x00D.e' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.slug)
                writer.string(self.title)

                if flags(self.document, 2):
                    writer.object(
                        self.document,
                        group_id=0X84313E
                    )

                if flags(self.settings, 3):
                    writer.vector(
                        self.settings,
                        lambda value: writer.object(
                            value,
                            group_id=0X7B33F03A
                        )
                    )

            return writer.getvalue()