
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


class BindTempAuthKey(TLRequest[bool]):
    """
    Binds a temporary authorization key temp_auth_key_id to the permanent authorization key perm_auth_key_id. Each permanent key may only be bound to one temporary key at a time, binding a new temporary key overwrites the previous one.

    **Bots can use this method**

    Raises:
        `400`EncryptedMessageInvalidError: Encrypted message invalid.
        `400`TempAuthKeyAlreadyBoundError: The passed temporary key is already bound to another **perm_auth_key_id**.
        `400`TempAuthKeyEmptyError: No temporary auth key provided.

    """

    _id = 0XCDD42A05
    _result_id = 0X43B904E1

    def __init__(
        self,
        perm_auth_key_id: int,
        nonce: int,
        expires_at: int,
        encrypted_message: bytes
    ):

        """
        Binds a temporary authorization key temp_auth_key_id to the permanent authorization key perm_auth_key_id. Each permanent key may only be bound to one temporary key at a time, binding a new temporary key overwrites the previous one.

        **Bots can use this method**

        Args:
            perm_auth_key_id (int): Permanent auth_key_id to bind to
            nonce (int): Random long from [Binding message contents](https://core.telegram.org#binding-message-contents)
            expires_at (int): Unix timestamp to invalidate temporary key, see [Binding message contents](https://core.telegram.org#binding-message-contents)
            encrypted_message (bytes): See [Generating encrypted_message](https://core.telegram.org#generating-encrypted-message)
        """

        self.perm_auth_key_id = perm_auth_key_id
        self.nonce = nonce
        self.expires_at = expires_at
        self.encrypted_message = encrypted_message

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x05*\xd4\xcd' if boxed else b'') as writer:
            writer.long(self.perm_auth_key_id)
            writer.long(self.nonce)
            writer.int(self.expires_at)
            writer.bytes(self.encrypted_message)

            return writer.getvalue()