
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


class RequestFirebaseSms(TLRequest[bool]):
    """
    Request an SMS code via Firebase.

    Raises:
        `400`PhoneCodeEmptyError: phone_code is missing.
        `400`PhoneNumberInvalidError: The phone number is invalid.

    """

    _id = 0X8E39261E
    _result_id = 0X43B904E1

    def __init__(
        self,
        phone_number: str,
        phone_code_hash: str,
        safety_net_token: Optional[str] = None,
        play_integrity_token: Optional[str] = None,
        ios_push_secret: Optional[str] = None
    ):

        """
        Request an SMS code via Firebase.

        Args:
            phone_number (str): Phone number
            phone_code_hash (str): Phone code hash returned by [auth.sendCode](https://core.telegram.org/method/auth.sendCode)
            safety_net_token (Optional[str], optional): On Android, a JWS object obtained as described in the [auth documentation](https://core.telegram.org/api/auth)
            play_integrity_token (Optional[str], optional): On Android, an object obtained as described in the [auth documentation](https://core.telegram.org/api/auth)
            ios_push_secret (Optional[str], optional): Secret token received via an apple push notification
        """

        self.phone_number = phone_number
        self.phone_code_hash = phone_code_hash
        self.safety_net_token = safety_net_token
        self.play_integrity_token = play_integrity_token
        self.ios_push_secret = ios_push_secret

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1e&9\x8e' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.phone_number)
                writer.string(self.phone_code_hash)

                if flags(self.safety_net_token, 0):
                    writer.string(self.safety_net_token)

                if flags(self.play_integrity_token, 2):
                    writer.string(self.play_integrity_token)

                if flags(self.ios_push_secret, 1):
                    writer.string(self.ios_push_secret)

            return writer.getvalue()