
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.url_auth_result import TypeUrlAuthResult


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class AcceptUrlAuth(TLRequest[TypeUrlAuthResult]):
    """
    Use this to accept a Seamless Telegram Login authorization request, for more info [click here](https://core.telegram.org/api/url-authorization)
    """

    _id = 0XB12C7125
    _result_id = 0X84DE2148

    def __init__(
        self,
        write_allowed: bool = False,
        peer: Optional['TypeInputPeer'] = None,
        msg_id: Optional[int] = None,
        button_id: Optional[int] = None,
        url: Optional[str] = None
    ):

        """
        Use this to accept a Seamless Telegram Login authorization request, for more info [click here](https://core.telegram.org/api/url-authorization)

        Args:
            write_allowed (bool, optional): Set this flag to allow the bot to send messages to you (if requested)
            peer (Optional['TypeInputPeer'], optional): The location of the message
            msg_id (Optional[int], optional): Message ID of the message with the login button
            button_id (Optional[int], optional): ID of the login button
            url (Optional[str], optional): URL used for [link URL authorization, click here for more info](https://core.telegram.org/api/url-authorization#link-url-authorization)
        """

        self.write_allowed = write_allowed
        self.peer = peer
        self.msg_id = msg_id
        self.button_id = button_id
        self.url = url

    def to_bytes(self, boxed: bool=True):
        with Writer(b'%q,\xb1' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.write_allowed, 0)

                if flags(self.peer, 1):
                    writer.object(
                        self.peer,
                        group_id=0X995DB9DF
                    )

                if flags(self.msg_id, 1):
                    writer.int(self.msg_id)

                if flags(self.button_id, 1):
                    writer.int(self.button_id)

                if flags(self.url, 2):
                    writer.string(self.url)

            return writer.getvalue()