
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.saved_dialogs import TypeMessagesSavedDialogs


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class GetSavedDialogs(TLRequest[TypeMessagesSavedDialogs]):
    """
    Returns the current saved dialog list, see [here](https://core.telegram.org/api/saved-messages) for more info.
    """

    _id = 0X1E91FC99
    _result_id = 0X169239D

    def __init__(
        self,
        offset_date: int,
        offset_id: int,
        offset_peer: 'TypeInputPeer',
        limit: int,
        hash: int,
        exclude_pinned: bool = False,
        parent_peer: Optional['TypeInputPeer'] = None
    ):

        """
        Returns the current saved dialog list, see [here](https://core.telegram.org/api/saved-messages) for more info.

        Args:
            offset_date (int): [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
            offset_id (int): [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets) ( top_message ID used for pagination)
            offset_peer ('TypeInputPeer'): [Offset peer for pagination](https://core.telegram.org/api/offsets)
            limit (int): Number of list elements to be returned
            hash (int): [Hash used for caching, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
            exclude_pinned (bool, optional): Exclude pinned dialogs
            parent_peer (Optional['TypeInputPeer'], optional): ...
        """

        self.offset_date = offset_date
        self.offset_id = offset_id
        self.offset_peer = offset_peer
        self.limit = limit
        self.hash = hash
        self.exclude_pinned = exclude_pinned
        self.parent_peer = parent_peer

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x99\xfc\x91\x1e' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.exclude_pinned, 0)

                if flags(self.parent_peer, 1):
                    writer.object(
                        self.parent_peer,
                        group_id=0X995DB9DF
                    )
                writer.int(self.offset_date)
                writer.int(self.offset_id)
                writer.object(
                    self.offset_peer,
                    group_id=0X995DB9DF
                )
                writer.int(self.limit)
                writer.long(self.hash)

            return writer.getvalue()