
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.history_import import TypeMessagesHistoryImport


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.input_file import TypeInputFile


class InitHistoryImport(TLRequest[TypeMessagesHistoryImport]):
    """
    Import chat history from a foreign chat app into a specific Telegram chat, [click here for more info about imported chats](https://core.telegram.org/api/import).

    Raises:
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `400`ImportFileInvalidError: The specified chat export file is invalid.
        `400`ImportFormatDateInvalidError: The date specified in the import file is invalid.
        `400`ImportFormatUnrecognizedError: The specified chat export file was exported from an unsupported chat app.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `406`PreviousChatImportActiveWaitMinError: Import for this chat is already in progress, wait {minutes} minutes before starting a new one.

    """

    _id = 0X34090C3B
    _result_id = 0X88E82453

    def __init__(
        self,
        peer: 'TypeInputPeer',
        file: 'TypeInputFile',
        media_count: int
    ):

        """
        Import chat history from a foreign chat app into a specific Telegram chat, [click here for more info about imported chats](https://core.telegram.org/api/import).

        Args:
            peer ('TypeInputPeer'): The Telegram chat where the [history should be imported](https://core.telegram.org/api/import).
            file ('TypeInputFile'): File with messages to import.
            media_count (int): Number of media files associated with the chat that will be uploaded using [messages.uploadImportedMedia](https://core.telegram.org/method/messages.uploadImportedMedia).
        """

        self.peer = peer
        self.file = file
        self.media_count = media_count

    def to_bytes(self, boxed: bool=True):
        with Writer(b';\x0c\t4' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0X995DB9DF
            )
            writer.object(
                self.file,
                group_id=0XB7247676
            )
            writer.int(self.media_count)

            return writer.getvalue()