
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, List
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.translated_text import TypeMessagesTranslatedText


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.text_with_entities import TypeTextWithEntities


class TranslateText(TLRequest[TypeMessagesTranslatedText]):
    """
    Translate a given text.

    Raises:
        `400`InputTextEmptyError: The specified text is empty.
        `400`InputTextTooLongError: The specified text is too long.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`ToLangInvalidError: The specified destination language is invalid.
        `400`TranslateReqQuotaExceededError: Translation is currently unavailable due to a temporary server-side lack of resources.
        `500`TranslateReqFailedError: Translation failed, please try again later.

    """

    _id = 0X63183030
    _result_id = 0X10CCC929

    def __init__(
        self,
        to_lang: str,
        peer: Optional['TypeInputPeer'] = None,
        id: Optional[List[int]] = None,
        text: Optional[List['TypeTextWithEntities']] = None
    ):

        """
        Translate a given text.

        Args:
            to_lang (str): Two-letter ISO 639-1 language code of the language to which the message is translated
            peer (Optional['TypeInputPeer'], optional): If the text is a chat message, the peer ID
            id (Optional[List[int]], optional): A list of message IDs to translate
            text (Optional[List['TypeTextWithEntities']], optional): A list of styled messages to translate
        """

        self.to_lang = to_lang
        self.peer = peer
        self.id = id
        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'00\x18c' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.peer, 0):
                    writer.object(
                        self.peer,
                        group_id=0X995DB9DF
                    )

                if flags(self.id, 0):
                    writer.vector(
                        self.id,
                        writer.int
                    )

                if flags(self.text, 1):
                    writer.vector(
                        self.text,
                        lambda value: writer.object(
                            value,
                            group_id=0X5D96896
                        )
                    )
                writer.string(self.to_lang)

            return writer.getvalue()