
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.payments.stars_status import TypePaymentsStarsStatus


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.input_stars_transaction import TypeInputStarsTransaction


class GetStarsTransactionsByID(TLRequest[TypePaymentsStarsStatus]):
    """
    Obtain info about [Telegram Star transactions](https://core.telegram.org/api/stars#balance-and-transaction-history) using specific transaction IDs.

    Raises:
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`TransactionIdInvalidError: The specified transaction ID is invalid.

    """

    _id = 0X2DCA16B8
    _result_id = 0XC88B272F

    def __init__(
        self,
        peer: 'TypeInputPeer',
        id: List['TypeInputStarsTransaction'],
        ton: bool = False
    ):

        """
        Obtain info about [Telegram Star transactions](https://core.telegram.org/api/stars#balance-and-transaction-history) using specific transaction IDs.

        Args:
            peer ('TypeInputPeer'): Channel or bot.
            id (List['TypeInputStarsTransaction']): Transaction IDs.
            ton (bool, optional): ...
        """

        self.peer = peer
        self.id = id
        self.ton = ton

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb8\x16\xca-' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.ton, 0)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.vector(
                    self.id,
                    lambda value: writer.object(
                        value,
                        group_id=0X5AE2C2C9
                    )
                )

            return writer.getvalue()