
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, List
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.media_area import TypeMediaArea
    from ...types.input_media import TypeInputMedia
    from ...types.message_entity import TypeMessageEntity
    from ...types.input_privacy_rule import TypeInputPrivacyRule


class EditStory(TLRequest[TypeUpdates]):
    """
    Edit an uploaded [story](https://core.telegram.org/api/stories)

    Raises:
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`StoryNotModifiedError: The new story information you passed is equal to the previous story information, thus it wasn't modified.

    """

    _id = 0XB583BA46
    _result_id = 0XD68D29C0

    def __init__(
        self,
        peer: 'TypeInputPeer',
        id: int,
        media: Optional['TypeInputMedia'] = None,
        media_areas: Optional[List['TypeMediaArea']] = None,
        caption: Optional[str] = None,
        entities: Optional[List['TypeMessageEntity']] = None,
        privacy_rules: Optional[List['TypeInputPrivacyRule']] = None
    ):

        """
        Edit an uploaded [story](https://core.telegram.org/api/stories)

        Args:
            peer ('TypeInputPeer'): Peer where the story was posted.
            id (int): ID of story to edit.
            media (Optional['TypeInputMedia'], optional): If specified, replaces the story media.
            media_areas (Optional[List['TypeMediaArea']], optional): [Media areas](https://core.telegram.org/api/stories#media-areas) associated to the story, see [here](https://core.telegram.org/api/stories#media-areas) for more info.
            caption (Optional[str], optional): If specified, replaces the story caption.
            entities (Optional[List['TypeMessageEntity']], optional): [Message entities for styled text in the caption](https://core.telegram.org/api/entities), if allowed by the [stories_entities client configuration parameter](https://core.telegram.org/api/config#stories-entities).
            privacy_rules (Optional[List['TypeInputPrivacyRule']], optional): If specified, alters the [privacy settings](https://core.telegram.org/api/privacy) of the story, changing who can or can't view the story.
        """

        self.peer = peer
        self.id = id
        self.media = media
        self.media_areas = media_areas
        self.caption = caption
        self.entities = entities
        self.privacy_rules = privacy_rules

    def to_bytes(self, boxed: bool=True):
        with Writer(b'F\xba\x83\xb5' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.int(self.id)

                if flags(self.media, 0):
                    writer.object(
                        self.media,
                        group_id=0XCEC6DE21
                    )

                if flags(self.media_areas, 3):
                    writer.vector(
                        self.media_areas,
                        lambda value: writer.object(
                            value,
                            group_id=0XA32C529B
                        )
                    )

                if flags(self.caption, 1):
                    writer.string(self.caption)

                if flags(self.entities, 1):
                    writer.vector(
                        self.entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )

                if flags(self.privacy_rules, 2):
                    writer.vector(
                        self.privacy_rules,
                        lambda value: writer.object(
                            value,
                            group_id=0XCA2848B1
                        )
                    )

            return writer.getvalue()