
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..auth.sent_code import TypeAuthSentCode
    from ....gadgets.byteutils import Reader


class EmailVerified(TLObject, family='TypeAccountEmailVerified'):
    """
    The email was verified correctly.
    """

    _id = 0X2B96CD1B
    _group_id = 0X51A41FC9

    def __init__(
        self,
        email: str
    ):

        """
        The email was verified correctly.

        Args:
            email (str): The verified email address.
        """

        self.email = email

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1b\xcd\x96+' if boxed else b'') as writer:
            writer.string(self.email)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        email_ = reader.string()

        return cls(
            email=email_
        )

class EmailVerifiedLogin(TLObject, family='TypeAccountEmailVerified'):
    """
    The email was verified correctly, and a login code was just sent to it.
    """

    _id = 0XE1BB0D61
    _group_id = 0X51A41FC9

    def __init__(
        self,
        email: str,
        sent_code: 'TypeAuthSentCode'
    ):

        """
        The email was verified correctly, and a login code was just sent to it.

        Args:
            email (str): The verified email address.
            sent_code ('TypeAuthSentCode'): Info about the sent [login code](https://core.telegram.org/api/auth)
        """

        self.email = email
        self.sent_code = sent_code

    def to_bytes(self, boxed: bool=True):
        with Writer(b'a\r\xbb\xe1' if boxed else b'') as writer:
            writer.string(self.email)
            writer.object(
                self.sent_code,
                group_id=0X8F0C24F5
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        email_ = reader.string()
        sent_code_ = reader.object(
            group_id=0X8F0C24F5
        )

        return cls(
            email=email_,
            sent_code=sent_code_
        )

TypeAccountEmailVerified = Union[
    EmailVerified,
    EmailVerifiedLogin
]