
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ....gadgets.byteutils import Reader
    from ..secure_secret_settings import TypeSecureSecretSettings


class PasswordSettings(TLObject, family='TypeAccountPasswordSettings'):
    """
    Private info associated to the password info (recovery email, telegram [passport](https://core.telegram.org/passport) info & so on)
    """

    _id = 0X9A5C33E5
    _group_id = 0XD6AEBFD

    def __init__(
        self,
        email: Optional[str] = None,
        secure_settings: Optional['TypeSecureSecretSettings'] = None
    ):

        """
        Private info associated to the password info (recovery email, telegram [passport](https://core.telegram.org/passport) info & so on)

        Args:
            email (Optional[str], optional): [2FA Recovery email](https://core.telegram.org/api/srp#email-verification)
            secure_settings (Optional['TypeSecureSecretSettings'], optional): Telegram [passport](https://core.telegram.org/passport) settings
        """

        self.email = email
        self.secure_settings = secure_settings

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe53\\\x9a' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.email, 0):
                    writer.string(self.email)

                if flags(self.secure_settings, 1):
                    writer.object(
                        self.secure_settings,
                        group_id=0XC2D666DE
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        email_ = (
            reader.string()
            if flags(0) else None
        )

        secure_settings_ = (
            reader.object(
                group_id=0XC2D666DE
            )
            if flags(1) else None
        )

        return cls(
            email=email_,
            secure_settings=secure_settings_
        )

TypeAccountPasswordSettings = PasswordSettings