
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, List
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..theme import TypeTheme
    from ....gadgets.byteutils import Reader


class ThemesNotModified(TLObject, family='TypeAccountThemes'):
    """
    No new themes were installed
    """

    _id = 0XF41EB622
    _group_id = 0XEE9CA3A6


    def to_bytes(self, boxed: bool=True):
        return b'"\xb6\x1e\xf4' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class Themes(TLObject, family='TypeAccountThemes'):
    """
    Installed themes
    """

    _id = 0X9A3D8C6D
    _group_id = 0XEE9CA3A6

    def __init__(
        self,
        hash: int,
        themes: List['TypeTheme']
    ):

        """
        Installed themes

        Args:
            hash (int): [Hash used for caching, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
            themes (List['TypeTheme']): Themes
        """

        self.hash = hash
        self.themes = themes

    def to_bytes(self, boxed: bool=True):
        with Writer(b'm\x8c=\x9a' if boxed else b'') as writer:
            writer.long(self.hash)
            writer.vector(
                self.themes,
                lambda value: writer.object(
                    value,
                    group_id=0X5E6FFFBC
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        hash_ = reader.long()
        themes_ = reader.vector(
            lambda: reader.object(
                group_id=0X5E6FFFBC
            )
        )

        return cls(
            hash=hash_,
            themes=themes_
        )

TypeAccountThemes = Union[
    ThemesNotModified,
    Themes
]