
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, List
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .document import TypeDocument
    from ...gadgets.byteutils import Reader
    from .attach_menu_bot_icon_color import TypeAttachMenuBotIconColor


class AttachMenuBotIcon(TLObject, family='TypeAttachMenuBotIcon'):
    """
    Represents an attachment menu icon for [bot mini apps](https://core.telegram.org/api/bots/attach)
    """

    _id = 0XB2A7386B
    _group_id = 0XE9DE9488

    def __init__(
        self,
        name: str,
        icon: 'TypeDocument',
        colors: Optional[List['TypeAttachMenuBotIconColor']] = None
    ):

        """
        Represents an attachment menu icon for [bot mini apps](https://core.telegram.org/api/bots/attach)

        Args:
            name (str): One of the following values: note that animated icons must be played when the user clicks on the button, activating the bot mini app. default_static - Default attachment menu icon in SVG format placeholder_static - Default placeholder for opened Web Apps in SVG format ios_static - Attachment menu icon in SVG format for the official iOS app ios_animated - Animated attachment menu icon in TGS format for the official iOS app android_animated - Animated attachment menu icon in TGS format for the official Android app macos_animated - Animated attachment menu icon in TGS format for the official native Mac OS app ios_side_menu_static - Side menu icon in PNG format for the official iOS app android_side_menu_static - Side menu icon in SVG format for the official android app macos_side_menu_static - Side menu icon in PNG format for the official native Mac OS app
            icon ('TypeDocument'): The actual icon file.
            colors (Optional[List['TypeAttachMenuBotIconColor']], optional): Attachment menu icon colors.
        """

        self.name = name
        self.icon = icon
        self.colors = colors

    def to_bytes(self, boxed: bool=True):
        with Writer(b'k8\xa7\xb2' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.name)
                writer.object(
                    self.icon,
                    group_id=0X6547BD50
                )

                if flags(self.colors, 0):
                    writer.vector(
                        self.colors,
                        lambda value: writer.object(
                            value,
                            group_id=0X1C88BAD2
                        )
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        name_ = reader.string()
        icon_ = reader.object(
            group_id=0X6547BD50
        )

        colors_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X1C88BAD2
                )
            )
            if flags(0) else None
        )

        return cls(
            name=name_,
            icon=icon_,
            colors=colors_
        )

TypeAttachMenuBotIcon = AttachMenuBotIcon